/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.handler;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployPaletteConfigurationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        this.doExecute(selection, activeShell, (IProgressMonitor)new NullProgressMonitor());
        return null;
    }

    protected void doExecute(IStructuredSelection selection, Shell activeShell, IProgressMonitor monitor) {
        Iterator selectionIterator = selection.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.papyrus.uml.diagram.common", 0, "The palette configuration has been successfully deployed and activated", null);
        while (selectionIterator.hasNext()) {
            Set<Object> requiredProfiles;
            String paletteName;
            Object selectedElement = selectionIterator.next();
            if (!(selectedElement instanceof IAdaptable)) continue;
            IFile selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class);
            if (selectedFile == null) {
                monitor.worked(1);
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.uml.diagram.common", "The selected element is not a file"));
                continue;
            }
            String fileName = selectedFile.getFullPath().removeFileExtension().lastSegment();
            monitor.subTask("Deploy " + fileName);
            boolean alreadyDeployed = false;
            ProviderPriority priority = this.getPriority(fileName);
            if (priority == null) {
                priority = ProviderPriority.MEDIUM;
            } else {
                alreadyDeployed = true;
            }
            String editorID = this.getEditorID(fileName);
            if (editorID != null) {
                alreadyDeployed = true;
            }
            if ((paletteName = this.getPaletteName(fileName)) != null) {
                alreadyDeployed = true;
            }
            if ((requiredProfiles = this.getRequiredProfiles(fileName)) != null && requiredProfiles.size() > 0) {
                alreadyDeployed = true;
            }
            String path = selectedFile.getFullPath().toString();
            UpdateContentDialog dialog = new UpdateContentDialog(activeShell, fileName, paletteName, priority, editorID, requiredProfiles);
            int returnCode = dialog.open();
            if (returnCode == 0) {
                boolean validUpdate = true;
                if (dialog.paletteName != null && dialog.paletteName.length() > 0) {
                    paletteName = dialog.paletteName;
                } else {
                    validUpdate = false;
                }
                if (dialog.priority != null) {
                    priority = dialog.priority;
                } else {
                    validUpdate = false;
                }
                if (dialog.editorID != null && dialog.editorID.length() > 0) {
                    editorID = dialog.editorID;
                } else {
                    validUpdate = false;
                }
                requiredProfiles = dialog.requiredProfiles != null && dialog.requiredProfiles.length() > 0 ? PaletteUtil.getProfileSetFromString((String)dialog.requiredProfiles) : Collections.emptySet();
                if (validUpdate) {
                    if (alreadyDeployed) {
                        result.add(this.activatePalette(fileName, paletteName, path, priority, editorID, (Set<String>)requiredProfiles));
                        continue;
                    }
                    result.add(this.deployPalette(fileName, paletteName, path, priority, editorID, (Set<String>)requiredProfiles));
                    continue;
                }
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.uml.diagram.common", "The palette configuration was not deployed, because dialog content was not valid"));
                continue;
            }
            result.add((IStatus)new Status(4, "org.eclipse.papyrus.uml.diagram.common", "The palette configuration was not deployed, because user did cancel the dialog"));
        }
        if (result.getChildren().length == 1) {
            if (result.isOK()) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Success", (String)result.getMessage());
            } else if (result.getSeverity() < 4) {
                StatusManager.getManager().handle((IStatus)result, 2);
            }
        } else if (result.isOK()) {
            MessageDialog.openInformation((Shell)activeShell, (String)"Success", (String)result.getMessage());
        } else {
            MultiStatus actualResult = new MultiStatus("org.eclipse.papyrus.uml.diagram.common", result.getCode(), "Some errors occurred during the deployment", result.getException());
            actualResult.merge((IStatus)result);
        }
    }

    protected Set<String> getRequiredProfiles(String identifier) {
        return PapyrusPalettePreferences.getRequiredProfiles((String)identifier, (XMLMemento)this.getMemento());
    }

    protected String getPaletteName(String identifier) {
        return PapyrusPalettePreferences.getPaletteName((String)identifier, (XMLMemento)this.getMemento());
    }

    protected String getEditorID(String identifier) {
        return PapyrusPalettePreferences.getEditorID((String)identifier, (XMLMemento)this.getMemento());
    }

    protected ProviderPriority getPriority(String identifier) {
        return PapyrusPalettePreferences.getPalettePriority((String)identifier, (XMLMemento)this.getMemento());
    }

    protected abstract XMLMemento getMemento();

    protected abstract IStatus deployPalette(String var1, String var2, String var3, ProviderPriority var4, String var5, Set<String> var6);

    protected abstract IStatus activatePalette(String var1, String var2, String var3, ProviderPriority var4, String var5, Set<String> var6);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateContentDialog
    extends TrayDialog {
        public String paletteName;
        public ProviderPriority priority;
        public String editorID;
        public String requiredProfiles;
        public String fileName;
        private Text nameText;
        private Text editorText;
        private Text profilesText;
        private CCombo priorityCombo;

        protected UpdateContentDialog(Shell shell, String fileName, String paletteName, ProviderPriority priority, String editorID, Set<String> requiredProfiles) {
            super(shell);
            this.fileName = fileName;
            this.paletteName = paletteName;
            this.priority = priority;
            this.editorID = editorID;
            if (requiredProfiles != null) {
                this.requiredProfiles = PaletteUtil.getSerializedProfileList(requiredProfiles);
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (newShell != null) {
                newShell.setText("Configure Deployment of the palette");
                newShell.setSize(600, 400);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite superComposite = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(superComposite, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText("Name:");
            this.nameText = new Text(composite, 2048);
            if (this.paletteName == null) {
                this.paletteName = this.fileName;
            }
            this.nameText.setText(this.paletteName);
            this.nameText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Label priorityLabel = new Label(composite, 0);
            priorityLabel.setText("Priority:");
            this.priorityCombo = new CCombo(composite, 2048);
            this.priorityCombo.setEditable(false);
            this.priorityCombo.setItems(new String[]{ProviderPriority.LOWEST.getName(), ProviderPriority.LOW.getName(), ProviderPriority.MEDIUM.getName(), ProviderPriority.HIGH.getName(), ProviderPriority.HIGHEST.getName()});
            if (ProviderPriority.LOWEST.equals((Object)this.priority)) {
                this.priorityCombo.select(0);
            } else if (ProviderPriority.LOW.equals((Object)this.priority)) {
                this.priorityCombo.select(1);
            } else if (ProviderPriority.MEDIUM.equals((Object)this.priority)) {
                this.priorityCombo.select(2);
            } else if (ProviderPriority.HIGH.equals((Object)this.priority)) {
                this.priorityCombo.select(3);
            } else if (ProviderPriority.HIGHEST.equals((Object)this.priority)) {
                this.priorityCombo.select(4);
            } else {
                this.priorityCombo.select(2);
            }
            this.priorityCombo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Label editorLabel = new Label(composite, 0);
            editorLabel.setText("Editor:");
            this.editorText = new Text(composite, 2048);
            if (this.editorID == null) {
                this.editorID = "";
            }
            this.editorText.setText(this.editorID);
            this.editorText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Label profilesLabel = new Label(composite, 0);
            profilesLabel.setText("Profiles:");
            this.profilesText = new Text(composite, 2048);
            if (this.requiredProfiles != null) {
                this.profilesText.setText(this.requiredProfiles);
            }
            this.profilesText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            return superComposite;
        }

        protected void okPressed() {
            if (this.nameText != null && !this.nameText.isDisposed()) {
                this.paletteName = this.nameText.getText();
            }
            if (this.editorText != null && !this.editorText.isDisposed()) {
                this.editorID = this.editorText.getText();
            }
            if (this.priorityCombo != null && !this.priorityCombo.isDisposed()) {
                this.priority = ProviderPriority.parse((String)this.priorityCombo.getText());
            }
            if (this.profilesText != null && !this.profilesText.isDisposed()) {
                this.requiredProfiles = this.profilesText.getText();
            }
            super.okPressed();
        }
    }
}

