/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor.ui;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gmf.internal.xpand.build.XpandBuilder;
import org.eclipse.gmf.internal.xpand.editor.Activator;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class NewTemplateFileWizard
extends BasicNewFileResourceWizard {
    public void addPages() {
        super.addPages();
        WizardNewFileCreationPage page = (WizardNewFileCreationPage)this.getPage("newFilePage1");
        page.setTitle(Activator.getResourceString("wizard.page1.title"));
        page.setDescription(Activator.getResourceString("wizard.page1.desc"));
        page.setFileName("NewTemplateFile.xpt");
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            IFile f = ((WizardNewFileCreationPage)this.getPage("newFilePage1")).createNewFile();
            this.configureBuilder(f.getProject());
            return true;
        }
        return false;
    }

    private void configureBuilder(final IProject project) {
        try {
            ICommand[] commands;
            final IProjectDescription desc = project.getDescription();
            ICommand[] iCommandArray = commands = desc.getBuildSpec();
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand element = iCommandArray[n2];
                if (element.getBuilderName().equals(XpandBuilder.getBUILDER_ID())) {
                    return;
                }
                ++n2;
            }
            project.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ICommand[] newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 0, commands.length);
                    ICommand command = desc.newCommand();
                    command.setBuilderName(XpandBuilder.getBUILDER_ID());
                    newCommands[commands.length] = command;
                    desc.setBuildSpec(newCommands);
                    project.setDescription(desc, monitor);
                }
            }, (ISchedulingRule)project.getWorkspace().getRoot(), 0, null);
        }
        catch (CoreException ex) {
            Activator.log(ex.getStatus());
        }
    }
}

