/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.locator.IPapyrusBorderItemLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PositionEnum;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;

public class ExternalLabelPositionLocator
implements IPapyrusBorderItemLocator {
    protected Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private EditPart editPart;
    private boolean isConstrained = false;
    private Point margin = new Point();
    private Dimension offset = new Dimension();
    protected IFigure parentFigure = null;
    int position = 16;
    private int textAlignment;
    private View view;
    private int numLabel;

    public ExternalLabelPositionLocator(IFigure parentFigure) {
        this.parentFigure = parentFigure;
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public int getCurrentSideOfParent() {
        return this.getPosition();
    }

    public Dimension getOffset() {
        return this.offset;
    }

    public int getPosition() {
        String ForcedPosition = NotationUtils.getStringValue((View)this.view, (String)"position", (String)PositionEnum.AUTO.getLiteral());
        if (!PositionEnum.AUTO.toString().equals(ForcedPosition)) {
            if (PositionEnum.EAST.toString().equals(ForcedPosition)) {
                this.position = 16;
            }
            if (PositionEnum.WEST.toString().equals(ForcedPosition)) {
                this.position = 8;
            }
            if (PositionEnum.NORTH.toString().equals(ForcedPosition)) {
                this.position = 1;
            }
            if (PositionEnum.SOUTH.toString().equals(ForcedPosition)) {
                this.position = 4;
            }
        } else {
            this.position = this.getPositionOnParent();
        }
        return this.position;
    }

    public int getPositionOnParent() {
        EditPart parent;
        Rectangle bounds = null;
        Rectangle parentBounds = null;
        int position = this.position;
        if (this.editPart != null && (parent = this.editPart.getParent()) instanceof IPapyrusEditPart) {
            IFigure portPrimaryShape = ((IPapyrusEditPart)parent).getPrimaryShape();
            bounds = portPrimaryShape.getBounds();
            if (parent.getParent() instanceof IPapyrusEditPart && bounds.width != 0) {
                IFigure parentPrimaryShape = ((IPapyrusEditPart)parent.getParent()).getPrimaryShape();
                parentBounds = parentPrimaryShape.getBounds();
                if (bounds.x + bounds.width / 2 == parentBounds.x) {
                    position = 8;
                } else if (bounds.x + bounds.width / 2 == parentBounds.getBottomRight().x) {
                    position = 16;
                } else if (bounds.y + bounds.height / 2 == parentBounds.y) {
                    position = 1;
                } else if (bounds.y + bounds.height / 2 == parentBounds.getBottomRight().y) {
                    position = 4;
                } else if (parent.getParent() instanceof RoundedCompartmentEditPart && bounds.width != 0) {
                    if (bounds.x + bounds.width / 2 < parentBounds.x + parentBounds.width / 4) {
                        position = 8;
                    } else if (bounds.x + bounds.width / 2 > parentBounds.x + parentBounds.width / 4 * 3) {
                        position = 16;
                    } else if (bounds.y + bounds.height / 2 < parentBounds.y + parentBounds.height / 2) {
                        position = 1;
                    } else if (bounds.y + bounds.height / 2 > parentBounds.y + parentBounds.height / 2) {
                        position = 4;
                    }
                }
            }
        }
        return position;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        return new Rectangle(proposedLocation);
    }

    public boolean isConstrained() {
        return this.isConstrained;
    }

    public boolean isInitialize() {
        return this.view != null;
    }

    public void relocate(IFigure target) {
        Rectangle proposedBounds = this.constraint.getCopy();
        proposedBounds.setLocation(this.constraint.getLocation().translate(this.parentFigure.getBounds().getTopLeft()));
        proposedBounds.setSize(target.getPreferredSize());
        if (this.isConstrained) {
            Point newOffset;
            Point newConstraint;
            int numberOfLabel = this.getNumberOfVisibleLabels();
            switch (this.getPosition()) {
                case 8: {
                    newConstraint = new Point(-proposedBounds.width - this.offset.width, this.offset.height);
                    newOffset = new Point(newConstraint.x + proposedBounds.width, newConstraint.y);
                    break;
                }
                case 16: {
                    newConstraint = new Point(this.parentFigure.getBounds().width + this.offset.width, this.offset.height);
                    newOffset = new Point(newConstraint.x, newConstraint.y);
                    break;
                }
                case 1: {
                    newConstraint = new Point(-proposedBounds.width / 2 + this.parentFigure.getBounds().width / 2 + this.offset.width, -this.parentFigure.getBounds().height - this.offset.height);
                    newOffset = new Point(newConstraint.x, newConstraint.y);
                    break;
                }
                case 4: {
                    newConstraint = new Point(-proposedBounds.width / 2 + this.offset.width + this.parentFigure.getBounds().width / 2, this.parentFigure.getBounds().height + this.offset.height);
                    newOffset = new Point(newConstraint.x, newConstraint.y);
                    break;
                }
                default: {
                    newConstraint = new Point(proposedBounds.width + this.offset.width, this.offset.height);
                    newOffset = new Point(newConstraint.x, newConstraint.y);
                }
            }
            proposedBounds.setLocation(newConstraint.translate(this.parentFigure.getBounds().getTopLeft()));
            switch (this.getPosition()) {
                case 8: {
                    proposedBounds.translate(0, (this.numLabel - 1) * proposedBounds.height + this.margin.y - (numberOfLabel - 1) * (proposedBounds.height + this.margin.y) / 2);
                    break;
                }
                case 16: {
                    proposedBounds.translate(0, (this.numLabel - 1) * proposedBounds.height + this.margin.y - (numberOfLabel - 1) * (proposedBounds.height + this.margin.y) / 2);
                    break;
                }
                case 1: {
                    proposedBounds.translate(0, (this.numLabel - 1) * proposedBounds.height + this.margin.y - (numberOfLabel - 1) * (proposedBounds.height + this.margin.y));
                    break;
                }
                case 4: {
                    proposedBounds.translate(0, (this.numLabel - 1) * proposedBounds.height + this.margin.y);
                    break;
                }
            }
            int x = (Integer)((GraphicalEditPart)this.editPart).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)((GraphicalEditPart)this.editPart).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point offset = newOffset;
            if (offset.x != x && offset.y != y) {
                ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
                req.setEditParts(this.editPart);
                req.setLocation(offset);
                Command command = this.editPart.getCommand((Request)req);
                if (command != null && command.canExecute()) {
                    command.setLabel("move: " + offset.toString());
                    TransactionUtil.getEditingDomain((EObject)this.view).getCommandStack().execute(GEFtoEMFCommandWrapper.wrap((Command)command));
                }
            }
        } else {
            int x;
            switch (this.textAlignment) {
                case 1: {
                    x = 0;
                    break;
                }
                case 4: {
                    x = -proposedBounds.width;
                    break;
                }
                case 2: {
                    x = -proposedBounds.width / 2;
                    break;
                }
                default: {
                    x = 0;
                }
            }
            proposedBounds.translate(x, 0);
        }
        target.setBounds(proposedBounds);
    }

    private int getNumberOfVisibleLabels() {
        EditPart parent;
        int numberOfLabel = 0;
        if (this.editPart != null && (parent = this.editPart.getParent()) instanceof IPapyrusEditPart) {
            List childrens = parent.getChildren();
            for (EditPart children : childrens) {
                if (!(children instanceof PapyrusLabelEditPart) || ((PapyrusLabelEditPart)children).getFigure().getBounds().isEmpty()) continue;
                ++numberOfLabel;
                if (children != this.editPart) continue;
                this.numLabel = numberOfLabel;
            }
        }
        return numberOfLabel;
    }

    public void setConstrained(boolean constrained) {
        this.isConstrained = constrained;
    }

    public void setConstraint(Rectangle constraint) {
        this.constraint = constraint;
    }

    public void setEditpart(EditPart editPart) {
        this.editPart = editPart;
    }

    public void setMargin(Point margin) {
        this.margin = margin;
    }

    public void setOffset(Dimension offset) {
        this.offset = offset;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public void setView(View view) {
        this.view = view;
    }
}

