/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.utilities;

import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.ocl.xtext.base.BaseStandaloneSetup;
import org.osgi.framework.BundleContext;

public final class BasePlugin
extends EMFPlugin {
    public static final BasePlugin INSTANCE = new BasePlugin();
    private static Implementation plugin;

    public BasePlugin() {
        super(new ResourceLocator[0]);
    }

    public static void error(int code, String message) {
        BasePlugin.error(code, message, null);
    }

    public static void error(int code, String message, Throwable throwable) {
        BasePlugin.log(4, code, message, throwable);
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static String getPluginId() {
        if (BasePlugin.getPlugin() != null) {
            return BasePlugin.getPlugin().getBundle().getSymbolicName();
        }
        String packageName = BasePlugin.class.getPackage().getName();
        return packageName.substring(0, packageName.lastIndexOf(46));
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? "" : message;
        try {
            if (BasePlugin.getPlugin() != null) {
                BasePlugin.getPlugin().log(new Status(severity, BasePlugin.getPluginId(), code, msg, throwable));
            } else {
                StringBuilder s = new StringBuilder();
                switch (code) {
                    case 2: {
                        s.append("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        s.append("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                s.append(code);
                s.append(": ");
                s.append(message);
                System.err.println(s.toString());
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            BaseStandaloneSetup.doSetup();
            super.start(context);
        }
    }
}

