/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;

public class ASTNodeFactory {
    private static final String STATEMENT_HEADER = "class __X__ { void __x__() { ";
    private static final String STATEMENT_FOOTER = "}}";
    private static final String TYPE_HEADER = "class __X__ { abstract ";
    private static final String TYPE_FOOTER = " __f__(); }}";
    private static final String TYPEPARAM_HEADER = "class __X__ { abstract <";
    private static final String TYPEPARAM_FOOTER = "> void __f__(); }}";

    private ASTNodeFactory() {
    }

    public static ASTNode newStatement(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(STATEMENT_HEADER);
        buffer.append(content);
        buffer.append(STATEMENT_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)NodeFinder.perform((ASTNode)root, (int)STATEMENT_HEADER.length(), (int)content.length()));
        result.accept((ASTVisitor)new PositionClearer());
        return result;
    }

    public static Name newName(AST ast, String qualifiedName) {
        return ast.newName(qualifiedName);
    }

    public static TypeParameter newTypeParameter(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(TYPEPARAM_HEADER);
        buffer.append(content);
        buffer.append(TYPEPARAM_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        List list = root.types();
        TypeDeclaration typeDecl = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDecl = typeDecl.getMethods()[0];
        TypeParameter tp = (TypeParameter)methodDecl.typeParameters().get(0);
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)tp);
        result.accept((ASTVisitor)new PositionClearer());
        return (TypeParameter)result;
    }

    public static Type newType(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(TYPE_HEADER);
        buffer.append(content);
        buffer.append(TYPE_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        List list = root.types();
        TypeDeclaration typeDecl = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDecl = typeDecl.getMethods()[0];
        Type type = methodDecl.getReturnType2();
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)type);
        result.accept((ASTVisitor)new PositionClearer());
        return (Type)result;
    }

    public static ArrayType newArrayType(Type type) {
        if (type instanceof ArrayType) {
            Dimension dimension = type.getAST().newDimension();
            ArrayType arrayType = (ArrayType)type;
            arrayType.dimensions().add(0, dimension);
            return arrayType;
        }
        return type.getAST().newArrayType(type);
    }

    public static Type newType(AST ast, VariableDeclaration declaration) {
        return ASTNodeFactory.newType(ast, declaration, null, null);
    }

    public static Type newType(AST ast, VariableDeclaration declaration, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        Type type2;
        if (declaration instanceof VariableDeclarationFragment && declaration.getParent() instanceof LambdaExpression) {
            return ASTNodeFactory.newType((LambdaExpression)declaration.getParent(), (VariableDeclarationFragment)declaration, ast, importRewrite, context);
        }
        Type type = ASTNodes.getType(declaration);
        if (declaration instanceof SingleVariableDeclaration && (type2 = ((SingleVariableDeclaration)declaration).getType()) instanceof UnionType) {
            ITypeBinding typeBinding = type2.resolveBinding();
            if (typeBinding != null) {
                if (importRewrite != null) {
                    type = importRewrite.addImport(typeBinding, ast, context);
                    return type;
                }
                String qualifiedName = typeBinding.getQualifiedName();
                if (qualifiedName.length() > 0) {
                    type = ast.newSimpleType(ast.newName(qualifiedName));
                    return type;
                }
            }
            type = (Type)((UnionType)type2).types().get(0);
            return type;
        }
        type = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type);
        List extraDimensions = declaration.extraDimensions();
        if (!extraDimensions.isEmpty()) {
            ArrayType arrayType;
            if (type instanceof ArrayType) {
                arrayType = (ArrayType)type;
            } else {
                arrayType = ast.newArrayType(type, 0);
                type = arrayType;
            }
            arrayType.dimensions().addAll(ASTNode.copySubtrees((AST)ast, (List)extraDimensions));
        }
        return type;
    }

    private static Type newType(LambdaExpression lambdaExpression, VariableDeclarationFragment declaration, AST ast, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        IMethodBinding method = lambdaExpression.resolveMethodBinding();
        if (method != null) {
            ITypeBinding[] parameterTypes = method.getParameterTypes();
            int index = lambdaExpression.parameters().indexOf(declaration);
            ITypeBinding typeBinding = parameterTypes[index];
            if (importRewrite != null) {
                return importRewrite.addImport(typeBinding, ast, context);
            }
            String qualifiedName = typeBinding.getQualifiedName();
            if (qualifiedName.length() > 0) {
                return ASTNodeFactory.newType(ast, qualifiedName);
            }
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    public static Type newReturnType(LambdaExpression lambdaExpression, AST ast, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) {
        IMethodBinding method = lambdaExpression.resolveMethodBinding();
        if (method != null) {
            ITypeBinding returnTypeBinding = method.getReturnType();
            if (importRewrite != null) {
                return importRewrite.addImport(returnTypeBinding, ast);
            }
            String qualifiedName = returnTypeBinding.getQualifiedName();
            if (qualifiedName.length() > 0) {
                return ASTNodeFactory.newType(ast, qualifiedName);
            }
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    public static Expression newDefaultExpression(AST ast, Type type, int extraDimensions) {
        if (extraDimensions == 0 && type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.BOOLEAN) {
                return ast.newBooleanLiteral(false);
            }
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID) {
                return null;
            }
            return ast.newNumberLiteral("0");
        }
        return ast.newNullLiteral();
    }

    public static Expression newDefaultExpression(AST ast, ITypeBinding type) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            if ("void".equals(name)) {
                return null;
            }
            return ast.newNumberLiteral("0");
        }
        return ast.newNullLiteral();
    }

    public static List<Modifier> newModifiers(AST ast, int modifiers) {
        return ast.newModifiers(modifiers);
    }

    public static List<Modifier> newModifiers(AST ast, List<? extends IExtendedModifier> modifierNodes) {
        ArrayList<Modifier> res = new ArrayList<Modifier>(modifierNodes.size());
        int i = 0;
        while (i < modifierNodes.size()) {
            IExtendedModifier curr = modifierNodes.get(i);
            if (curr instanceof Modifier) {
                res.add(ast.newModifier(((Modifier)curr).getKeyword()));
            }
            ++i;
        }
        return res;
    }

    public static Expression newInfixExpression(AST ast, InfixExpression.Operator operator, ArrayList<Expression> operands) {
        if (operands.size() == 1) {
            return operands.get(0);
        }
        InfixExpression result = ast.newInfixExpression();
        result.setOperator(operator);
        result.setLeftOperand(operands.get(0));
        result.setRightOperand(operands.get(1));
        result.extendedOperands().addAll(operands.subList(2, operands.size()));
        return result;
    }

    public static Type newCreationType(AST ast, ITypeBinding typeBinding, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext importContext) {
        if (typeBinding.isParameterizedType()) {
            Type baseType = ASTNodeFactory.newCreationType(ast, typeBinding.getTypeDeclaration(), importRewrite, importContext);
            ParameterizedType parameterizedType = ast.newParameterizedType(baseType);
            ITypeBinding[] iTypeBindingArray = typeBinding.getTypeArguments();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeArgument = iTypeBindingArray[n2];
                parameterizedType.typeArguments().add(ASTNodeFactory.newCreationType(ast, typeArgument, importRewrite, importContext));
                ++n2;
            }
            return parameterizedType;
        }
        if (typeBinding.isParameterizedType()) {
            Type elementType = ASTNodeFactory.newCreationType(ast, typeBinding.getElementType(), importRewrite, importContext);
            ArrayType arrayType = ast.newArrayType(elementType, 0);
            while (typeBinding.isArray()) {
                IAnnotationBinding[] typeAnnotations;
                Dimension dimension = ast.newDimension();
                IAnnotationBinding[] iAnnotationBindingArray = typeAnnotations = typeBinding.getTypeAnnotations();
                int n = typeAnnotations.length;
                int n3 = 0;
                while (n3 < n) {
                    IAnnotationBinding typeAnnotation = iAnnotationBindingArray[n3];
                    dimension.annotations().add(importRewrite.addAnnotation(typeAnnotation, ast, importContext));
                    ++n3;
                }
                arrayType.dimensions().add(dimension);
                typeBinding = typeBinding.getComponentType();
            }
            return arrayType;
        }
        if (typeBinding.isWildcardType()) {
            ITypeBinding bound = typeBinding.getBound();
            typeBinding = bound != null ? bound : typeBinding.getErasure();
            return ASTNodeFactory.newCreationType(ast, typeBinding, importRewrite, importContext);
        }
        return importRewrite.addImport(typeBinding, ast, importContext);
    }

    private static class PositionClearer
    extends GenericVisitor {
        public PositionClearer() {
            super(true);
        }

        @Override
        protected boolean visitNode(ASTNode node) {
            node.setSourceRange(-1, 0);
            return true;
        }
    }
}

