/*******************************************************************************
 * Copyright (C) 2018 Fondazione Bruno Kessler.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *   
 * Contributors:
 *      FBK - initial API and implementation
 *******************************************************************************/
/**
 */
package eu.fbk.tools.adapter.results;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see eu.fbk.tools.adapter.results.ResultsFactory
 * @model kind="package"
 * @generated
 */
public interface ResultsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "results";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fbk.eu/tools/verification/Results";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "eu.fbk.tools.adapter";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ResultsPackage eINSTANCE = eu.fbk.tools.adapter.results.impl.ResultsPackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.ModelCheckResultImpl <em>Model Check Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.ModelCheckResultImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getModelCheckResult()
	 * @generated
	 */
	int MODEL_CHECK_RESULT = 0;

	/**
	 * The feature id for the '<em><b>Contract Check Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS = 0;

	/**
	 * The feature id for the '<em><b>Behaviour Check Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS = 1;

	/**
	 * The feature id for the '<em><b>Property Validation Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS = 2;

	/**
	 * The number of structural features of the '<em>Model Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_CHECK_RESULT_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Model Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_CHECK_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl <em>Abstract Check Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getAbstractCheckResult()
	 * @generated
	 */
	int ABSTRACT_CHECK_RESULT = 1;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CHECK_RESULT__MODEL_NAME = 0;

	/**
	 * The feature id for the '<em><b>Check Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CHECK_RESULT__CHECK_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Failed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CHECK_RESULT__FAILED = 2;

	/**
	 * The feature id for the '<em><b>Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CHECK_RESULT__TIME_STAMP = 3;

	/**
	 * The feature id for the '<em><b>Check Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CHECK_RESULT__CHECK_RESULTS = 4;

	/**
	 * The number of structural features of the '<em>Abstract Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CHECK_RESULT_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Abstract Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CHECK_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.ContractCheckResultImpl <em>Contract Check Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.ContractCheckResultImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getContractCheckResult()
	 * @generated
	 */
	int CONTRACT_CHECK_RESULT = 2;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__MODEL_NAME = ABSTRACT_CHECK_RESULT__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Check Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__CHECK_TYPE = ABSTRACT_CHECK_RESULT__CHECK_TYPE;

	/**
	 * The feature id for the '<em><b>Failed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__FAILED = ABSTRACT_CHECK_RESULT__FAILED;

	/**
	 * The feature id for the '<em><b>Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__TIME_STAMP = ABSTRACT_CHECK_RESULT__TIME_STAMP;

	/**
	 * The feature id for the '<em><b>Check Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__CHECK_RESULTS = ABSTRACT_CHECK_RESULT__CHECK_RESULTS;

	/**
	 * The feature id for the '<em><b>Component Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__COMPONENT_TYPE = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__COMPONENT_NAME = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Contract Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT__CONTRACT_NAME = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Contract Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT_FEATURE_COUNT = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Contract Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_CHECK_RESULT_OPERATION_COUNT = ABSTRACT_CHECK_RESULT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.BehaviourCheckResultImpl <em>Behaviour Check Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.BehaviourCheckResultImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getBehaviourCheckResult()
	 * @generated
	 */
	int BEHAVIOUR_CHECK_RESULT = 3;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT__MODEL_NAME = ABSTRACT_CHECK_RESULT__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Check Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT__CHECK_TYPE = ABSTRACT_CHECK_RESULT__CHECK_TYPE;

	/**
	 * The feature id for the '<em><b>Failed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT__FAILED = ABSTRACT_CHECK_RESULT__FAILED;

	/**
	 * The feature id for the '<em><b>Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT__TIME_STAMP = ABSTRACT_CHECK_RESULT__TIME_STAMP;

	/**
	 * The feature id for the '<em><b>Check Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT__CHECK_RESULTS = ABSTRACT_CHECK_RESULT__CHECK_RESULTS;

	/**
	 * The feature id for the '<em><b>Component Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT__COMPONENT_TYPE = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT__COMPONENT_NAME = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Behaviour Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT_FEATURE_COUNT = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Behaviour Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_CHECK_RESULT_OPERATION_COUNT = ABSTRACT_CHECK_RESULT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.ContractPropertyValidationResultImpl <em>Contract Property Validation Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.ContractPropertyValidationResultImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getContractPropertyValidationResult()
	 * @generated
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT = 4;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT__MODEL_NAME = ABSTRACT_CHECK_RESULT__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Check Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT__CHECK_TYPE = ABSTRACT_CHECK_RESULT__CHECK_TYPE;

	/**
	 * The feature id for the '<em><b>Failed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT__FAILED = ABSTRACT_CHECK_RESULT__FAILED;

	/**
	 * The feature id for the '<em><b>Time Stamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT__TIME_STAMP = ABSTRACT_CHECK_RESULT__TIME_STAMP;

	/**
	 * The feature id for the '<em><b>Check Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT__CHECK_RESULTS = ABSTRACT_CHECK_RESULT__CHECK_RESULTS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT__NAME = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Contract Property Validation Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT_FEATURE_COUNT = ABSTRACT_CHECK_RESULT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Contract Property Validation Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTRACT_PROPERTY_VALIDATION_RESULT_OPERATION_COUNT = ABSTRACT_CHECK_RESULT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.CheckResultImpl <em>Check Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.CheckResultImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getCheckResult()
	 * @generated
	 */
	int CHECK_RESULT = 5;

	/**
	 * The feature id for the '<em><b>Proof Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT__PROOF_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT__VALUE = 1;

	/**
	 * The feature id for the '<em><b>Contract Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT__CONTRACT_NAME = 2;

	/**
	 * The feature id for the '<em><b>Traces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT__TRACES = 3;

	/**
	 * The number of structural features of the '<em>Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Check Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.TraceImpl <em>Trace</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.TraceImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getTrace()
	 * @generated
	 */
	int TRACE = 6;

	/**
	 * The feature id for the '<em><b>Section</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRACE__SECTION = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRACE__ID = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRACE__TYPE = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRACE__DESCRIPTION = 3;

	/**
	 * The feature id for the '<em><b>States</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRACE__STATES = 4;

	/**
	 * The number of structural features of the '<em>Trace</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRACE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Trace</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRACE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.SectionImpl <em>Section</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.SectionImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getSection()
	 * @generated
	 */
	int SECTION = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__NAME = 0;

	/**
	 * The feature id for the '<em><b>Assignments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__ASSIGNMENTS = 1;

	/**
	 * The number of structural features of the '<em>Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.StateImpl <em>State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.StateImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getState()
	 * @generated
	 */
	int STATE = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__ID = 0;

	/**
	 * The feature id for the '<em><b>Start Loop</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__START_LOOP = 1;

	/**
	 * The feature id for the '<em><b>Sections</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__SECTIONS = 2;

	/**
	 * The number of structural features of the '<em>State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link eu.fbk.tools.adapter.results.impl.AssignmentImpl <em>Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.fbk.tools.adapter.results.impl.AssignmentImpl
	 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getAssignment()
	 * @generated
	 */
	int ASSIGNMENT = 9;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__VARIABLE = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.ModelCheckResult <em>Model Check Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model Check Result</em>'.
	 * @see eu.fbk.tools.adapter.results.ModelCheckResult
	 * @generated
	 */
	EClass getModelCheckResult();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.ModelCheckResult#getContractCheckResults <em>Contract Check Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contract Check Results</em>'.
	 * @see eu.fbk.tools.adapter.results.ModelCheckResult#getContractCheckResults()
	 * @see #getModelCheckResult()
	 * @generated
	 */
	EReference getModelCheckResult_ContractCheckResults();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.ModelCheckResult#getBehaviourCheckResults <em>Behaviour Check Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Behaviour Check Results</em>'.
	 * @see eu.fbk.tools.adapter.results.ModelCheckResult#getBehaviourCheckResults()
	 * @see #getModelCheckResult()
	 * @generated
	 */
	EReference getModelCheckResult_BehaviourCheckResults();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.ModelCheckResult#getPropertyValidationResults <em>Property Validation Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Property Validation Results</em>'.
	 * @see eu.fbk.tools.adapter.results.ModelCheckResult#getPropertyValidationResults()
	 * @see #getModelCheckResult()
	 * @generated
	 */
	EReference getModelCheckResult_PropertyValidationResults();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.AbstractCheckResult <em>Abstract Check Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Check Result</em>'.
	 * @see eu.fbk.tools.adapter.results.AbstractCheckResult
	 * @generated
	 */
	EClass getAbstractCheckResult();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getModelName <em>Model Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model Name</em>'.
	 * @see eu.fbk.tools.adapter.results.AbstractCheckResult#getModelName()
	 * @see #getAbstractCheckResult()
	 * @generated
	 */
	EAttribute getAbstractCheckResult_ModelName();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getCheckType <em>Check Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Check Type</em>'.
	 * @see eu.fbk.tools.adapter.results.AbstractCheckResult#getCheckType()
	 * @see #getAbstractCheckResult()
	 * @generated
	 */
	EAttribute getAbstractCheckResult_CheckType();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getFailed <em>Failed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Failed</em>'.
	 * @see eu.fbk.tools.adapter.results.AbstractCheckResult#getFailed()
	 * @see #getAbstractCheckResult()
	 * @generated
	 */
	EAttribute getAbstractCheckResult_Failed();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getTimeStamp <em>Time Stamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Time Stamp</em>'.
	 * @see eu.fbk.tools.adapter.results.AbstractCheckResult#getTimeStamp()
	 * @see #getAbstractCheckResult()
	 * @generated
	 */
	EAttribute getAbstractCheckResult_TimeStamp();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.AbstractCheckResult#getCheckResults <em>Check Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Check Results</em>'.
	 * @see eu.fbk.tools.adapter.results.AbstractCheckResult#getCheckResults()
	 * @see #getAbstractCheckResult()
	 * @generated
	 */
	EReference getAbstractCheckResult_CheckResults();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.ContractCheckResult <em>Contract Check Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Contract Check Result</em>'.
	 * @see eu.fbk.tools.adapter.results.ContractCheckResult
	 * @generated
	 */
	EClass getContractCheckResult();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.ContractCheckResult#getComponentType <em>Component Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Component Type</em>'.
	 * @see eu.fbk.tools.adapter.results.ContractCheckResult#getComponentType()
	 * @see #getContractCheckResult()
	 * @generated
	 */
	EAttribute getContractCheckResult_ComponentType();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.ContractCheckResult#getComponentName <em>Component Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Component Name</em>'.
	 * @see eu.fbk.tools.adapter.results.ContractCheckResult#getComponentName()
	 * @see #getContractCheckResult()
	 * @generated
	 */
	EAttribute getContractCheckResult_ComponentName();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.ContractCheckResult#getContractName <em>Contract Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Contract Name</em>'.
	 * @see eu.fbk.tools.adapter.results.ContractCheckResult#getContractName()
	 * @see #getContractCheckResult()
	 * @generated
	 */
	EAttribute getContractCheckResult_ContractName();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.BehaviourCheckResult <em>Behaviour Check Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Behaviour Check Result</em>'.
	 * @see eu.fbk.tools.adapter.results.BehaviourCheckResult
	 * @generated
	 */
	EClass getBehaviourCheckResult();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.BehaviourCheckResult#getComponentType <em>Component Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Component Type</em>'.
	 * @see eu.fbk.tools.adapter.results.BehaviourCheckResult#getComponentType()
	 * @see #getBehaviourCheckResult()
	 * @generated
	 */
	EAttribute getBehaviourCheckResult_ComponentType();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.BehaviourCheckResult#getComponentName <em>Component Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Component Name</em>'.
	 * @see eu.fbk.tools.adapter.results.BehaviourCheckResult#getComponentName()
	 * @see #getBehaviourCheckResult()
	 * @generated
	 */
	EAttribute getBehaviourCheckResult_ComponentName();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.ContractPropertyValidationResult <em>Contract Property Validation Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Contract Property Validation Result</em>'.
	 * @see eu.fbk.tools.adapter.results.ContractPropertyValidationResult
	 * @generated
	 */
	EClass getContractPropertyValidationResult();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.ContractPropertyValidationResult#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.fbk.tools.adapter.results.ContractPropertyValidationResult#getName()
	 * @see #getContractPropertyValidationResult()
	 * @generated
	 */
	EAttribute getContractPropertyValidationResult_Name();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.CheckResult <em>Check Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Check Result</em>'.
	 * @see eu.fbk.tools.adapter.results.CheckResult
	 * @generated
	 */
	EClass getCheckResult();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.CheckResult#getProofType <em>Proof Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Proof Type</em>'.
	 * @see eu.fbk.tools.adapter.results.CheckResult#getProofType()
	 * @see #getCheckResult()
	 * @generated
	 */
	EAttribute getCheckResult_ProofType();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.CheckResult#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see eu.fbk.tools.adapter.results.CheckResult#getValue()
	 * @see #getCheckResult()
	 * @generated
	 */
	EAttribute getCheckResult_Value();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.CheckResult#getContractName <em>Contract Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Contract Name</em>'.
	 * @see eu.fbk.tools.adapter.results.CheckResult#getContractName()
	 * @see #getCheckResult()
	 * @generated
	 */
	EAttribute getCheckResult_ContractName();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.CheckResult#getTraces <em>Traces</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Traces</em>'.
	 * @see eu.fbk.tools.adapter.results.CheckResult#getTraces()
	 * @see #getCheckResult()
	 * @generated
	 */
	EReference getCheckResult_Traces();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.Trace <em>Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Trace</em>'.
	 * @see eu.fbk.tools.adapter.results.Trace
	 * @generated
	 */
	EClass getTrace();

	/**
	 * Returns the meta object for the containment reference '{@link eu.fbk.tools.adapter.results.Trace#getSection <em>Section</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Section</em>'.
	 * @see eu.fbk.tools.adapter.results.Trace#getSection()
	 * @see #getTrace()
	 * @generated
	 */
	EReference getTrace_Section();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.Trace#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see eu.fbk.tools.adapter.results.Trace#getId()
	 * @see #getTrace()
	 * @generated
	 */
	EAttribute getTrace_Id();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.Trace#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see eu.fbk.tools.adapter.results.Trace#getType()
	 * @see #getTrace()
	 * @generated
	 */
	EAttribute getTrace_Type();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.Trace#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see eu.fbk.tools.adapter.results.Trace#getDescription()
	 * @see #getTrace()
	 * @generated
	 */
	EAttribute getTrace_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.Trace#getStates <em>States</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>States</em>'.
	 * @see eu.fbk.tools.adapter.results.Trace#getStates()
	 * @see #getTrace()
	 * @generated
	 */
	EReference getTrace_States();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.Section <em>Section</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Section</em>'.
	 * @see eu.fbk.tools.adapter.results.Section
	 * @generated
	 */
	EClass getSection();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.Section#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.fbk.tools.adapter.results.Section#getName()
	 * @see #getSection()
	 * @generated
	 */
	EAttribute getSection_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.Section#getAssignments <em>Assignments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Assignments</em>'.
	 * @see eu.fbk.tools.adapter.results.Section#getAssignments()
	 * @see #getSection()
	 * @generated
	 */
	EReference getSection_Assignments();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.State <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State</em>'.
	 * @see eu.fbk.tools.adapter.results.State
	 * @generated
	 */
	EClass getState();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.State#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see eu.fbk.tools.adapter.results.State#getId()
	 * @see #getState()
	 * @generated
	 */
	EAttribute getState_Id();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.State#isStartLoop <em>Start Loop</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Loop</em>'.
	 * @see eu.fbk.tools.adapter.results.State#isStartLoop()
	 * @see #getState()
	 * @generated
	 */
	EAttribute getState_StartLoop();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.fbk.tools.adapter.results.State#getSections <em>Sections</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sections</em>'.
	 * @see eu.fbk.tools.adapter.results.State#getSections()
	 * @see #getState()
	 * @generated
	 */
	EReference getState_Sections();

	/**
	 * Returns the meta object for class '{@link eu.fbk.tools.adapter.results.Assignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assignment</em>'.
	 * @see eu.fbk.tools.adapter.results.Assignment
	 * @generated
	 */
	EClass getAssignment();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.Assignment#getVariable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Variable</em>'.
	 * @see eu.fbk.tools.adapter.results.Assignment#getVariable()
	 * @see #getAssignment()
	 * @generated
	 */
	EAttribute getAssignment_Variable();

	/**
	 * Returns the meta object for the attribute '{@link eu.fbk.tools.adapter.results.Assignment#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see eu.fbk.tools.adapter.results.Assignment#getValue()
	 * @see #getAssignment()
	 * @generated
	 */
	EAttribute getAssignment_Value();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ResultsFactory getResultsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.ModelCheckResultImpl <em>Model Check Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.ModelCheckResultImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getModelCheckResult()
		 * @generated
		 */
		EClass MODEL_CHECK_RESULT = eINSTANCE.getModelCheckResult();

		/**
		 * The meta object literal for the '<em><b>Contract Check Results</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MODEL_CHECK_RESULT__CONTRACT_CHECK_RESULTS = eINSTANCE.getModelCheckResult_ContractCheckResults();

		/**
		 * The meta object literal for the '<em><b>Behaviour Check Results</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MODEL_CHECK_RESULT__BEHAVIOUR_CHECK_RESULTS = eINSTANCE.getModelCheckResult_BehaviourCheckResults();

		/**
		 * The meta object literal for the '<em><b>Property Validation Results</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MODEL_CHECK_RESULT__PROPERTY_VALIDATION_RESULTS = eINSTANCE.getModelCheckResult_PropertyValidationResults();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl <em>Abstract Check Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.AbstractCheckResultImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getAbstractCheckResult()
		 * @generated
		 */
		EClass ABSTRACT_CHECK_RESULT = eINSTANCE.getAbstractCheckResult();

		/**
		 * The meta object literal for the '<em><b>Model Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABSTRACT_CHECK_RESULT__MODEL_NAME = eINSTANCE.getAbstractCheckResult_ModelName();

		/**
		 * The meta object literal for the '<em><b>Check Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABSTRACT_CHECK_RESULT__CHECK_TYPE = eINSTANCE.getAbstractCheckResult_CheckType();

		/**
		 * The meta object literal for the '<em><b>Failed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABSTRACT_CHECK_RESULT__FAILED = eINSTANCE.getAbstractCheckResult_Failed();

		/**
		 * The meta object literal for the '<em><b>Time Stamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABSTRACT_CHECK_RESULT__TIME_STAMP = eINSTANCE.getAbstractCheckResult_TimeStamp();

		/**
		 * The meta object literal for the '<em><b>Check Results</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_CHECK_RESULT__CHECK_RESULTS = eINSTANCE.getAbstractCheckResult_CheckResults();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.ContractCheckResultImpl <em>Contract Check Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.ContractCheckResultImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getContractCheckResult()
		 * @generated
		 */
		EClass CONTRACT_CHECK_RESULT = eINSTANCE.getContractCheckResult();

		/**
		 * The meta object literal for the '<em><b>Component Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTRACT_CHECK_RESULT__COMPONENT_TYPE = eINSTANCE.getContractCheckResult_ComponentType();

		/**
		 * The meta object literal for the '<em><b>Component Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTRACT_CHECK_RESULT__COMPONENT_NAME = eINSTANCE.getContractCheckResult_ComponentName();

		/**
		 * The meta object literal for the '<em><b>Contract Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTRACT_CHECK_RESULT__CONTRACT_NAME = eINSTANCE.getContractCheckResult_ContractName();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.BehaviourCheckResultImpl <em>Behaviour Check Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.BehaviourCheckResultImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getBehaviourCheckResult()
		 * @generated
		 */
		EClass BEHAVIOUR_CHECK_RESULT = eINSTANCE.getBehaviourCheckResult();

		/**
		 * The meta object literal for the '<em><b>Component Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BEHAVIOUR_CHECK_RESULT__COMPONENT_TYPE = eINSTANCE.getBehaviourCheckResult_ComponentType();

		/**
		 * The meta object literal for the '<em><b>Component Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BEHAVIOUR_CHECK_RESULT__COMPONENT_NAME = eINSTANCE.getBehaviourCheckResult_ComponentName();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.ContractPropertyValidationResultImpl <em>Contract Property Validation Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.ContractPropertyValidationResultImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getContractPropertyValidationResult()
		 * @generated
		 */
		EClass CONTRACT_PROPERTY_VALIDATION_RESULT = eINSTANCE.getContractPropertyValidationResult();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTRACT_PROPERTY_VALIDATION_RESULT__NAME = eINSTANCE.getContractPropertyValidationResult_Name();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.CheckResultImpl <em>Check Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.CheckResultImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getCheckResult()
		 * @generated
		 */
		EClass CHECK_RESULT = eINSTANCE.getCheckResult();

		/**
		 * The meta object literal for the '<em><b>Proof Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHECK_RESULT__PROOF_TYPE = eINSTANCE.getCheckResult_ProofType();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHECK_RESULT__VALUE = eINSTANCE.getCheckResult_Value();

		/**
		 * The meta object literal for the '<em><b>Contract Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHECK_RESULT__CONTRACT_NAME = eINSTANCE.getCheckResult_ContractName();

		/**
		 * The meta object literal for the '<em><b>Traces</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CHECK_RESULT__TRACES = eINSTANCE.getCheckResult_Traces();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.TraceImpl <em>Trace</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.TraceImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getTrace()
		 * @generated
		 */
		EClass TRACE = eINSTANCE.getTrace();

		/**
		 * The meta object literal for the '<em><b>Section</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRACE__SECTION = eINSTANCE.getTrace_Section();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRACE__ID = eINSTANCE.getTrace_Id();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRACE__TYPE = eINSTANCE.getTrace_Type();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRACE__DESCRIPTION = eINSTANCE.getTrace_Description();

		/**
		 * The meta object literal for the '<em><b>States</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRACE__STATES = eINSTANCE.getTrace_States();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.SectionImpl <em>Section</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.SectionImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getSection()
		 * @generated
		 */
		EClass SECTION = eINSTANCE.getSection();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SECTION__NAME = eINSTANCE.getSection_Name();

		/**
		 * The meta object literal for the '<em><b>Assignments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SECTION__ASSIGNMENTS = eINSTANCE.getSection_Assignments();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.StateImpl <em>State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.StateImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getState()
		 * @generated
		 */
		EClass STATE = eINSTANCE.getState();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATE__ID = eINSTANCE.getState_Id();

		/**
		 * The meta object literal for the '<em><b>Start Loop</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATE__START_LOOP = eINSTANCE.getState_StartLoop();

		/**
		 * The meta object literal for the '<em><b>Sections</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE__SECTIONS = eINSTANCE.getState_Sections();

		/**
		 * The meta object literal for the '{@link eu.fbk.tools.adapter.results.impl.AssignmentImpl <em>Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.fbk.tools.adapter.results.impl.AssignmentImpl
		 * @see eu.fbk.tools.adapter.results.impl.ResultsPackageImpl#getAssignment()
		 * @generated
		 */
		EClass ASSIGNMENT = eINSTANCE.getAssignment();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSIGNMENT__VARIABLE = eINSTANCE.getAssignment_Variable();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSIGNMENT__VALUE = eINSTANCE.getAssignment_Value();

	}

} //ResultsPackage
