/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.SelectionDescription;

public final class SelectionDescriptionHelper {
    private SelectionDescriptionHelper() {
    }

    public static void computeInput(SelectionDescription selectionDescription, EObject container, IInterpreter interpreter, TreeItemWrapper input) {
        ImmutableSet referencingENode = ImmutableSet.copyOf(RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(container, selectionDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getSelectionDescription_CandidatesExpression()));
        if (selectionDescription.isTree()) {
            Collection<EObject> referencingRoots = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(container, selectionDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getSelectionDescription_RootExpression());
            for (EObject refRoot : referencingRoots) {
                if (!referencingENode.contains(refRoot)) continue;
                TreeItemWrapper treeItem = new TreeItemWrapper((Object)refRoot, input);
                input.getChildren().add(treeItem);
                SelectionDescriptionHelper.computeChildren(selectionDescription, (Collection<EObject>)referencingENode, interpreter, treeItem, refRoot);
            }
        } else {
            for (EObject refRoot : referencingENode) {
                if (!referencingENode.contains(refRoot)) continue;
                TreeItemWrapper treeItem = new TreeItemWrapper((Object)refRoot, input);
                input.getChildren().add(treeItem);
            }
        }
    }

    private static void computeChildren(SelectionDescription selectionDescription, Collection<EObject> referencingENode, IInterpreter interpreter, TreeItemWrapper parent, EObject refParent) {
        Collection<EObject> referencingChilds = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateCollection(refParent, selectionDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getSelectionDescription_ChildrenExpression());
        for (EObject refElement : referencingChilds) {
            if (!referencingENode.contains(refElement) || parent.knownThisAsAncestor((Object)refElement)) continue;
            TreeItemWrapper treeItem = new TreeItemWrapper((Object)refElement, parent);
            parent.getChildren().add(treeItem);
            SelectionDescriptionHelper.computeChildren(selectionDescription, referencingENode, interpreter, treeItem, refElement);
        }
    }
}

