/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;

public class NewDiagramForExistingModelPage
extends NewModelFilePage {
    private String myDiagramFileName;

    public NewDiagramForExistingModelPage(IStructuredSelection selection, String modelKindName, String defaultFileName, String diagramExtension) {
        super(selection, modelKindName);
        this.myDiagramFileName = defaultFileName;
        if (this.myDiagramFileName.contains("%20")) {
            this.myDiagramFileName = this.myDiagramFileName.replaceAll("%20", " ");
        }
        this.setFileName(this.myDiagramFileName);
        this.setFileExtension(diagramExtension);
        this.setTitle(Messages.InitModelWizard_init_papyrus_model);
        this.setDescription(Messages.InitModelWizard_init_papyrus_model_desc);
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        if (!this.myDiagramFileName.equals(this.getFileName())) {
            this.setErrorMessage(Messages.bind((String)Messages.InitModelWizard_diagram_name_is_different_from_domain_model, (Object)this.myDiagramFileName));
            return false;
        }
        return true;
    }
}

