/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.chessmlprofile.Core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Domain implements Enumerator
{
    CROSS_DOMAIN(0, "cross_domain", "cross_domain"),
    AVIONICS(1, "avionics", "avionics"),
    AUTOMOTIVE(2, "automotive", "automotive"),
    TELECOM(3, "telecom", "telecom"),
    SPACE(4, "space", "space"),
    MEDICAL(5, "medical", "medical"),
    PETROLEUM(6, "petroleum", "petroleum");

    public static final int CROSS_DOMAIN_VALUE = 0;
    public static final int AVIONICS_VALUE = 1;
    public static final int AUTOMOTIVE_VALUE = 2;
    public static final int TELECOM_VALUE = 3;
    public static final int SPACE_VALUE = 4;
    public static final int MEDICAL_VALUE = 5;
    public static final int PETROLEUM_VALUE = 6;
    private static final Domain[] VALUES_ARRAY;
    public static final List<Domain> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Domain[]{CROSS_DOMAIN, AVIONICS, AUTOMOTIVE, TELECOM, SPACE, MEDICAL, PETROLEUM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Domain get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Domain result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Domain getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Domain result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Domain get(int value) {
        switch (value) {
            case 0: {
                return CROSS_DOMAIN;
            }
            case 1: {
                return AVIONICS;
            }
            case 2: {
                return AUTOMOTIVE;
            }
            case 3: {
                return TELECOM;
            }
            case 4: {
                return SPACE;
            }
            case 5: {
                return MEDICAL;
            }
            case 6: {
                return PETROLEUM;
            }
        }
        return null;
    }

    private Domain(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

