/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager
extends Lifecycle
implements IUserManager,
IAuthenticator {
    @ReflectUtil.ExcludeFromDump
    protected transient Map<String, char[]> users = new HashMap<String, char[]>();

    @Override
    public synchronized void addUser(String userID, char[] password) {
        this.users.put(userID, password);
        this.save(this.users);
    }

    @Override
    public synchronized void removeUser(String userID) {
        if (this.users.remove(userID) != null) {
            this.save(this.users);
        }
    }

    public char[] getPassword(String userID) {
        return this.users.get(userID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(String userID, char[] password) {
        char[] userPassword;
        UserManager userManager = this;
        synchronized (userManager) {
            userPassword = this.users.get(userID);
        }
        if (userPassword == null) {
            throw new SecurityException("No such user: " + userID);
        }
        if (!Arrays.equals(userPassword, password)) {
            throw new SecurityException("Wrong password for user: " + userID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(String userID, byte[] data, String algorithmName, byte[] salt, int count) throws SecurityException {
        char[] password;
        UserManager userManager = this;
        synchronized (userManager) {
            password = this.users.get(userID);
        }
        if (password == null) {
            throw new SecurityException("No such user: " + userID);
        }
        try {
            return SecurityUtil.encrypt(data, password, algorithmName, salt, count);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.load(this.users);
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.users.clear();
        super.doDeactivate();
    }

    protected void load(Map<String, char[]> users) throws IORuntimeException {
    }

    protected void save(Map<String, char[]> users) throws IORuntimeException {
    }
}

