/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginElementProcessorList
extends Lifecycle
implements List<IElementProcessor> {
    private static final String ATTR_CLASS = "class";
    public static final String NAMESPACE = "org.eclipse.net4j.util";
    public static final String EXT_POINT = "elementProcessors";
    private List<IElementProcessor> processors = new ArrayList<IElementProcessor>();
    private Object extensionRegistryListener;

    @Override
    public boolean add(IElementProcessor o) {
        return this.processors.add(o);
    }

    @Override
    public void add(int index, IElementProcessor element) {
        this.processors.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends IElementProcessor> c) {
        return this.processors.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends IElementProcessor> c) {
        return this.processors.addAll(index, c);
    }

    @Override
    public void clear() {
        this.processors.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.processors.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.processors.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.processors.equals(o);
    }

    @Override
    public IElementProcessor get(int index) {
        return this.processors.get(index);
    }

    @Override
    public int hashCode() {
        return this.processors.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.processors.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.processors.isEmpty();
    }

    @Override
    public Iterator<IElementProcessor> iterator() {
        return this.processors.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.processors.lastIndexOf(o);
    }

    @Override
    public ListIterator<IElementProcessor> listIterator() {
        return this.processors.listIterator();
    }

    @Override
    public ListIterator<IElementProcessor> listIterator(int index) {
        return this.processors.listIterator(index);
    }

    @Override
    public IElementProcessor remove(int index) {
        return this.processors.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.processors.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.processors.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.processors.retainAll(c);
    }

    @Override
    public IElementProcessor set(int index, IElementProcessor element) {
        return this.processors.set(index, element);
    }

    @Override
    public int size() {
        return this.processors.size();
    }

    @Override
    public List<IElementProcessor> subList(int fromIndex, int toIndex) {
        return this.processors.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.processors.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.processors.toArray(a);
    }

    @Override
    public String toString() {
        return this.processors.toString();
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        try {
            this.doActivateOSGi();
        }
        catch (Throwable t) {
            OM.LOG.warn(t);
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        try {
            this.doDeactivateOSGi();
        }
        catch (Throwable t) {
            OM.LOG.warn(t);
        }
        this.processors.clear();
        super.doDeactivate();
    }

    private void doActivateOSGi() throws Exception {
        IConfigurationElement[] elements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor(NAMESPACE, EXT_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IElementProcessor processor = (IElementProcessor)element.createExecutableExtension(ATTR_CLASS);
            this.processors.add(processor);
            ++n2;
        }
        IRegistryChangeListener listener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] deltas;
                IExtensionDelta[] iExtensionDeltaArray = deltas = event.getExtensionDeltas(PluginElementProcessorList.NAMESPACE, PluginElementProcessorList.EXT_POINT);
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    OM.LOG.warn("ExtensionDelta not handled: " + delta);
                    ++n2;
                }
            }
        };
        extensionRegistry.addRegistryChangeListener(listener, NAMESPACE);
        this.extensionRegistryListener = listener;
    }

    private void doDeactivateOSGi() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        extensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)this.extensionRegistryListener);
    }
}

