/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.activitygroup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IContainerNodeDescriptor;

public abstract class AbstractContainerNodeDescriptor
implements IContainerNodeDescriptor {
    @Override
    public abstract EClass getContainerEClass();

    @Override
    public List<EClass> getPossibleGraphicalChildren() {
        List<EReference> refs = this.getChildrenReferences();
        ArrayList<EClass> result = new ArrayList<EClass>(refs.size());
        for (EReference ref : refs) {
            result.add(ref.getEReferenceType());
        }
        return result;
    }

    @Override
    public abstract List<EReference> getChildrenReferences();

    @Override
    public abstract List<EReference> getParentReferences();

    @Override
    public abstract Map<EStructuralFeature, EStructuralFeature> getParentEOppositeReferences();

    @Override
    public abstract IGraphicalEditPart getCompartmentPartFromView(IGraphicalEditPart var1);

    @Override
    public boolean canIBeGraphicalParentOf(EClass childType) {
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canIBeModelParentOf(EClass childType) {
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType) || !reference.isContainment()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<EReference> getReferenceFor(EClass childType) {
        ArrayList<EReference> result = new ArrayList<EReference>();
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType) || reference.isContainment()) continue;
            result.add(reference);
        }
        return result;
    }

    @Override
    public EReference getContainmentReferenceFor(EClass childType) {
        EReference usedReference = null;
        ArrayList<EReference> result = new ArrayList<EReference>();
        for (EReference reference : this.getChildrenReferences()) {
            if (!reference.getEReferenceType().isSuperTypeOf(childType) || !reference.isContainment() || reference.isDerived()) continue;
            result.add(reference);
        }
        for (EReference ref : result) {
            if (usedReference != null && !ref.getEReferenceType().getEAllSuperTypes().contains((Object)usedReference.getEReferenceType())) continue;
            usedReference = ref;
        }
        return usedReference;
    }

    @Override
    public int compareTo(IContainerNodeDescriptor o) {
        Integer thisInt = new Integer(this.getGroupPriority());
        Integer otherInt = new Integer(o.getGroupPriority());
        return thisInt.compareTo(otherInt);
    }
}

