/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.ISessionManager;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectSessionAction
extends Action
implements IMenuCreator {
    private Menu menu;

    public SelectSessionAction() {
        this.setText(ActionMessages.SelectSessionAction_label);
        this.setToolTipText(ActionMessages.SelectSessionAction_tooltip);
        this.setImageDescriptor(ApiUIPlugin.getImageDescriptor("IMG_ELCL_COMPARE_APIS"));
        this.setDisabledImageDescriptor(ApiUIPlugin.getImageDescriptor("IMG_ELCL_COMPARE_APIS_DISABLED"));
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        final ISessionManager manager = ApiPlugin.getDefault().getSessionManager();
        ISession[] sessions = manager.getSessions();
        ISession active = manager.getActiveSession();
        int i = 0;
        while (i < sessions.length) {
            final ISession session = sessions[i];
            MenuItem item = new MenuItem(this.menu, 16);
            Object[] labelparams = new Object[]{i + 1, session.getDescription()};
            item.setText(NLS.bind((String)ActionMessages.SelectSessionActionEntry_label, (Object[])labelparams));
            item.setSelection(session == active);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    manager.activateSession(session);
                }
            });
            ++i;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
    }
}

