/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToCleanC.core.stateMachineModelTranslator;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.c.c.CFactory;
import eu.fbk.tools.editor.c.c.FunctionDefinition;
import eu.fbk.tools.editor.c.c.TranslationUnit;
import eu.fbk.tools.editor.c.expression.expression.AssignmentExpression;
import eu.fbk.tools.editor.c.expression.expression.EnumSpecifier;
import eu.fbk.tools.editor.c.expression.expression.EnumeratorList;
import eu.fbk.tools.editor.c.expression.expression.EqualityExpression;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.ExpressionFactory;
import eu.fbk.tools.editor.c.expression.expression.Identifier;
import eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression;
import eu.fbk.tools.editor.c.expression.expression.TypeSpecifier;
import eu.fbk.tools.editor.c.statement.statement.AssertStatement;
import eu.fbk.tools.editor.c.statement.statement.AssignmentStatement;
import eu.fbk.tools.editor.c.statement.statement.CompoundStatement;
import eu.fbk.tools.editor.c.statement.statement.Declaration;
import eu.fbk.tools.editor.c.statement.statement.DeclarationSpecifiers;
import eu.fbk.tools.editor.c.statement.statement.Declarator;
import eu.fbk.tools.editor.c.statement.statement.IfStatement;
import eu.fbk.tools.editor.c.statement.statement.InitDeclarator;
import eu.fbk.tools.editor.c.statement.statement.InitDeclaratorList;
import eu.fbk.tools.editor.c.statement.statement.LabeledStatement;
import eu.fbk.tools.editor.c.statement.statement.Statement;
import eu.fbk.tools.editor.c.statement.statement.StatementFactory;
import eu.fbk.tools.editor.c.statement.statement.StatementList;
import eu.fbk.tools.editor.c.statement.statement.SwitchStatement;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;

public class StateMachineModelToCleanCModelTranslator {
    protected final String language = "CleanC";
    private final CFactory cleanCFactory = CFactory.eINSTANCE;
    protected final StatementFactory cleanCStmtFactory = StatementFactory.eINSTANCE;
    protected final ExpressionFactory cleanCExprFactory = ExpressionFactory.eINSTANCE;
    protected static final Logger logger = Logger.getLogger(StateMachineModelToCleanCModelTranslator.class);
    protected static String STATE_ENUM_TYPENAME = "State";
    protected static String STATE_ENUM_VAR = "state";
    protected static String TRANSITION_ENUM_TYPENAME = "Transition";
    protected static String TRANSITION_ENUM_VAR = "transition";
    protected static String INIT_TRANSITION_ENUM_TYPENAME = "InitTransition";
    protected static String INIT_TRANSITION_ENUM_VAR = "init_transition";
    private static String INIT_STATE = "t";
    protected static String INIT_FUNCTION = "init";
    protected static String STEP_FUNCTION = "step";
    private XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
    protected AbstractStateMachineModel abstractStateMachineModel;
    private static StateMachineModelToCleanCModelTranslator stateMachineModelToCleanCModelTranslator;
    private final Injector exprInjector = this.xtextResourceUtil.getCleanCExpressionInjector();
    protected final ParseHelper<?> exprParseHelper = (ParseHelper)this.exprInjector.getInstance(ParseHelper.class);
    private final Injector stmtInjector = this.xtextResourceUtil.getCleanCStatementInjector();
    protected final ParseHelper<?> stmtParseHelper = (ParseHelper)this.stmtInjector.getInstance(ParseHelper.class);

    public static StateMachineModelToCleanCModelTranslator getInstance(AbstractStateMachineModel abstractStateMachineModel) {
        if (stateMachineModelToCleanCModelTranslator == null) {
            stateMachineModelToCleanCModelTranslator = new StateMachineModelToCleanCModelTranslator(abstractStateMachineModel);
        }
        return stateMachineModelToCleanCModelTranslator;
    }

    protected StateMachineModelToCleanCModelTranslator(AbstractStateMachineModel abstractStateMachineModel) {
        this.abstractStateMachineModel = abstractStateMachineModel;
    }

    protected EList<Declaration> createCleanCVariables(EList<Object> ownerVariables) throws Exception {
        BasicEList varDeclList = new BasicEList();
        EList<Declaration> varDecl = this.createCleanCVaribles(ownerVariables);
        if (varDecl.size() != 0) {
            varDeclList.addAll(varDecl);
        }
        return varDeclList;
    }

    protected EnumSpecifier createEnumSpecifier(EList<String> enumList, String enumTypeName) throws Exception {
        if (enumList == null || enumList.isEmpty()) {
            throw new Exception("EnumeratorList is empty.");
        }
        EnumSpecifier ret = this.cleanCExprFactory.createEnumSpecifier();
        Identifier id = this.cleanCExprFactory.createIdentifier();
        id.setName(enumTypeName);
        ret.setId(id);
        EnumeratorList eList = this.cleanCExprFactory.createEnumeratorList();
        for (String enumName : enumList) {
            Identifier e = this.cleanCExprFactory.createIdentifier();
            e.setName(enumName);
            eList.getList().add((Object)e);
        }
        ret.setList(eList);
        return ret;
    }

    protected EnumSpecifier createEnumSpecifier(String enumTypeName) throws Exception {
        EnumSpecifier ret = this.cleanCExprFactory.createEnumSpecifier();
        Identifier id = this.cleanCExprFactory.createIdentifier();
        id.setName(enumTypeName);
        ret.setId(id);
        return ret;
    }

    protected Declaration createCleanCStatesType(EList<String> statesNameList) throws Exception {
        logger.debug((Object)"createCleanCStatesType");
        Declaration res = null;
        if (statesNameList != null) {
            res = this.cleanCStmtFactory.createDeclaration();
            res.setSpecifier(this.cleanCStmtFactory.createDeclarationSpecifiers());
            EnumSpecifier es = this.createEnumSpecifier(statesNameList, STATE_ENUM_TYPENAME);
            res.getSpecifier().getSpecifier().add((Object)es);
        }
        return res;
    }

    protected Declaration createCleanCStates() throws Exception {
        logger.debug((Object)"createCleanCStates");
        Declaration res = null;
        res = this.cleanCStmtFactory.createDeclaration();
        res.setSpecifier(this.cleanCStmtFactory.createDeclarationSpecifiers());
        EnumSpecifier es = this.createEnumSpecifier(STATE_ENUM_TYPENAME);
        res.getSpecifier().getSpecifier().add((Object)es);
        InitDeclarator d = this.cleanCStmtFactory.createInitDeclarator();
        d.setDeclarator(this.cleanCStmtFactory.createDeclarator());
        d.getDeclarator().setId(this.cleanCExprFactory.createIdentifier());
        d.getDeclarator().getId().setName(STATE_ENUM_VAR);
        res.setDeclaratorList(this.cleanCStmtFactory.createInitDeclaratorList());
        res.getDeclaratorList().getList().add((Object)d);
        return res;
    }

    private String getTState() {
        return INIT_STATE;
    }

    protected EList<Declaration> createCleanCVaribles(EList<?> attributes) throws Exception {
        BasicEList varDeclList = new BasicEList();
        if (attributes.size() != 0) {
            for (Object attribute : attributes) {
                Declaration inputVar = this.createAttributeBody(attribute);
                varDeclList.add((Object)inputVar);
            }
        }
        return varDeclList;
    }

    protected Declaration createCleanCTransitionVariableType(EList<String> transitionsNameList) throws Exception {
        Declaration ret = null;
        if (transitionsNameList.size() > 0) {
            ret = this.cleanCStmtFactory.createDeclaration();
            EnumSpecifier es = this.createEnumSpecifier(transitionsNameList, TRANSITION_ENUM_TYPENAME);
            ret.setSpecifier(this.cleanCStmtFactory.createDeclarationSpecifiers());
            ret.getSpecifier().getSpecifier().add((Object)es);
        }
        return ret;
    }

    protected Declaration createCleanCTransitionVariable() throws Exception {
        Declaration ret = null;
        ret = this.cleanCStmtFactory.createDeclaration();
        InitDeclarator d = this.cleanCStmtFactory.createInitDeclarator();
        Declarator decl = this.cleanCStmtFactory.createDeclarator();
        Identifier id = this.cleanCExprFactory.createIdentifier();
        EnumSpecifier es = this.createEnumSpecifier(TRANSITION_ENUM_TYPENAME);
        id.setName(TRANSITION_ENUM_VAR);
        decl.setId(id);
        d.setDeclarator(decl);
        ret.setDeclaratorList(this.cleanCStmtFactory.createInitDeclaratorList());
        ret.getDeclaratorList().getList().add((Object)d);
        ret.setSpecifier(this.cleanCStmtFactory.createDeclarationSpecifiers());
        ret.getSpecifier().getSpecifier().add((Object)es);
        return ret;
    }

    private EList<Declaration> createCleanCEvents(EList<String> eventsNameList) {
        BasicEList ret = null;
        if (eventsNameList.size() > 0) {
            ret = new BasicEList();
            for (String eventName : eventsNameList) {
                Declaration v = this.cleanCStmtFactory.createDeclaration();
                TypeSpecifier t = this.cleanCExprFactory.createTypeSpecifier();
                InitDeclarator d = this.cleanCStmtFactory.createInitDeclarator();
                Declarator decl = this.cleanCStmtFactory.createDeclarator();
                Identifier id = this.cleanCExprFactory.createIdentifier();
                t.setName("boolean");
                id.setName(eventName);
                decl.setId(id);
                d.setDeclarator(decl);
                v.setDeclaratorList(this.cleanCStmtFactory.createInitDeclaratorList());
                v.getDeclaratorList().getList().add((Object)d);
                v.setSpecifier(this.cleanCStmtFactory.createDeclarationSpecifiers());
                v.getSpecifier().getSpecifier().add((Object)t);
                ret.add((Object)v);
            }
        }
        return ret;
    }

    protected Declaration createCleanCInitTransitionVariableType(EList<String> initTransitionsNameList) throws Exception {
        Declaration ret = null;
        if (initTransitionsNameList != null) {
            ret = this.cleanCStmtFactory.createDeclaration();
            EnumSpecifier es = this.createEnumSpecifier(initTransitionsNameList, INIT_TRANSITION_ENUM_TYPENAME);
            DeclarationSpecifiers ds = this.cleanCStmtFactory.createDeclarationSpecifiers();
            ds.getSpecifier().add((Object)es);
            ret.setSpecifier(ds);
        }
        return ret;
    }

    protected Declaration createCleanCInitTransitionVariable() throws Exception {
        Declaration ret = this.cleanCStmtFactory.createDeclaration();
        InitDeclarator d = this.cleanCStmtFactory.createInitDeclarator();
        Declarator decl = this.cleanCStmtFactory.createDeclarator();
        Identifier id = this.cleanCExprFactory.createIdentifier();
        id.setName(INIT_TRANSITION_ENUM_VAR);
        decl.setId(id);
        d.setDeclarator(decl);
        EnumSpecifier es = this.createEnumSpecifier(INIT_TRANSITION_ENUM_TYPENAME);
        DeclarationSpecifiers ds = this.cleanCStmtFactory.createDeclarationSpecifiers();
        InitDeclaratorList idl = this.cleanCStmtFactory.createInitDeclaratorList();
        ds.getSpecifier().add((Object)es);
        ret.setSpecifier(ds);
        idl.getList().add((Object)d);
        ret.setDeclaratorList(idl);
        return ret;
    }

    private Declaration createAttributeBody(Object attribute) throws Exception {
        String inputVarName = this.abstractStateMachineModel.getAttributeName(attribute);
        InitDeclarator d = this.cleanCStmtFactory.createInitDeclarator();
        Object portType = this.abstractStateMachineModel.getAttributeType(attribute);
        Declarator decl = this.cleanCStmtFactory.createDeclarator();
        Identifier id = this.cleanCExprFactory.createIdentifier();
        id.setName(inputVarName);
        decl.setId(id);
        d.setDeclarator(decl);
        Declaration inputVar = this.cleanCStmtFactory.createDeclaration();
        DeclarationSpecifiers ds = this.cleanCStmtFactory.createDeclarationSpecifiers();
        InitDeclaratorList idl = this.cleanCStmtFactory.createInitDeclaratorList();
        ds.getSpecifier().add((Object)this.getCleanCType(portType));
        inputVar.setSpecifier(ds);
        idl.getList().add((Object)d);
        inputVar.setDeclaratorList(idl);
        return inputVar;
    }

    protected EList<Object> getAllAttributes(Object stateMachine) {
        BasicEList variables = new BasicEList();
        EList ownerOutputPorts = this.abstractStateMachineModel.getOwnerOutputPortsExceptEvents(stateMachine);
        EList ownerInputPorts = this.abstractStateMachineModel.getOwnerInputPortsExceptEvents(stateMachine);
        EList ownerAttributes = this.abstractStateMachineModel.getOwnerNonStaticAttributesExceptPorts(stateMachine);
        if (ownerOutputPorts != null) {
            variables.addAll((Collection)ownerOutputPorts);
        }
        if (ownerInputPorts != null) {
            variables.addAll((Collection)ownerInputPorts);
        }
        if (ownerAttributes != null) {
            variables.addAll((Collection)ownerAttributes);
        }
        return variables;
    }

    private TypeSpecifier getCleanCType(Object type) throws Exception {
        TypeSpecifier ret = null;
        if (this.abstractStateMachineModel.isEnumType(type)) {
            EList enumValues = this.abstractStateMachineModel.getEnumValues(type);
            ret = this.createEnumSpecifier((EList<String>)enumValues, this.abstractStateMachineModel.getEnumTypeName(type));
        } else {
            if (this.abstractStateMachineModel.isIntervalType(type)) {
                throw new Exception("Type " + type + " not supported.");
            }
            ret = this.cleanCExprFactory.createTypeSpecifier();
            if (this.abstractStateMachineModel.isBooleanType(type)) {
                ret.setName("boolean");
            } else if (this.abstractStateMachineModel.isIntegerType(type)) {
                ret.setName("integer");
            } else if (this.abstractStateMachineModel.isRealType(type)) {
                ret.setName("real");
            }
        }
        return ret;
    }

    public FunctionDefinition createEmptyFunction(String returnType, String funName) {
        FunctionDefinition ret = this.cleanCFactory.createFunctionDefinition();
        DeclarationSpecifiers ds = this.cleanCStmtFactory.createDeclarationSpecifiers();
        TypeSpecifier t = this.cleanCExprFactory.createTypeSpecifier();
        Declarator d = this.cleanCStmtFactory.createDeclarator();
        Identifier id = this.cleanCExprFactory.createIdentifier();
        t.setName(returnType);
        ds.getSpecifier().add((Object)t);
        ret.setSpecifier(ds);
        id.setName(funName);
        d.setId(id);
        d.getSuffixList().add((Object)this.cleanCStmtFactory.createDeclaratorSuffix());
        ret.setDeclator(d);
        ret.setStatement(this.cleanCStmtFactory.createCompoundStatement());
        return ret;
    }

    protected FunctionDefinition createInitFunction(EList<?> initTransitions) throws Exception {
        logger.debug((Object)"createInitFunction");
        FunctionDefinition ret = this.createEmptyFunction("void", INIT_FUNCTION);
        if (initTransitions != null && initTransitions.size() != 0) {
            BasicEList stmtList = new BasicEList();
            for (Object transition : initTransitions) {
                String transitionName = this.abstractStateMachineModel.getTransitionName(transition);
                String targetStateName = this.abstractStateMachineModel.getTransitionNextStateName(transition);
                CompoundStatement eStmt = this.cleanCStmtFactory.createCompoundStatement();
                IfStatement selStmt = this.cleanCStmtFactory.createIfStatement();
                EqualityExpression cond = this.createEqualityExpression(INIT_TRANSITION_ENUM_VAR, transitionName);
                String transitionGuard = this.abstractStateMachineModel.getTransitionGuardCondition(transition, "CleanC");
                if (transitionGuard != null && !transitionGuard.isEmpty()) {
                    Expression gExp = (Expression)this.exprParseHelper.parse((CharSequence)transitionGuard);
                    cond = this.createLogicalAndExpression((Expression)cond, gExp);
                }
                StatementList sl = null;
                String transitionEffect = this.abstractStateMachineModel.getTransitionEffectText(transition, "CleanC");
                if (transitionEffect != null && !transitionEffect.isEmpty()) {
                    CompoundStatement s = (CompoundStatement)this.stmtParseHelper.parse((CharSequence)transitionEffect);
                    sl = s.getStmtList();
                } else {
                    sl = this.cleanCStmtFactory.createStatementList();
                }
                sl.getStatement().add((Object)this.createAssignmentStatement(STATE_ENUM_VAR, targetStateName));
                eStmt.setStmtList(sl);
                selStmt.setStatement((Statement)eStmt);
                selStmt.setExpression((Expression)cond);
                stmtList.add((Object)selStmt);
            }
            IfStatement iteStmt = this.createCombinedITE((EList<IfStatement>)stmtList);
            StatementList sl = this.cleanCStmtFactory.createStatementList();
            sl.getStatement().add((Object)iteStmt);
            ret.getStatement().setStmtList(sl);
        }
        return ret;
    }

    protected IfStatement createCombinedITE(EList<IfStatement> stmtList) {
        IfStatement iteStmt;
        IfStatement tmpStmt = iteStmt = (IfStatement)stmtList.get(0);
        int i = 1;
        while (i < stmtList.size()) {
            tmpStmt.setElseStatement((Statement)stmtList.get(i));
            tmpStmt = (IfStatement)stmtList.get(i);
            ++i;
        }
        return iteStmt;
    }

    private EList<String> getTransitionGuards(EList<Object> transitionList) {
        if (transitionList == null || transitionList.isEmpty()) {
            return null;
        }
        BasicEList ret = new BasicEList();
        for (Object transition : transitionList) {
            String transitionGuard = this.abstractStateMachineModel.getTransitionGuardCondition(transition, "CleanC");
            if (transitionGuard == null || transitionGuard.isEmpty()) {
                ret.add((Object)"1");
                continue;
            }
            ret.add((Object)transitionGuard);
        }
        return ret;
    }

    protected AssertStatement createAssertStatementAtleastOneTransition(EList<Object> transitionList) throws Exception {
        if (transitionList == null || transitionList.isEmpty()) {
            return null;
        }
        AssertStatement ret = this.cleanCStmtFactory.createAssertStatement();
        EList<String> guardList = this.getTransitionGuards(transitionList);
        String tGuard = (String)guardList.get(0);
        Expression expr = (Expression)this.exprParseHelper.parse((CharSequence)tGuard);
        int i = 1;
        while (i < guardList.size()) {
            tGuard = (String)guardList.get(i);
            Expression tGuardExpr = (Expression)this.exprParseHelper.parse((CharSequence)tGuard);
            expr = this.createLogicalOrExpression(expr, tGuardExpr);
            ++i;
        }
        ret.setExpression(expr);
        return ret;
    }

    protected EList<AssertStatement> createAssertStatementsTransitionMutualExclusion(EList<Object> transitionList) throws Exception {
        if (transitionList == null || transitionList.isEmpty()) {
            return null;
        }
        BasicEList ret = new BasicEList();
        EList<String> guardList = this.getTransitionGuards(transitionList);
        int i = 0;
        while (i < guardList.size() - 1) {
            logger.debug((Object)("loop iteration: " + (String)guardList.get(i)));
            int j = i + 1;
            while (j < guardList.size()) {
                logger.debug((Object)("inner loop iteration: " + (String)guardList.get(j)));
                AssertStatement aStmt = this.cleanCStmtFactory.createAssertStatement();
                aStmt.setExpression((Expression)this.exprParseHelper.parse((CharSequence)("!(" + (String)guardList.get(i) + " && " + (String)guardList.get(j) + ")")));
                if (aStmt != null) {
                    ret.add((Object)aStmt);
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    protected FunctionDefinition createStepFunction(EList<?> stepTransitions) throws Exception {
        logger.debug((Object)"createStepFunction");
        FunctionDefinition ret = this.createEmptyFunction("void", STEP_FUNCTION);
        BasicEMap stateMap = new BasicEMap();
        if (stepTransitions != null && stepTransitions.size() != 0) {
            ret.getStatement().setStmtList(this.cleanCStmtFactory.createStatementList());
            for (Object transition : stepTransitions) {
                String originStateName = this.abstractStateMachineModel.getTransitionStartStateName(transition);
                if (!stateMap.containsKey((Object)originStateName)) {
                    stateMap.put((Object)originStateName, (Object)new BasicEList());
                }
                ((EList)stateMap.get((Object)originStateName)).add(transition);
            }
            BasicEList stmtList = new BasicEList();
            for (String k : stateMap.keySet()) {
                EList<AssertStatement> assertMutualExclusion;
                LabeledStatement lStmt = this.cleanCStmtFactory.createLabeledStatement();
                Expression tmpExpr = (Expression)this.exprParseHelper.parse((CharSequence)k);
                lStmt.setExpression(tmpExpr);
                CompoundStatement lStmtBody = this.cleanCStmtFactory.createCompoundStatement();
                lStmtBody.setStmtList(this.cleanCStmtFactory.createStatementList());
                AssertStatement assertAtleast = this.createAssertStatementAtleastOneTransition((EList<Object>)((EList)stateMap.get((Object)k)));
                if (assertAtleast != null) {
                    lStmtBody.getStmtList().getStatement().add((Object)assertAtleast);
                }
                if ((assertMutualExclusion = this.createAssertStatementsTransitionMutualExclusion((EList<Object>)((EList)stateMap.get((Object)k)))) != null && assertMutualExclusion.size() > 0) {
                    lStmtBody.getStmtList().getStatement().addAll(assertMutualExclusion);
                }
                BasicEList ifStmtList = new BasicEList();
                for (Object transition : (EList)stateMap.get((Object)k)) {
                    String transitionName = this.abstractStateMachineModel.getTransitionName(transition);
                    String targetStateName = this.abstractStateMachineModel.getTransitionNextStateName(transition);
                    String transitionGuard = this.abstractStateMachineModel.getTransitionGuardCondition(transition, "CleanC");
                    String transitionEffect = this.abstractStateMachineModel.getTransitionEffectText(transition, "CleanC");
                    Expression s = null;
                    s = transitionGuard != null && !transitionGuard.isEmpty() ? (Expression)this.exprParseHelper.parse((CharSequence)transitionGuard) : (Expression)this.exprParseHelper.parse((CharSequence)"1");
                    IfStatement ifStmt = this.cleanCStmtFactory.createIfStatement();
                    ifStmt.setExpression(s);
                    CompoundStatement ifStmtBody = null;
                    AssignmentStatement stateTran = this.createAssignmentStatement(STATE_ENUM_VAR, targetStateName);
                    if (transitionEffect != null && !transitionEffect.isEmpty()) {
                        ifStmtBody = (CompoundStatement)this.stmtParseHelper.parse((CharSequence)transitionEffect);
                    } else {
                        ifStmtBody = this.cleanCStmtFactory.createCompoundStatement();
                        ifStmtBody.setStmtList(this.cleanCStmtFactory.createStatementList());
                    }
                    ifStmtBody.getStmtList().getStatement().add((Object)stateTran);
                    ifStmtBody.getStmtList().getStatement().add((Object)this.createAssignmentStatement(TRANSITION_ENUM_VAR, transitionName));
                    ifStmt.setStatement((Statement)ifStmtBody);
                    ifStmtList.add((Object)ifStmt);
                }
                lStmtBody.getStmtList().getStatement().add((Object)this.createCombinedITE((EList<IfStatement>)ifStmtList));
                lStmtBody.getStmtList().getStatement().add((Object)this.cleanCStmtFactory.createBreakStatement());
                lStmt.setStatement((Statement)lStmtBody);
                stmtList.add((Object)lStmt);
            }
            SwitchStatement switchStmt = this.cleanCStmtFactory.createSwitchStatement();
            CompoundStatement switchStmtBody = this.cleanCStmtFactory.createCompoundStatement();
            switchStmt.setExpression((Expression)this.exprParseHelper.parse((CharSequence)STATE_ENUM_VAR));
            switchStmtBody.setStmtList(this.cleanCStmtFactory.createStatementList());
            switchStmtBody.getStmtList().getStatement().addAll((Collection)stmtList);
            LabeledStatement defaultStmt = this.cleanCStmtFactory.createLabeledStatement();
            CompoundStatement defaultStmtBody = this.cleanCStmtFactory.createCompoundStatement();
            AssertStatement defaultAssert = this.cleanCStmtFactory.createAssertStatement();
            defaultAssert.setExpression((Expression)this.exprParseHelper.parse((CharSequence)"0"));
            defaultStmtBody.setStmtList(this.cleanCStmtFactory.createStatementList());
            defaultStmtBody.getStmtList().getStatement().add((Object)defaultAssert);
            defaultStmt.setStatement((Statement)defaultStmtBody);
            switchStmtBody.getStmtList().getStatement().add((Object)defaultStmt);
            switchStmt.setStatement((Statement)switchStmtBody);
            ret.getStatement().getStmtList().getStatement().add((Object)switchStmt);
        }
        return ret;
    }

    protected LogicalAndExpression createLogicalAndExpression(Expression e1, Expression e2) {
        LogicalAndExpression ret = this.cleanCExprFactory.createLogicalAndExpression();
        ret.setLeft(e1);
        ret.setRight(e2);
        ret.setOp("&&");
        return ret;
    }

    private LogicalOrExpression createLogicalOrExpression(Expression e1, Expression e2) {
        LogicalOrExpression ret = this.cleanCExprFactory.createLogicalOrExpression();
        ret.setLeft(e1);
        ret.setRight(e2);
        ret.setOp("||");
        return ret;
    }

    public EqualityExpression createEqualityExpression(String arg1, String arg2) throws Exception {
        logger.debug((Object)("createEqualityExpression: " + arg1 + "==" + arg2));
        EqualityExpression ret = this.cleanCExprFactory.createEqualityExpression();
        ret.setLeft((Expression)this.exprParseHelper.parse((CharSequence)arg1));
        ret.setRight((Expression)this.exprParseHelper.parse((CharSequence)arg2));
        ret.setOp("==");
        return ret;
    }

    public AssignmentStatement createAssignmentStatement(String lhs, String rhs) throws Exception {
        logger.debug((Object)("createAssignmentStatement: " + lhs + "=" + rhs + ";"));
        AssignmentStatement ret = this.cleanCStmtFactory.createAssignmentStatement();
        AssignmentExpression assExp = this.cleanCExprFactory.createAssignmentExpression();
        Expression tmpExp = (Expression)this.exprParseHelper.parse((CharSequence)lhs);
        assExp.setLeft(tmpExp);
        tmpExp = (Expression)this.exprParseHelper.parse((CharSequence)rhs);
        assExp.setRight(tmpExp);
        assExp.setOp("=");
        ret.setExpression((Expression)assExp);
        return ret;
    }

    public String getFileName(Object stateMachine) {
        return String.valueOf(this.abstractStateMachineModel.getStateMachineOwnerName(stateMachine)) + "_" + this.abstractStateMachineModel.getStateMachineName(stateMachine);
    }

    public Object exportStateMachineAsCleanCProgram(Object stateMachine, IProgressMonitor monitor) throws Exception {
        EList nonInitTransitionsNameList;
        EList ownerStaticAttributes;
        Injector cInjector = this.xtextResourceUtil.getCleanCInjector();
        ParseHelper cParseHelper = (ParseHelper)cInjector.getInstance(ParseHelper.class);
        TranslationUnit cleanCTU = (TranslationUnit)cParseHelper.parse((CharSequence)"integer dummy; ");
        cleanCTU.getList().clear();
        EList statesNameList = this.abstractStateMachineModel.getIntermediateStatesNameList(stateMachine);
        if (statesNameList.size() > 0) {
            Declaration stateTypeDecl = this.createCleanCStatesType((EList<String>)statesNameList);
            cleanCTU.getList().add((Object)stateTypeDecl);
            Declaration stateDecl = this.createCleanCStates();
            cleanCTU.getList().add((Object)stateDecl);
        }
        EList<Object> ownerAttributes = this.getAllAttributes(stateMachine);
        EList<Declaration> varDecl = this.createCleanCVariables(ownerAttributes);
        cleanCTU.getList().addAll(varDecl);
        EList initTransitionsNameList = this.abstractStateMachineModel.getInitTransitionsNameList(stateMachine);
        if (initTransitionsNameList.size() > 0) {
            Declaration initTransDeclType = this.createCleanCInitTransitionVariableType((EList<String>)initTransitionsNameList);
            cleanCTU.getList().add((Object)initTransDeclType);
            Declaration initTransDecl = this.createCleanCInitTransitionVariable();
            cleanCTU.getList().add((Object)initTransDecl);
        }
        if ((ownerStaticAttributes = this.abstractStateMachineModel.getOwnerStaticAttributesExceptPorts(stateMachine)).size() > 0) {
            EList<Declaration> ownerStaticAttributesDecl = this.createCleanCVaribles(ownerStaticAttributes);
            cleanCTU.getList().addAll(ownerStaticAttributesDecl);
        }
        if ((nonInitTransitionsNameList = this.abstractStateMachineModel.getNonInitTransitionsNameList(stateMachine)).size() > 0) {
            Declaration nonInitTransDeclType = this.createCleanCTransitionVariableType((EList<String>)nonInitTransitionsNameList);
            cleanCTU.getList().add((Object)nonInitTransDeclType);
            Declaration nonInitTransDecl = this.createCleanCTransitionVariable();
            cleanCTU.getList().add((Object)nonInitTransDecl);
        }
        EList initTransitions = this.abstractStateMachineModel.getInitTransitions(stateMachine);
        FunctionDefinition initFunction = this.createInitFunction(initTransitions);
        cleanCTU.getList().add((Object)initFunction);
        EList nonInitTransitions = this.abstractStateMachineModel.getNonInitTransitions(stateMachine);
        FunctionDefinition stepFunction = this.createStepFunction(nonInitTransitions);
        cleanCTU.getList().add((Object)stepFunction);
        return cleanCTU;
    }
}

