/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.managers;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.constraint.PreferenceProperties;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.validator.messages.Messages;

public class ViewManager {
    public static String classDiagramKind = "PapyrusUMLClassDiagram";
    private static ViewManager instance = new ViewManager();

    public static ViewManager loadViewManager() {
        return instance;
    }

    @Deprecated
    public void check(Object notifier, StringBuffer s, DiagramStatus.DesignView currentView, TransactionalEditingDomain domain) throws RollbackException {
        if (notifier instanceof PageRef) {
            PageRef ref = (PageRef)notifier;
            Diagram diagram = null;
            if (!(ref.getEmfPageIdentifier() instanceof Diagram)) {
                return;
            }
            diagram = (Diagram)ref.getEmfPageIdentifier();
            this.check(diagram, s, currentView, domain);
        }
    }

    public void check(Diagram diagram, StringBuffer s, DiagramStatus.DesignView currentView, TransactionalEditingDomain domain) throws RollbackException {
        Boolean checkDiagramInView = Activator.getDefault().getPreferenceStore().getBoolean(PreferenceProperties.DIAGRAM_IN_VIEW);
        if (!checkDiagramInView.booleanValue()) {
            return;
        }
        if (diagram.getElement() instanceof Model) {
            s.append(Messages.error_diagramInView);
            throw new RollbackException((IStatus)new Status(4, "org.polarsys.chess.validator", Messages.error_diagramInView));
        }
        if (!currentView.isDiagramAllowed(diagram)) {
            CHESSProjectSupport.printlnToCHESSConsole((String)s.toString());
            throw new RollbackException((IStatus)new Status(4, "org.polarsys.chess.validator", Messages.error_diagramCurrentView));
        }
    }

    public boolean checkViewStereotype(Notification notification) {
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        DiagramStatus ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)editor);
        if (ds == null) {
            return true;
        }
        DiagramStatus.DesignView dview = ds.getCurrentView();
        boolean isCurrentPackageDeploymentView = false;
        Object n = notification.getNotifier();
        if (n instanceof Package) {
            Package pkg = (Package)n;
            isCurrentPackageDeploymentView = ViewUtils.isDeploymentView((Package)pkg);
        }
        if (isCurrentPackageDeploymentView || notification.getEventType() == 22 && dview.getName().equals("DeploymentView")) {
            return true;
        }
        return notification.getEventType() != 1 && notification.getEventType() != 4 && notification.getEventType() != 20 && notification.getEventType() != 21 && notification.getEventType() != 22;
    }
}

