/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.managers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.CHESS;
import org.polarsys.chess.chessmlprofile.Core.Domain;
import org.polarsys.chess.core.constraint.ConstraintList;
import org.polarsys.chess.core.constraint.DynamicConstraint;
import org.polarsys.chess.core.preferences.FilterableConstraint;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.service.internal.commands.switchers.SwitchToView;
import org.polarsys.chess.validator.libs.ConstraintsLib;
import org.polarsys.chess.validator.messages.Messages;

public class ModelParser {
    private IStatus modelOutsideView = new Status(4, "org.polarsys.chess.validator", Messages.NullViewMsg);
    private Shell activeShell = null;
    Domain currentDomain = this.getModelDomain();

    public IPreferencePage getId(String id) {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        List list = pm.getElements(0);
        int i = 0;
        while (i < list.size()) {
            PreferenceNode node = (PreferenceNode)list.get(i);
            IPreferencePage p = node.getPage();
            if (p != null && node.getId().equals(id)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public ModelParser() {
        PlatformUI.getWorkbench().getPreferenceManager();
        new ConstraintsLib();
    }

    public Command check(Notification notification, Object _notifier, DiagramStatus.DesignView currentView, boolean superuser) throws RollbackException {
        this.currentDomain = this.getModelDomain();
        Object notifier = notification.getNotifier();
        Command command = null;
        if (currentView == null) {
            if (notifier instanceof Model && notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getName().equals("name")) {
                return command;
            }
            CHESSProjectSupport.printlnToCHESSConsole((String)this.modelOutsideView.getMessage());
            return command;
        }
        if (!superuser && !ConstraintsLib.E_S_1_NEW.check(notification, currentView, this.currentDomain).isOK()) {
            CHESSProjectSupport.printlnToCHESSConsole((String)ConstraintsLib.E_S_1_NEW.getMessage());
            if (notification.getOldValue() != null || notification.getNewValue() != null) {
                String suggestedView = "";
                String concurrentView = "";
                boolean changeToConcurrentView = false;
                if (currentView.getName().equals("ComponentView")) {
                    suggestedView = "ExtraFunctionalView";
                    concurrentView = "ExtraFunctionalView";
                    changeToConcurrentView = false;
                } else if (currentView.getName().equals("DeploymentView")) {
                    suggestedView = "DependabilityView";
                    concurrentView = "DependabilityView";
                    changeToConcurrentView = false;
                } else if (currentView.getName().equals("DependabilityView")) {
                    suggestedView = "DeploymentView";
                    concurrentView = "DependabilityView";
                    changeToConcurrentView = true;
                } else if (currentView.getName().equals("ExtraFunctionalView")) {
                    suggestedView = "ComponentView";
                    concurrentView = "ExtraFunctionalView";
                    changeToConcurrentView = true;
                } else {
                    throw new RollbackException((IStatus)ConstraintsLib.E_S_1_NEW.getStatus());
                }
                if (!ViewUtils.isElementWritable_((EObject)((EObject)notifier), (Object)notification.getFeature(), (String)suggestedView, (DiagramStatus.DesignView)currentView, (Domain)this.currentDomain)) {
                    throw new RollbackException((IStatus)ConstraintsLib.E_S_1_NEW.getStatus());
                }
                Boolean go = false;
                String permissionErrorMsg = "The view \"" + currentView.getName() + "\" has no write access on the element \"" + ((EObject)notifier).eClass().getName() + "\", therefore it cannot be modified.";
                go = MessageDialog.openQuestion((Shell)this.activeShell, (String)"Permission error", (String)(permissionErrorMsg = String.valueOf(permissionErrorMsg) + " Do you want to continue moving automatically to the \"" + suggestedView + "\" view?"));
                if (!go.booleanValue()) {
                    throw new RollbackException((IStatus)ConstraintsLib.E_S_1_NEW.getStatus());
                }
                SwitchToView switcher = new SwitchToView(concurrentView, changeToConcurrentView, null);
                try {
                    switcher.execute();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    throw new RollbackException((IStatus)ConstraintsLib.E_S_1_NEW.getStatus());
                }
            }
        }
        for (FilterableConstraint fC : ConstraintList.getList()) {
            DynamicConstraint constr;
            if (!fC.isActive() || (constr = (DynamicConstraint)fC.getConstraint()).getName().compareTo("E_S_1") == 0 || constr.check(notification, currentView, this.currentDomain).isOK()) continue;
            CHESSProjectSupport.printlnToCHESSConsole((String)constr.getMessage());
            throw new RollbackException((IStatus)constr.getStatus());
        }
        return command;
    }

    private Domain getModelDomain() {
        Domain theDomain;
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        try {
            Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
            Model umlModel = ResourceUtils.getModel((Resource)res);
            if (umlModel.getAppliedStereotype("CHESS::Core::CHESS") != null) {
                Stereotype chessModelStereo = umlModel.getAppliedStereotype("CHESS::Core::CHESS");
                CHESS chessModel = (CHESS)umlModel.getStereotypeApplication(chessModelStereo);
                theDomain = chessModel.getDomain();
            } else {
                theDomain = Domain.CROSS_DOMAIN;
            }
        }
        catch (Exception exception) {
            theDomain = Domain.CROSS_DOMAIN;
        }
        return theDomain;
    }
}

