/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.utils;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaExecHost;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.NFPs.NfpConstraint;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.multicore.model.CHCore;
import org.polarsys.chess.multicore.model.CHTask;
import org.polarsys.chess.multicore.model.SupertaskInfo;

public class GeneratorUtils {
    private static final String MARTE_ASSIGN = "MARTE::MARTE_Foundations::Alloc::Assign";
    private static final String MARTE_NFPCONSTRAINT = "MARTE::MARTE_Foundations::NFPs::NfpConstraint";

    public static void buildTask2SuperTaskAssociations(Component hwSystem, HashMap<SupertaskInfo, LinkedHashSet<Object>> core2supertask, List<SupertaskInfo> supertaskInfoList) {
        GeneratorUtils.writeSupertaskinfo(supertaskInfoList);
        for (SupertaskInfo supertask : core2supertask.keySet()) {
            for (Object e : core2supertask.get(supertask)) {
                if (!(e instanceof CHTask)) continue;
                CHTask t = (CHTask)e;
                Comment c = hwSystem.createOwnedComment();
                UMLUtils.applyStereotype((Element)c, (String)MARTE_ASSIGN);
                Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)c, Assign.class);
                assign.getFrom().add((Object)t.getSlot().getBase_Slot());
                assign.getTo().add((Object)supertask.getProcessorInstance());
                Constraint n = hwSystem.createOwnedRule(supertask.getName());
                UMLUtils.applyStereotype((Element)n, (String)MARTE_NFPCONSTRAINT);
                NfpConstraint rule = (NfpConstraint)UMLUtils.getStereotypeApplication((Element)n, NfpConstraint.class);
                ValueSpecification valueSpec = n.createSpecification("supertask", null, UMLPackage.Literals.LITERAL_STRING);
                LiteralString value = (LiteralString)valueSpec;
                value.setValue(supertask.getName());
                assign.getImpliedConstraint().add((Object)rule);
                String context = t.getCHRtSpecification().getContext().getName();
                Constraint n2 = hwSystem.createOwnedRule(context);
                UMLUtils.applyStereotype((Element)n2, (String)MARTE_NFPCONSTRAINT);
                NfpConstraint rule2 = (NfpConstraint)UMLUtils.getStereotypeApplication((Element)n2, NfpConstraint.class);
                ValueSpecification valueSpec2 = n2.createSpecification("context", null, UMLPackage.Literals.LITERAL_STRING);
                LiteralString value2 = (LiteralString)valueSpec2;
                value2.setValue(context);
                assign.getImpliedConstraint().add((Object)rule2);
            }
        }
    }

    public static void eraseProcessorInfo(InstanceSpecification processorInstance) {
        for (Classifier classifier : processorInstance.getClassifiers()) {
            GaExecHost proc = (GaExecHost)UMLUtils.getStereotypeApplication((Element)classifier, GaExecHost.class);
            if (proc == null) continue;
            proc.setOtherSchedPolicy("");
        }
    }

    public static InstanceSpecification writeSupertaskinfo(List<SupertaskInfo> supertaskInfoList) {
        SupertaskInfo s = supertaskInfoList.get(0);
        InstanceSpecification processorInstance = s.getProcessorInstance();
        for (Classifier classifier : processorInstance.getClassifiers()) {
            GaExecHost proc = (GaExecHost)UMLUtils.getStereotypeApplication((Element)classifier, GaExecHost.class);
            if (proc == null) continue;
            StringBuilder sb = new StringBuilder();
            for (SupertaskInfo supertaskInfo : supertaskInfoList) {
                sb.append(String.format("[%s=%s],", supertaskInfo.getName(), Float.valueOf(supertaskInfo.getCapacity())));
            }
            sb.setLength(sb.length() - 1);
            String schedPolicy = String.format("RUN(%s)", sb.toString());
            proc.setOtherSchedPolicy(schedPolicy);
        }
        return processorInstance;
    }

    public static void buildTask2CoreAssociations(Component hwSystem, Map<CHCore, LinkedHashSet<Object>> result) {
        for (CHCore core : result.keySet()) {
            for (Object e : result.get(core)) {
                if (!(e instanceof CHTask)) continue;
                CHTask t = (CHTask)e;
                Comment c = hwSystem.createOwnedComment();
                UMLUtils.applyStereotype((Element)c, (String)MARTE_ASSIGN);
                Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)c, Assign.class);
                assign.getFrom().add((Object)t.getSlot().getBase_Slot());
                assign.getTo().add((Object)core.getProcessorInstance());
                GeneratorUtils.eraseProcessorInfo(core.getProcessorInstance());
                Constraint n = hwSystem.createOwnedRule(core.getName());
                UMLUtils.applyStereotype((Element)n, (String)MARTE_NFPCONSTRAINT);
                NfpConstraint rule = (NfpConstraint)UMLUtils.getStereotypeApplication((Element)n, NfpConstraint.class);
                ValueSpecification valueSpec = n.createSpecification("core", null, UMLPackage.Literals.LITERAL_STRING);
                LiteralString value = (LiteralString)valueSpec;
                value.setValue(core.getName());
                assign.getImpliedConstraint().add((Object)rule);
                String context = t.getCHRtSpecification().getContext().getName();
                Constraint n2 = hwSystem.createOwnedRule(context);
                UMLUtils.applyStereotype((Element)n2, (String)MARTE_NFPCONSTRAINT);
                NfpConstraint rule2 = (NfpConstraint)UMLUtils.getStereotypeApplication((Element)n2, NfpConstraint.class);
                ValueSpecification valueSpec2 = n2.createSpecification("context", null, UMLPackage.Literals.LITERAL_STRING);
                LiteralString value2 = (LiteralString)valueSpec2;
                value2.setValue(context);
                assign.getImpliedConstraint().add((Object)rule2);
            }
        }
    }
}

