/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.partitioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.polarsys.chess.multicore.partitioning.Bin;
import org.polarsys.chess.multicore.partitioning.BinPacker;
import org.polarsys.chess.multicore.partitioning.Heuristic;
import org.polarsys.chess.multicore.partitioning.RUNReduction;
import org.polarsys.chess.multicore.partitioning.Task;
import org.polarsys.chess.multicore.partitioning.WorstFitBinPacker;

public class BinPackerFactory {
    public static BinPacker getBinPacker(Heuristic heuristic) {
        WorstFitBinPacker packer;
        switch (heuristic) {
            case WORST_FIT: {
                packer = new WorstFitBinPacker();
                break;
            }
            default: {
                packer = new WorstFitBinPacker();
            }
        }
        return packer;
    }

    public static void main(String[] args) {
        ArrayList<Bin> allBins = new ArrayList<Bin>();
        ArrayList<Task> allTasks = new ArrayList<Task>();
        allTasks.add(new Task("Task1", Float.valueOf(60.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task2", Float.valueOf(60.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task3", Float.valueOf(30.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task4", Float.valueOf(30.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task5", Float.valueOf(60.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task6", Float.valueOf(30.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task7", Float.valueOf(30.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task8", Float.valueOf(30.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        allTasks.add(new Task("Task9", Float.valueOf(60.0f), Float.valueOf(100.0f), Float.valueOf(100.0f), Float.valueOf(0.0f), null));
        Map<Bin, List<Task>> firstPacking = BinPackerFactory.getBinPacker(Heuristic.WORST_FIT).pack(allBins, allTasks);
        for (Map.Entry<Bin, List<Task>> row : firstPacking.entrySet()) {
            System.out.print("LEVEL " + row.getKey().getLevel() + "-" + row.getKey().getId() + "(U=" + row.getKey().getCapacity() + ") -> {");
            for (Task t : row.getValue()) {
                System.out.print(" " + t.getId() + ",");
            }
            System.out.println("}");
        }
        if (firstPacking.size() > allBins.size()) {
            System.out.println("Starting RUN packing");
            allTasks = new ArrayList();
            for (Bin bin : firstPacking.keySet()) {
                allTasks.add(new Task(bin.getId().toString(), bin.getCapacity()));
            }
            Map<Bin, List<Task>> reductionTree = new RUNReduction().pack(null, allTasks);
            for (Map.Entry<Bin, List<Task>> row : reductionTree.entrySet()) {
                System.out.print("LEVEL " + row.getKey().getLevel() + "-" + row.getKey().getId() + "(U=" + row.getKey().getCapacity() + ") -> {");
                for (Task t : row.getValue()) {
                    System.out.print(" " + t.getId() + ",");
                }
                System.out.println("}");
            }
            BinPackerFactory.printMASTinput(firstPacking, reductionTree);
        }
    }

    private static void printMASTinput(Map<Bin, List<Task>> firstPack, Map<Bin, List<Task>> reductionTree) {
        Object[] firstPackSorted = firstPack.entrySet().toArray();
        Arrays.sort(firstPackSorted, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((Bin)((Map.Entry)o1).getKey()).getId() > ((Bin)((Map.Entry)o2).getKey()).getId()) {
                    return 1;
                }
                if (((Bin)((Map.Entry)o1).getKey()).getId() < ((Bin)((Map.Entry)o2).getKey()).getId()) {
                    return -1;
                }
                return 0;
            }
        });
        Object[] allBins = reductionTree.keySet().toArray();
        Arrays.sort(allBins, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((Bin)o1).getLevel() > ((Bin)o2).getLevel()) {
                    return -1;
                }
                if (((Bin)o1).getLevel() < ((Bin)o2).getLevel()) {
                    return 1;
                }
                return 0;
            }
        });
        ((Bin)allBins[0]).getLevel().intValue();
        System.out.println("-- Primary Schedulers\n");
        System.out.println("Scheduler (");
        System.out.println("\tType\t=> Primary_Scheduler,");
        System.out.println("\tName\t=> Scheduler_1,");
        System.out.println("\tPolicy\t=> ( Type => RUN ),");
        System.out.println("\tHost\t=> Multicore_1 );");
        System.out.println("\n-- Primary Scheduling Servers and Secondary Schedulers\n");
        int indexSupertask = 0;
        int i = 1;
        while (i < allBins.length && ((Bin)allBins[i]).getLevel() >= 0) {
            System.out.println("--*************** BRANCH ***************");
            System.out.println("Scheduling_Server (");
            System.out.println("\tType\t\t\t\t=> Regular,");
            System.out.println("\tName\t\t\t\t=> SuperTask_" + indexSupertask + ",");
            System.out.println("\tServer_Sched_parameters\t\t=> ( Type => RUN_Supertask,");
            System.out.println("\t\t\t\t\t     Utilization => " + ((Bin)allBins[i]).getCapacity() + " ),");
            System.out.println("\tScheduler\t\t\t=> Scheduler_1 );");
            System.out.println();
            System.out.println("Scheduler (");
            System.out.println("\tType\t=> Secondary_Scheduler,");
            System.out.println("\tName\t=> SecondaryScheduler_" + indexSupertask + ",");
            System.out.println("\tPolicy\t=> ( \tType\t=> EDF,");
            System.out.println("\t\t\tWorst_Context_Switch\t=> 20 ),");
            System.out.println("\tServer\t=> SuperTask_" + indexSupertask + " );");
            System.out.println();
            if (((Bin)allBins[i]).getLevel() == 0) {
                List<Task> tasks = reductionTree.get((Bin)allBins[i]);
                for (Task task : tasks) {
                    List leaves = (List)((Map.Entry)firstPackSorted[new Integer(task.getId())]).getValue();
                    for (Task leaf : leaves) {
                        System.out.println("Scheduling_Server (");
                        System.out.println("\tType\t\t\t\t=> Regular,");
                        System.out.println("\tName \t\t\t\t=> " + leaf.getId() + ",");
                        System.out.println("\tServer_Sched_Parameters\t\t=> (");
                        System.out.println("\t\tType\t\t\t=> EDF_policy,");
                        System.out.println("\t\tDeadline\t\t=> " + leaf.getT() + ",");
                        System.out.println("                Preassigned             => No),");
                        System.out.println("\tScheduler\t\t\t=> SecondaryScheduler_" + indexSupertask + ");");
                        System.out.println();
                    }
                }
            }
            ++indexSupertask;
            ++i;
        }
    }
}

