/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Segment;

public abstract class SegmentList {
    private final Net net;
    private Segment firstSegment;
    private Segment lastSegment;

    public SegmentList(Net net) {
        this.net = net;
    }

    public final Net getNet() {
        return this.net;
    }

    public final Segment getFirstSegment() {
        return this.firstSegment;
    }

    public final Segment getLastSegment() {
        return this.lastSegment;
    }

    public final Segment getSegment(long time) {
        Segment segment = this.lastSegment;
        while (segment != null) {
            if (segment.containsVisualTime(time)) {
                return segment;
            }
            segment = this.getPreviousSegment(segment);
        }
        return null;
    }

    void addSegment(Segment segment, boolean afterLast) {
        if (this.lastSegment == null) {
            this.lastSegment = segment;
            this.firstSegment = segment;
        } else if (afterLast) {
            this.setPreviousSegment(segment, this.lastSegment);
            this.setNextSegment(this.lastSegment, segment);
            this.lastSegment = segment;
        } else {
            this.setNextSegment(segment, this.firstSegment);
            this.setPreviousSegment(this.firstSegment, segment);
            this.firstSegment = segment;
        }
    }

    protected abstract Segment getNextSegment(Segment var1);

    protected abstract void setNextSegment(Segment var1, Segment var2);

    protected abstract Segment getPreviousSegment(Segment var1);

    protected abstract void setPreviousSegment(Segment var1, Segment var2);
}

