/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.dialogs.ValidationAssertionPropertyParametersDialog;
import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.dialogs.ValidationContractPropertyParametersDialog;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSModelFactory;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.services.OSSTranslatorServiceUI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import eu.fbk.tools.Request;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.widgets.Display;

public class OCRAExecService {
    private static OCRAExecService ocraServiceInstance;
    private static final Logger logger;
    private final String default_alg_type = "ic3";
    private final String default_USE_OLD_MODEL = "true";
    private AbstractSystemModel abstractSystemModel;
    private OCRADialogUtil ocraDialogUtil = OCRADialogUtil.getInstance();
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
    private OSSTranslatorServiceUI ossTranslatorServiceUI;
    private OSSTranslatorServiceAPI ossTranslatorServiceAPI;
    private OSSModelUtil ocraModelUtil = OSSModelUtil.getInstance();
    private OSSModelFactory ossModelFactory = OSSModelFactory.getInstance();
    ValidationContractPropertyParametersDialog contractValidationDialog;
    ValidationAssertionPropertyParametersDialog assertionValidationDialog;

    static {
        logger = Logger.getLogger(OCRAExecService.class);
    }

    public static OCRAExecService getInstance(AbstractSystemModel abstractSystemModel) {
        if (ocraServiceInstance == null) {
            ocraServiceInstance = new OCRAExecService(abstractSystemModel);
        }
        return ocraServiceInstance;
    }

    private OCRAExecService(AbstractSystemModel abstractSystemModel) {
        this.abstractSystemModel = abstractSystemModel;
        this.ossTranslatorServiceUI = OSSTranslatorServiceUI.getInstance((AbstractSystemModel)abstractSystemModel);
        this.ossTranslatorServiceAPI = OSSTranslatorServiceAPI.getInstance((AbstractSystemModel)abstractSystemModel);
    }

    public void executeCheckContractImplementation(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Checking Contract Implementation on oss file", 1);
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        File smvFile = this.ocraDialogUtil.getSmvFileFromFileDialog();
        boolean isDiscreteTime = MessageTimeModelDialog.openQuestion((boolean)true);
        logger.debug((Object)("ossFile: " + ossFile));
        logger.debug((Object)("smvFile: " + smvFile));
        String resultFile = this.ocraDirectoryUtil.getCommandCheckImplementationResultPath("File_" + ossFile.getName());
        boolean internalExecution = false;
        this.executeCheckContractImplementation(ossFile.getPath(), smvFile.getPath(), resultFile, isDiscreteTime, internalExecution);
        monitor.done();
    }

    public boolean executeCheckContractImplementation(Object umlSelectedComponent, Object instantiatedArchitectureConfiguration, Resource umlSelectedResource, String smvFilePath, boolean isDiscreteTime, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, boolean internalExecution, IProgressMonitor monitor) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, isDiscreteTime, usexTextValidation, showPopups, ossFilepath, monitor);
        if (instantiatedArchitectureConfiguration != null) {
            EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(instantiatedArchitectureConfiguration);
            String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(instantiatedArchitectureConfiguration);
            File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
            ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, isDiscreteTime, monitor);
        }
        return this.executeCheckContractImplementation(ossFile.getPath(), smvFilePath, resultFilePath, isDiscreteTime, internalExecution);
    }

    public boolean executeCheckCompositeContractImplementation(Object umlSelectedComponent, Resource umlSelectedResource, HashMap<String, String> smvPathComponentNameMap, boolean isDiscreteTime, boolean usexTextValidation, boolean showPopups, String ossDirPath, String mapDirPath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, isDiscreteTime, usexTextValidation, showPopups, ossDirPath, monitor);
        File smvMapFile = FileSystemUtil.createSmvMapFile((String)"map", (String)mapDirPath, smvPathComponentNameMap);
        return this.executeCheckCompositeImplementation(ossFile, smvMapFile, resultFilePath, isDiscreteTime, internalExecution);
    }

    public boolean createMonolithicSMV(Object umlSelectedComponent, Resource umlSelectedResource, HashMap<String, String> smvPathComponentNameMap, boolean isDiscreteTime, boolean usexTextValidation, boolean showPopups, String ossDirPath, String smvMapDirPath, String resultFilePath, boolean internalExecution, IProgressMonitor monitor) throws Exception {
        logger.debug((Object)"exportModelToOssFile");
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, isDiscreteTime, usexTextValidation, showPopups, ossDirPath, monitor);
        logger.debug((Object)"exportModelToOssFile done");
        File smvMapFile = FileSystemUtil.createSmvMapFile((String)"map", (String)smvMapDirPath, smvPathComponentNameMap);
        return this.executePrintSystemImplementation(ossFile, smvMapFile, resultFilePath, isDiscreteTime, internalExecution);
    }

    public void executeCheckContractRefinement(IProgressMonitor monitor) throws Exception {
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        boolean isDiscreteTime = MessageTimeModelDialog.openQuestion((boolean)false);
        String resultFile = this.ocraDirectoryUtil.getCommandCheckRefinementResultPath("File_" + ossFile.getName());
        this.executeCheckContractRefinement(ossFile, isDiscreteTime, resultFile, monitor, false);
        logger.debug((Object)("resultFile: " + resultFile));
    }

    public boolean executeCheckContractRefinement(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, boolean isDiscreteTime, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, isDiscreteTime, usexTextValidation, showPopups, ossFilepath, monitor);
        if (selectedInstantiatedArchitectureConfiguration != null) {
            String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
            EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
            File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
            ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, isDiscreteTime, monitor);
        }
        return this.executeCheckContractRefinement(ossFile, isDiscreteTime, resultFilePath, monitor, internalExecution);
    }

    public void executeValidationProperty(boolean isDiscreteTime, List<?> contextList, IProgressMonitor monitor) throws Exception {
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        OSS ossModel = this.ossModelFactory.createOssModel(ossFile);
        String[] componentTypes = this.ocraModelUtil.getComponentTypes(ossModel);
        ValidationContractPropertyParametersDialog dialog = new ValidationContractPropertyParametersDialog(componentTypes, ossModel, this.abstractSystemModel, contextList);
        dialog.open();
        if (dialog.goAhead()) {
            String resultFile = this.ocraDirectoryUtil.getCommandCheckPropertyResultPath("File_" + ossFile.getName());
            this.executeValidationProperty(ossFile, dialog.getSelectedButton(), dialog.getPropertyType(), dialog.getComponent(), dialog.getProperty(), dialog.getExpression(), isDiscreteTime, resultFile, monitor, false);
        }
    }

    public boolean executeValidationContractProperty(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, boolean isDiscreteTime, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, String[] expression, final List<?> contextList) throws Exception {
        final OSS ossModel = this.ossTranslatorServiceAPI.exportRootComponentToOssModel(umlSelectedComponent, isDiscreteTime, monitor);
        File ossFile = this.ossTranslatorServiceUI.exportOSSModelToOSSFile((Object)ossModel, umlSelectedResource, this.abstractSystemModel.getComponentName(umlSelectedComponent), ossFilepath, usexTextValidation, showPopups, monitor);
        if (ossFile != null) {
            if (selectedInstantiatedArchitectureConfiguration != null) {
                EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
                String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
                File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
                ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, isDiscreteTime, monitor);
            }
            final String[] componentTypes = this.ocraModelUtil.getComponentTypes(ossModel);
            Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    OCRAExecService.this.contractValidationDialog = new ValidationContractPropertyParametersDialog(componentTypes, ossModel, OCRAExecService.this.abstractSystemModel, contextList);
                    OCRAExecService.this.contractValidationDialog.open();
                }
            });
            if (this.contractValidationDialog.goAhead()) {
                if (expression != null) {
                    expression[0] = this.contractValidationDialog.getPropertyType();
                    expression[0] = String.valueOf(expression[0]) + "#" + this.contractValidationDialog.getComponent();
                    expression[0] = !this.contractValidationDialog.getProperty().equals("") ? String.valueOf(expression[0]) + "#" + this.contractValidationDialog.getProperty() : String.valueOf(expression[0]) + "#ALL";
                    if (!this.contractValidationDialog.getExpression().equals("") && !this.contractValidationDialog.getPropertyType().equals("consistency")) {
                        expression[0] = String.valueOf(expression[0]) + "#" + this.contractValidationDialog.getExpression();
                    }
                }
                return this.executeValidationProperty(ossFile, this.contractValidationDialog.getSelectedButton(), this.contractValidationDialog.getPropertyType(), this.contractValidationDialog.getComponent(), this.contractValidationDialog.getProperty(), this.contractValidationDialog.getExpression(), isDiscreteTime, resultFilePath, monitor, internalExecution);
            }
        }
        return false;
    }

    public boolean executeValidationAssertionProperty(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, boolean isDiscreteTime, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution, String[] expression, final List<?> contextList) throws Exception {
        final OSS ossModel = this.ossTranslatorServiceAPI.exportRootComponentToOssModel(umlSelectedComponent, isDiscreteTime, monitor);
        File ossFile = this.ossTranslatorServiceUI.exportOSSModelToOSSFile((Object)ossModel, umlSelectedResource, this.abstractSystemModel.getComponentName(umlSelectedComponent), ossFilepath, usexTextValidation, showPopups, monitor);
        if (ossFile != null) {
            if (selectedInstantiatedArchitectureConfiguration != null) {
                EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
                String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
                File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
                ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, isDiscreteTime, monitor);
            }
            final String[] componentTypes = this.ocraModelUtil.getComponentTypes(ossModel);
            Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    OCRAExecService.this.assertionValidationDialog = new ValidationAssertionPropertyParametersDialog(componentTypes, ossModel, OCRAExecService.this.abstractSystemModel, contextList);
                    OCRAExecService.this.assertionValidationDialog.open();
                }
            });
            if (this.assertionValidationDialog.goAhead()) {
                if (expression != null) {
                    expression[0] = this.assertionValidationDialog.getPropertyType();
                    expression[0] = String.valueOf(expression[0]) + "#" + this.assertionValidationDialog.getComponent();
                    expression[0] = !this.assertionValidationDialog.getProperties().equals("") ? String.valueOf(expression[0]) + "#" + this.assertionValidationDialog.getProperties() : String.valueOf(expression[0]) + "#ALL";
                    if (!this.assertionValidationDialog.getExpression().equals("") && !this.assertionValidationDialog.getPropertyType().equals("consistency")) {
                        expression[0] = String.valueOf(expression[0]) + "#" + this.assertionValidationDialog.getExpression();
                    }
                }
                return this.executeValidationProperty(ossFile, this.assertionValidationDialog.getSelectedButton(), this.assertionValidationDialog.getPropertyType(), this.assertionValidationDialog.getComponent(), this.assertionValidationDialog.getProperties(), this.assertionValidationDialog.getExpression(), isDiscreteTime, resultFilePath, monitor, internalExecution);
            }
        }
        return false;
    }

    public void executeComputeFaultTree(boolean isDiscreteTime, IProgressMonitor monitor) throws Exception {
        File ossFile = this.ocraDialogUtil.getOssFileFromFileDialog();
        String resultFile = this.ocraDirectoryUtil.getCommandFaultTreeGenResultPath("File_" + ossFile.getName());
        this.executeComputeFaultTree(ossFile, isDiscreteTime, resultFile, monitor, false);
    }

    public boolean executeComputeFaultTree(Object umlSelectedComponent, Object selectedInstantiatedArchitectureConfiguration, Resource umlSelectedResource, boolean isDiscreteTime, boolean usexTextValidation, boolean showPopups, String ossFilepath, String resultFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        File ossFile = this.ossTranslatorServiceUI.exportRootComponentToOssFile(umlSelectedComponent, umlSelectedResource, isDiscreteTime, usexTextValidation, showPopups, ossFilepath, monitor);
        if (selectedInstantiatedArchitectureConfiguration != null) {
            String configurationName = this.abstractSystemModel.getInstantiatedArchitectureConfigurationName(selectedInstantiatedArchitectureConfiguration);
            EList parametersList = this.abstractSystemModel.getParametersListFromInstantiatedArchitectureConfiguration(selectedInstantiatedArchitectureConfiguration);
            File parametersValuesFile = this.prepareParameterValuesFile((EList<String>)parametersList, ossFile.getName());
            ossFile = this.executeInstantiateArchitecture(configurationName, ossFile, parametersValuesFile, 1, isDiscreteTime, monitor);
        }
        return this.executeComputeFaultTree(ossFile, isDiscreteTime, resultFilePath, monitor, internalExecution);
    }

    public boolean executeCheckContractRefinement(File ossFile, boolean isDiscreteTime, String resultPath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        monitor.beginTask("Checking Contract Refinement on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckContractRefinement";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_ALG_TYPE = "algorithm_type";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        Request request = null;
        if (ossFile != null) {
            String model_time = "discrete";
            if (isDiscreteTime) {
                logger.debug((Object)"isDiscreteTime");
                model_time = "discrete";
            } else {
                logger.debug((Object)"hybrid");
                model_time = "hybrid";
            }
            String filePath = "\"" + ossFile.getPath() + "\"";
            logger.debug((Object)("ossFile.getPath(): " + filePath));
            CommandBuilder checkContractrefinement = CommandBuilder.build((String)ID_COMMAND);
            checkContractrefinement.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, filePath);
            checkContractrefinement.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            checkContractrefinement.setParameter(ID_PARAMETER_ALG_TYPE, "ic3");
            checkContractrefinement.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            checkContractrefinement.setParameter(ID_PARAMETER_RESULT_FILE, resultPath);
            Object objectResult = checkContractrefinement.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
            if (request == null) {
                monitor.done();
                return false;
            }
            if (!internalExecution) {
                monitor.done();
                return true;
            }
            if (request.getResultStatus() == Request.ResultStatus.available) {
                monitor.done();
                return true;
            }
            monitor.done();
            return false;
        }
        monitor.done();
        return false;
    }

    public boolean executeCheckContractImplementation(String ossFilePath, String smvFilePath, String outputFilePath, boolean isDiscreteTime, boolean internalExecution) throws Exception {
        logger.debug((Object)"executeCheckContractImplementation");
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckContractImplementation";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_BEHAVIOUR_FILE_SMV_PATH = "behaviour_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_USE_OLD_MODEL = "old_model_format";
        String ID_PARAMETER_ALG_TYPE = "algorithm_type";
        Request request = null;
        String model_time = "discrete";
        if (ossFilePath != null && smvFilePath != null) {
            if (isDiscreteTime) {
                logger.debug((Object)"isDiscreteTime");
                model_time = "discrete";
            } else {
                logger.debug((Object)"hybrid");
                model_time = "hybrid";
            }
            CommandBuilder checkContractImplementation = CommandBuilder.build((String)ID_COMMAND);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_BEHAVIOUR_FILE_SMV_PATH, smvFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            checkContractImplementation.setParameter(ID_PARAMETER_USE_OLD_MODEL, "true");
            checkContractImplementation.setParameter(ID_PARAMETER_ALG_TYPE, "ic3");
            checkContractImplementation.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            Object objectResult = checkContractImplementation.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
            if (request == null) {
                return false;
            }
            if (!internalExecution) {
                return true;
            }
            return request.getResultStatus() == Request.ResultStatus.available;
        }
        return false;
    }

    public boolean executeCheckCompositeImplementation(File ossFile, File mapFile, String outputFilePath, boolean isDiscreteTime, boolean internalExecution) throws Exception {
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckContractCompositeImplementationCommand";
        String ID_PARAMETER_MAP_FILE_PATH = "map_file";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_USE_OLD_MODEL = "old_model_format";
        String ID_PARAMETER_ALG_TYPE = "algorithm_type";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        Request request = null;
        String model_time = "discrete";
        if (ossFile != null && mapFile != null) {
            String ossFilePath = ossFile.getPath();
            String smvMapFilePath = mapFile.getPath();
            if (isDiscreteTime) {
                logger.debug((Object)"isDiscreteTime");
                model_time = "discrete";
            } else {
                logger.debug((Object)"hybrid");
                model_time = "hybrid";
            }
            CommandBuilder checkContractImplementation = CommandBuilder.build((String)ID_COMMAND);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_MAP_FILE_PATH, smvMapFilePath);
            checkContractImplementation.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            checkContractImplementation.setParameter(ID_PARAMETER_USE_OLD_MODEL, "true");
            checkContractImplementation.setParameter(ID_PARAMETER_ALG_TYPE, "ic3");
            checkContractImplementation.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            checkContractImplementation.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            Object objectResult = checkContractImplementation.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
            if (request == null) {
                return false;
            }
            if (!internalExecution) {
                return true;
            }
            return request.getResultStatus() == Request.ResultStatus.available;
        }
        return false;
    }

    public boolean executePrintSystemImplementation(File ossFile, File mapFile, String outputFilePath, boolean isDiscreteTime, boolean internalExecution) throws Exception {
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.PrintSystemImplementation";
        String ID_PARAMETER_MAP_FILE_PATH = "map_file";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_PARAMETER_USE_OLD_MODEL = "old_model_format";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        Request request = null;
        String model_time = "discrete";
        if (ossFile != null && mapFile != null) {
            String ossFilePath = ossFile.getPath();
            String smvMapFilePath = mapFile.getPath();
            if (isDiscreteTime) {
                logger.debug((Object)"isDiscreteTime");
                model_time = "discrete";
            } else {
                logger.debug((Object)"hybrid");
                model_time = "hybrid";
            }
            CommandBuilder printSystemImplementation = CommandBuilder.build((String)ID_COMMAND);
            printSystemImplementation.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            printSystemImplementation.setParameter(ID_PARAMETER_MAP_FILE_PATH, smvMapFilePath);
            printSystemImplementation.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            printSystemImplementation.setParameter(ID_PARAMETER_USE_OLD_MODEL, "true");
            printSystemImplementation.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            printSystemImplementation.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            Object objectResult = printSystemImplementation.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
            if (request == null) {
                return false;
            }
            if (!internalExecution) {
                return true;
            }
            return request.getResultStatus() == Request.ResultStatus.available;
        }
        return false;
    }

    public boolean executeComputeFaultTree(File ossFile, boolean isDiscreteTime, String outputFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        monitor.beginTask("Compute the contract-based Fault Tree on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.ComputeFaultTree";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        Request request = null;
        if (ossFile != null) {
            logger.debug((Object)("ossFile.getPath(): " + ossFile.getPath()));
            String model_time = "discrete";
            if (isDiscreteTime) {
                logger.debug((Object)"isDiscreteTime");
                model_time = "discrete";
            } else {
                logger.debug((Object)"hybrid");
                model_time = "hybrid";
            }
            CommandBuilder computeFaultTree = CommandBuilder.build((String)ID_COMMAND);
            computeFaultTree.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFile.getPath());
            computeFaultTree.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            computeFaultTree.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            computeFaultTree.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            Object objectResult = computeFaultTree.execute();
            logger.debug((Object)("in executeComputeFaultTree, outputFilePath: " + outputFilePath));
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
            if (request == null) {
                monitor.done();
                return false;
            }
            if (!internalExecution) {
                monitor.done();
                return true;
            }
            if (request.getResultStatus() == Request.ResultStatus.available) {
                monitor.done();
                return true;
            }
            monitor.done();
            return false;
        }
        monitor.done();
        return false;
    }

    public boolean executeValidationProperty(File ossFile, ValidationType selectedValidationType, String propertyType, String componentName, String properties, String expression, boolean isDiscreteTime, String outputFilePath, IProgressMonitor monitor, boolean internalExecution) throws Exception {
        String timeModel;
        monitor.beginTask("Check Validation Property on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.CheckValidationProperty";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_VALIDATION_TYPE = "property_validation_type";
        String ID_PARAMETER_COMPONENT_NAME = "component_name";
        String ID_PARAMETER_PROPERTIES = "properties";
        String ID_PARAMETER_EXPRESSION = "possibility";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_INTERNAL_EXECUTION = "internal_execution";
        Request request = null;
        if (isDiscreteTime) {
            logger.debug((Object)"isDiscreteTime");
            timeModel = "discrete";
        } else {
            logger.debug((Object)"hybrid");
            timeModel = "hybrid";
        }
        String ossFilePath = ossFile.getPath();
        if (ossFile != null) {
            Object objectResult;
            CommandBuilder checkValidationProperty = CommandBuilder.build((String)ID_COMMAND);
            checkValidationProperty.setParameter(ID_PARAMETER_MODEL_TIME, timeModel);
            checkValidationProperty.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFilePath);
            checkValidationProperty.setParameter(ID_VALIDATION_TYPE, propertyType);
            checkValidationProperty.setParameter(ID_INTERNAL_EXECUTION, String.valueOf(internalExecution));
            checkValidationProperty.setParameter(ID_PARAMETER_RESULT_FILE, outputFilePath);
            if (componentName.compareTo("") != 0) {
                checkValidationProperty.setParameter(ID_PARAMETER_COMPONENT_NAME, componentName);
                if (componentName.compareTo("ALL") == 0) {
                    properties = "ALL";
                }
            }
            if (properties.compareTo("") != 0) {
                checkValidationProperty.setParameter(ID_PARAMETER_PROPERTIES, properties);
            }
            if ((selectedValidationType == ValidationType.POSSIBILITY || selectedValidationType == ValidationType.ENTAILMENT) && expression.compareTo("") != 0) {
                checkValidationProperty.setParameter(ID_PARAMETER_EXPRESSION, "'" + expression + "'");
            }
            if ((objectResult = checkValidationProperty.execute()) != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
            if (request == null) {
                monitor.done();
                return false;
            }
            if (!internalExecution) {
                monitor.done();
                return true;
            }
            if (request.getResultStatus() == Request.ResultStatus.available) {
                monitor.done();
                return true;
            }
            monitor.done();
            return false;
        }
        return false;
    }

    public Map<String, String> executeGetParameters(File ossFile, boolean isDiscreteTime, IProgressMonitor monitor) throws Exception {
        String parameterListResultFilePath = this.ocraDirectoryUtil.getParametersResultFilePath(ossFile.getName());
        this.executeGetParameters(ossFile, parameterListResultFilePath, isDiscreteTime, monitor);
        return this.parseParametersFileAsMap(new File(parameterListResultFilePath));
    }

    public void executeGetParameters(File ossFile, String parameterListResultFilePath, boolean isDiscreteTime, IProgressMonitor monitor) throws NotDefinedException, ExecutionException, NotEnabledException, NotHandledException {
        monitor.beginTask("Retriving List of parameters to set", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.getParametersFromParamArchitecture";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        String ID_INTERNAL_EXE = "internal_execution";
        if (ossFile != null) {
            String model_time = "discrete";
            if (isDiscreteTime) {
                logger.debug((Object)"isDiscreteTime");
                model_time = "discrete";
            } else {
                logger.debug((Object)"hybrid");
                model_time = "hybrid";
            }
            String filePath = "\"" + ossFile.getPath() + "\"";
            logger.debug((Object)("ossFile.getPath(): " + filePath));
            CommandBuilder getParametersCommand = CommandBuilder.build((String)ID_COMMAND);
            getParametersCommand.setParameter(ID_INTERNAL_EXE, "true");
            getParametersCommand.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, filePath);
            getParametersCommand.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            getParametersCommand.setParameter(ID_PARAMETER_RESULT_FILE, parameterListResultFilePath);
            getParametersCommand.execute();
        }
        monitor.done();
    }

    public File executeInstantiateArchitecture(String originalOssFileName, File ossFile, File parametersValuesFile, int numIstantiation, boolean isDiscreteTime, IProgressMonitor monitor) throws Exception {
        String resultOssFilePath = this.ocraDirectoryUtil.getCommandInstantiateParamArchResultPath(originalOssFileName, numIstantiation);
        logger.debug((Object)("executeInstantiateArchitecture resultOssFilePath: " + resultOssFilePath));
        this.executeInstantiateParamArch(ossFile, parametersValuesFile, isDiscreteTime, resultOssFilePath, monitor);
        File outputFile = new File(resultOssFilePath);
        if (!outputFile.exists()) {
            throw new Exception("executeInstantiateArchitecture. output not created: " + outputFile.getPath());
        }
        return outputFile;
    }

    public File prepareParameterValuesFile(EList<String> parametersList, String ossFileName) throws Exception {
        String inputParamFilePath = this.ocraDirectoryUtil.getInputParametersFilePath(ossFileName);
        logger.debug((Object)("executeInstantiateArchitecture inputParamFilePath: " + inputParamFilePath));
        return this.createParameterValuesFile(parametersList, inputParamFilePath);
    }

    public File createParameterValuesFile(EList<String> parametersList, String inputParamFilePath) throws Exception {
        int numLines = 1;
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(inputParamFilePath), "utf-8"));){
            for (String parameter : parametersList) {
                logger.debug((Object)("prepareParameterValuesFile parameter: " + parameter));
                writer.write(parameter);
                if (numLines != parametersList.size()) {
                    writer.write(",");
                }
                ++numLines;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new File(inputParamFilePath);
    }

    public File prepareFinalParameterValuesFile(EList<EList<String>> parametersList, String ossFileName) throws Exception {
        String inputParamFilePath = this.ocraDirectoryUtil.getInputParametersFilePath(ossFileName);
        logger.debug((Object)("executeInstantiateArchitecture inputParamFilePath: " + inputParamFilePath));
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(inputParamFilePath), "utf-8"));){
            for (EList parameters : parametersList) {
                for (String parameter : parameters) {
                    writer.write(parameter);
                    ((Writer)writer).write(10);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new File(inputParamFilePath);
    }

    public Map<String, String> parseParametersFileAsMap(File parametersListFile) throws FileNotFoundException {
        Scanner s = new Scanner(parametersListFile);
        s.useDelimiter(",|\\n|\\r");
        LinkedHashMap<String, String> parametersList = new LinkedHashMap<String, String>();
        while (s.hasNext()) {
            String currParam = s.next();
            if (currParam.isEmpty()) continue;
            logger.debug((Object)("currParam: " + currParam));
            parametersList.put(currParam.trim(), "");
        }
        s.close();
        return parametersList;
    }

    public ArrayList<String> parseParametersFileAsArray(File parametersListFile) throws FileNotFoundException {
        Scanner s = new Scanner(parametersListFile);
        ArrayList<String> parametersList = new ArrayList<String>();
        while (s.hasNext()) {
            parametersList.add(s.next());
        }
        s.close();
        return parametersList;
    }

    public void executeInstantiateParamArch(File ossFile, File parametersValuesFile, boolean isDiscreteTime, String resultFilePath, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Instantiating Parameterized Architecture on oss file", 1);
        String ID_COMMAND = "eu.fbk.tools.adapter.ui.commands.contract.InstantiateParamArchitecture";
        String ID_INTERNAL_EXE = "internal_execution";
        String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
        String ID_PARAMETER_LIST_FILE_OSS_PATH = "param_list";
        String ID_PARAMETER_MODEL_TIME = "time_model";
        String ID_PARAMETER_RESULT_FILE = "result_file";
        if (ossFile != null) {
            String model_time = "discrete";
            if (isDiscreteTime) {
                logger.debug((Object)"isDiscreteTime");
                model_time = "discrete";
            } else {
                logger.debug((Object)"hybrid");
                model_time = "hybrid";
            }
            String filePath = "\"" + ossFile.getPath() + "\"";
            String parametersValuesFilePath = "\"" + parametersValuesFile.getPath() + "\"";
            logger.debug((Object)("filePath: " + filePath));
            logger.debug((Object)("parametersValuesFilePath: " + parametersValuesFilePath));
            logger.debug((Object)("model_time: " + model_time));
            logger.debug((Object)("resultFilePath: " + resultFilePath));
            CommandBuilder instantiateParamArchCommand = CommandBuilder.build((String)ID_COMMAND);
            instantiateParamArchCommand.setParameter(ID_INTERNAL_EXE, "true");
            instantiateParamArchCommand.setParameter(ID_PARAMETER_MODEL_FILE_OSS_PATH, filePath);
            instantiateParamArchCommand.setParameter(ID_PARAMETER_LIST_FILE_OSS_PATH, parametersValuesFilePath);
            instantiateParamArchCommand.setParameter(ID_PARAMETER_MODEL_TIME, model_time);
            instantiateParamArchCommand.setParameter(ID_PARAMETER_RESULT_FILE, resultFilePath);
            instantiateParamArchCommand.execute();
        }
        monitor.done();
    }

    public static enum ValidationType {
        CONSISTENCY,
        POSSIBILITY,
        ENTAILMENT;

    }
}

