/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.dialogs;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ValidationContractPropertyParametersDialog
extends Dialog {
    private static final Logger logger = Logger.getLogger(ValidationContractPropertyParametersDialog.class);
    private boolean validateSerializedElement = false;
    AbstractSystemModel systemModel;
    private Table propertyText;
    private Text expressionText;
    private CCombo chooseAnalysisCtxField;
    private SelectionListener modAnalysisCtxListener;
    private List<?> contextList;
    private CCombo validationType;
    private CCombo componentType;
    private String[] componentTypes;
    private OSS ocraModel;
    private String propertyType;
    private String component;
    private String property;
    private String expression;
    private OCRAExecService.ValidationType selectedButton;
    private boolean goAhead = false;
    private OSSModelUtil ocraModelUtil = OSSModelUtil.getInstance();

    public ValidationContractPropertyParametersDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(32);
    }

    public ValidationContractPropertyParametersDialog(String[] componentTypes, OSS ocraModel, final AbstractSystemModel systemModel, final List<?> contextList) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(32);
        this.componentTypes = componentTypes;
        this.ocraModel = ocraModel;
        this.systemModel = systemModel;
        this.contextList = contextList;
        this.modAnalysisCtxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selInd = ValidationContractPropertyParametersDialog.this.chooseAnalysisCtxField.getSelectionIndex();
                if (selInd != -1) {
                    Object ctx = contextList.get(selInd);
                    String contextAnalysisType = systemModel.getValidationPropertyAnalysisContextType(ctx);
                    ValidationContractPropertyParametersDialog.this.validationType.select(ValidationContractPropertyParametersDialog.this.validationType.indexOf(contextAnalysisType));
                    ValidationContractPropertyParametersDialog.this.validationType.notifyListeners(13, new Event());
                    String contextAnalysisExpr = systemModel.getValidationPropertyAnalysisContextExpression(ctx);
                    if (contextAnalysisExpr != null) {
                        ValidationContractPropertyParametersDialog.this.expressionText.setText(contextAnalysisExpr);
                        ValidationContractPropertyParametersDialog.this.expressionText.notifyListeners(2, new Event());
                    }
                    logger.debug((Object)"try to select componentType");
                    String contextAnalysisComp = systemModel.getValidationPropertyAnalysisContextComponent(ctx);
                    ValidationContractPropertyParametersDialog.this.componentType.select(ValidationContractPropertyParametersDialog.this.componentType.indexOf(contextAnalysisComp));
                    ValidationContractPropertyParametersDialog.this.componentType.notifyListeners(13, new Event());
                    String[] contextAnalysisProps = systemModel.getValidationPropertyAnalysisContextSelectedProperties(ctx);
                    if (contextAnalysisProps.length != 1 || !contextAnalysisProps[0].equals("ALL")) {
                        int i = 0;
                        while (i < ValidationContractPropertyParametersDialog.this.propertyText.getItemCount()) {
                            TableItem currItem = ValidationContractPropertyParametersDialog.this.propertyText.getItem(i);
                            currItem.setChecked(false);
                            String[] stringArray = contextAnalysisProps;
                            int n = contextAnalysisProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String selProp = stringArray[n2];
                                if (currItem.getText().equals(selProp)) {
                                    currItem.setChecked(true);
                                    break;
                                }
                                ++n2;
                            }
                            ++i;
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Validation Property parameters");
    }

    protected void okPressed() {
        TableItem[] tableItems;
        this.property = "";
        TableItem[] tableItemArray = tableItems = this.propertyText.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.property = this.property.concat(String.valueOf(item.getText()) + ",");
            }
            ++n2;
        }
        if (this.property.length() > 0) {
            this.property = this.property.substring(0, this.property.length() - 1);
        }
        this.expression = this.expressionText.getText();
        this.propertyType = this.validationType.getText();
        this.component = this.componentType.getText();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite validationContainer = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        validationContainer.setLayout((Layout)gridLayout);
        GridData filledGridData = new GridData();
        filledGridData.horizontalAlignment = 4;
        filledGridData.grabExcessHorizontalSpace = true;
        GridData simpleGridData = new GridData();
        validationContainer.setLayoutData((Object)filledGridData);
        Label contextAnalysisLabel = new Label(validationContainer, 0);
        contextAnalysisLabel.setText("Context Analysis");
        this.chooseAnalysisCtxField = new CCombo(validationContainer, 2060);
        this.chooseAnalysisCtxField.setBackground(Display.getDefault().getSystemColor(1));
        for (Object ctx : this.contextList) {
            this.chooseAnalysisCtxField.add(this.systemModel.getAnalysisContextName(ctx));
        }
        this.chooseAnalysisCtxField.addSelectionListener(this.modAnalysisCtxListener);
        this.chooseAnalysisCtxField.setLayoutData((Object)filledGridData);
        Label labelPropertyType = new Label(validationContainer, 16384);
        labelPropertyType.setText("Property Type");
        labelPropertyType.setLayoutData((Object)simpleGridData);
        this.validationType = new CCombo(validationContainer, 2056);
        this.validationType.setBackground(Display.getDefault().getSystemColor(1));
        this.validationType.add("consistency");
        this.validationType.add("possibility");
        this.validationType.add("entailment");
        this.validationType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ValidationContractPropertyParametersDialog.this.validationType.getText().equals("entailment")) {
                    ValidationContractPropertyParametersDialog.this.expressionText.setEnabled(true);
                    ValidationContractPropertyParametersDialog.this.selectedButton = OCRAExecService.ValidationType.ENTAILMENT;
                    ValidationContractPropertyParametersDialog.this.getButton(0).setEnabled(false);
                } else if (ValidationContractPropertyParametersDialog.this.validationType.getText().equals("possibility")) {
                    ValidationContractPropertyParametersDialog.this.expressionText.setEnabled(true);
                    ValidationContractPropertyParametersDialog.this.selectedButton = OCRAExecService.ValidationType.POSSIBILITY;
                    ValidationContractPropertyParametersDialog.this.getButton(0).setEnabled(false);
                } else {
                    ValidationContractPropertyParametersDialog.this.expressionText.setEnabled(false);
                    ValidationContractPropertyParametersDialog.this.selectedButton = OCRAExecService.ValidationType.CONSISTENCY;
                    ValidationContractPropertyParametersDialog.this.getButton(0).setEnabled(true);
                    ValidationContractPropertyParametersDialog.this.getButton(0).setToolTipText(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.validationType.setLayoutData((Object)filledGridData);
        Label labelExpression = new Label(validationContainer, 16384);
        labelExpression.setText("Expression");
        labelExpression.setLayoutData((Object)simpleGridData);
        this.expressionText = new Text(validationContainer, 18432);
        this.expressionText.setText("");
        this.expressionText.setLayoutData((Object)filledGridData);
        this.expressionText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (ValidationContractPropertyParametersDialog.this.expressionText.getText().length() > 0) {
                    ValidationContractPropertyParametersDialog.this.getButton(0).setEnabled(true);
                } else {
                    ValidationContractPropertyParametersDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Label buttonComponent = new Label(validationContainer, 16384);
        buttonComponent.setText("Component");
        buttonComponent.setLayoutData((Object)simpleGridData);
        this.componentType = new CCombo(validationContainer, 2056);
        this.componentType.setBackground(Display.getDefault().getSystemColor(1));
        this.componentType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedComponentTypeName = ValidationContractPropertyParametersDialog.this.componentType.getText();
                if (selectedComponentTypeName.compareTo("ALL") != 0) {
                    ValidationContractPropertyParametersDialog.this.propertyText.setEnabled(true);
                    try {
                        ValidationContractPropertyParametersDialog.this.propertyText.removeAll();
                        String[] contactPropertiesID = ValidationContractPropertyParametersDialog.this.ocraModelUtil.getAllContactPropertiesIDOfSubComponentsAsStr(selectedComponentTypeName, ValidationContractPropertyParametersDialog.this.ocraModel, ValidationContractPropertyParametersDialog.this.validateSerializedElement);
                        int i = 0;
                        while (i < contactPropertiesID.length) {
                            TableItem item = new TableItem(ValidationContractPropertyParametersDialog.this.propertyText, 0);
                            item.setText(contactPropertiesID[i]);
                            ++i;
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    ValidationContractPropertyParametersDialog.this.propertyText.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.componentType.add("ALL");
        String[] stringArray = this.componentTypes;
        int n = this.componentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String componenetType = stringArray[n2];
            this.componentType.add(componenetType);
            ++n2;
        }
        this.componentType.setLayoutData((Object)filledGridData);
        Label labelProperties = new Label(validationContainer, 16384);
        labelProperties.setText("Properties ID");
        labelProperties.setLayoutData((Object)simpleGridData);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 380;
        this.propertyText = new Table(validationContainer, 2848);
        this.propertyText.setLayoutData((Object)gridData);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(800, 700);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public String getProperty() {
        return this.property;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public String getComponent() {
        return this.component;
    }

    public String getExpression() {
        return this.expression;
    }

    public OCRAExecService.ValidationType getSelectedButton() {
        return this.selectedButton;
    }
}

