/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.dialogs;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.widgets.StyledText;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ValidationAssertionPropertyParametersDialog
extends Dialog {
    private static final Logger logger = Logger.getLogger(ValidationAssertionPropertyParametersDialog.class);
    private boolean validateSerializedElement = false;
    AbstractSystemModel systemModel;
    private Table propertyText;
    private String[] componentTypes;
    private OSS ocraModel;
    private String propertyType;
    private String component;
    private String properties;
    private SelectionListener modAnalysisCtxListener;
    private List<?> contextList;
    private String expression;
    private CCombo chooseAnalysisCtxField;
    private CCombo validationType;
    private StyledText expressionText;
    private CCombo componentType;
    private OCRAExecService.ValidationType selectedButton;
    private boolean goAhead = false;
    private OSSModelUtil ocraModelUtil = OSSModelUtil.getInstance();

    public ValidationAssertionPropertyParametersDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(32);
    }

    public ValidationAssertionPropertyParametersDialog(String[] componentTypes, OSS ocraModel, final AbstractSystemModel systemModel, final List<?> contextList) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(32);
        this.componentTypes = componentTypes;
        this.ocraModel = ocraModel;
        this.systemModel = systemModel;
        this.contextList = contextList;
        this.modAnalysisCtxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selInd = ValidationAssertionPropertyParametersDialog.this.chooseAnalysisCtxField.getSelectionIndex();
                if (selInd != -1) {
                    Object ctx = contextList.get(selInd);
                    String contextAnalysisType = systemModel.getValidationPropertyAnalysisContextType(ctx);
                    ValidationAssertionPropertyParametersDialog.this.validationType.select(ValidationAssertionPropertyParametersDialog.this.validationType.indexOf(contextAnalysisType));
                    ValidationAssertionPropertyParametersDialog.this.validationType.notifyListeners(13, new Event());
                    String contextAnalysisExpr = systemModel.getValidationPropertyAnalysisContextExpression(ctx);
                    if (contextAnalysisExpr != null) {
                        ValidationAssertionPropertyParametersDialog.this.expressionText.setText(contextAnalysisExpr);
                        ValidationAssertionPropertyParametersDialog.this.expressionText.notifyListeners(2, new Event());
                    }
                    logger.debug((Object)"try to select componentType");
                    String contextAnalysisComp = systemModel.getValidationPropertyAnalysisContextComponent(ctx);
                    ValidationAssertionPropertyParametersDialog.this.componentType.select(ValidationAssertionPropertyParametersDialog.this.componentType.indexOf(contextAnalysisComp));
                    ValidationAssertionPropertyParametersDialog.this.componentType.notifyListeners(13, new Event());
                    String[] contextAnalysisProps = systemModel.getValidationPropertyAnalysisContextSelectedProperties(ctx);
                    if (contextAnalysisProps.length != 1 || !contextAnalysisProps[0].equals("ALL")) {
                        int i = 0;
                        while (i < ValidationAssertionPropertyParametersDialog.this.propertyText.getItemCount()) {
                            TableItem currItem = ValidationAssertionPropertyParametersDialog.this.propertyText.getItem(i);
                            currItem.setChecked(false);
                            String[] stringArray = contextAnalysisProps;
                            int n = contextAnalysisProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String selProp = stringArray[n2];
                                if (currItem.getText().equals(selProp)) {
                                    currItem.setChecked(true);
                                    break;
                                }
                                ++n2;
                            }
                            ++i;
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Validation Property parameters");
    }

    protected void okPressed() {
        TableItem[] tableItems;
        this.properties = "";
        TableItem[] tableItemArray = tableItems = this.propertyText.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.properties = this.properties.concat(String.valueOf(item.getText()) + ",");
            }
            ++n2;
        }
        if (this.properties.length() > 0) {
            this.properties = this.properties.substring(0, this.properties.length() - 1);
        }
        this.expression = this.expressionText.getText();
        this.propertyType = this.validationType.getText();
        this.component = this.componentType.getText();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        GridData filledGridData = new GridData();
        filledGridData.horizontalAlignment = 4;
        filledGridData.grabExcessHorizontalSpace = true;
        Composite validationContainer = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        validationContainer.setLayout((Layout)gridLayout);
        GridData data = new GridData(768, 1040);
        data.horizontalSpan = 2;
        validationContainer.setLayoutData((Object)data);
        Label contextAnalysisLabel = new Label(validationContainer, 0);
        contextAnalysisLabel.setText("Context Analysis");
        this.chooseAnalysisCtxField = new CCombo(validationContainer, 2060);
        this.chooseAnalysisCtxField.setBackground(Display.getDefault().getSystemColor(1));
        for (Object ctx : this.contextList) {
            this.chooseAnalysisCtxField.add(this.systemModel.getAnalysisContextName(ctx));
        }
        this.chooseAnalysisCtxField.addSelectionListener(this.modAnalysisCtxListener);
        this.chooseAnalysisCtxField.setLayoutData((Object)filledGridData);
        Label labelPropertyType = new Label(validationContainer, 16384);
        labelPropertyType.setText("Property Type");
        this.validationType = new CCombo(validationContainer, 2056);
        this.validationType.setBackground(Display.getDefault().getSystemColor(1));
        this.validationType.add("consistency");
        this.validationType.add("possibility");
        this.validationType.add("entailment");
        this.validationType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ValidationAssertionPropertyParametersDialog.this.validationType.getText().equals("entailment")) {
                    ValidationAssertionPropertyParametersDialog.this.expressionText.setEnabled(true);
                    ValidationAssertionPropertyParametersDialog.this.selectedButton = OCRAExecService.ValidationType.ENTAILMENT;
                    ValidationAssertionPropertyParametersDialog.this.getButton(0).setEnabled(false);
                } else if (ValidationAssertionPropertyParametersDialog.this.validationType.getText().equals("possibility")) {
                    ValidationAssertionPropertyParametersDialog.this.expressionText.setEnabled(true);
                    ValidationAssertionPropertyParametersDialog.this.selectedButton = OCRAExecService.ValidationType.POSSIBILITY;
                    ValidationAssertionPropertyParametersDialog.this.getButton(0).setEnabled(false);
                } else {
                    ValidationAssertionPropertyParametersDialog.this.expressionText.setEnabled(false);
                    ValidationAssertionPropertyParametersDialog.this.selectedButton = OCRAExecService.ValidationType.CONSISTENCY;
                    ValidationAssertionPropertyParametersDialog.this.getButton(0).setEnabled(true);
                    ValidationAssertionPropertyParametersDialog.this.getButton(0).setToolTipText(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.validationType.setLayoutData((Object)filledGridData);
        Label labelExpression = new Label(validationContainer, 16384);
        labelExpression.setText("Expression");
        this.expressionText = new StyledText(validationContainer, 2052);
        this.expressionText.setText("");
        this.expressionText.setLayoutData((Object)filledGridData);
        this.expressionText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (ValidationAssertionPropertyParametersDialog.this.expressionText.getText().length() > 0) {
                    ValidationAssertionPropertyParametersDialog.this.getButton(0).setEnabled(true);
                } else {
                    ValidationAssertionPropertyParametersDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Label buttonComponent = new Label(validationContainer, 16384);
        buttonComponent.setText("Component");
        this.componentType = new CCombo(validationContainer, 18440);
        this.componentType.setBackground(Display.getDefault().getSystemColor(1));
        this.componentType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                logger.debug((Object)"componentType selected");
                String selectedComponentTypeName = ValidationAssertionPropertyParametersDialog.this.componentType.getText();
                if (selectedComponentTypeName.compareTo("ALL") != 0) {
                    ValidationAssertionPropertyParametersDialog.this.propertyText.setEnabled(true);
                    try {
                        ValidationAssertionPropertyParametersDialog.this.propertyText.removeAll();
                        String[] assertionsID = ValidationAssertionPropertyParametersDialog.this.ocraModelUtil.getAllAssertionsIDOfDescendenceComponentsAsStr(selectedComponentTypeName, ValidationAssertionPropertyParametersDialog.this.ocraModel, ValidationAssertionPropertyParametersDialog.this.validateSerializedElement);
                        int i = 0;
                        while (i < assertionsID.length) {
                            TableItem item = new TableItem(ValidationAssertionPropertyParametersDialog.this.propertyText, 0);
                            item.setText(assertionsID[i]);
                            ++i;
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    ValidationAssertionPropertyParametersDialog.this.propertyText.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.componentType.add("ALL");
        String[] stringArray = this.componentTypes;
        int n = this.componentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String componenetType = stringArray[n2];
            this.componentType.add(componenetType);
            ++n2;
        }
        this.componentType.setLayoutData((Object)filledGridData);
        Label labelProperties = new Label(validationContainer, 16384);
        labelProperties.setText("Properties ID");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.propertyText = new Table(validationContainer, 2848);
        this.propertyText.setLayoutData((Object)gridData);
        gridData.heightHint = 380;
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(800, 700);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public String getComponent() {
        return this.component;
    }

    public String getExpression() {
        return this.expression;
    }

    public OCRAExecService.ValidationType getSelectedButton() {
        return this.selectedButton;
    }
}

