/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Arrays;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDObjectUUIDImpl
extends AbstractCDOID
implements InternalCDOIDObject {
    private static final long serialVersionUID = 1L;
    private static final UUIDInterner INTERNER = new UUIDInterner();
    private final byte[] value;

    private CDOIDObjectUUIDImpl(byte[] value) {
        CheckUtil.checkArg((Object)value, (String)"Null not allowed");
        this.value = value;
    }

    private CDOIDObjectUUIDImpl() {
        this.value = null;
    }

    public byte[] getByteArrayValue() {
        return this.value;
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeByteArray(this.value);
    }

    public String toURIFragment() {
        return CDOIDUtil.encodeUUID(this.value);
    }

    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.UUID;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isTemporary() {
        return false;
    }

    public int hashCode() {
        return CDOIDObjectUUIDImpl.getHashCode(this.value);
    }

    protected int doCompareTo(CDOID o) throws ClassCastException {
        byte[] thatValue = ((CDOIDObjectUUIDImpl)o).value;
        int minLength = Math.min(this.value.length, thatValue.length);
        int i = 0;
        while (i < minLength) {
            byte thisByte = this.value[i];
            byte thatByte = thatValue[i];
            if (thisByte < thatByte) {
                return -1;
            }
            if (thisByte > thatByte) {
                return 1;
            }
            ++i;
        }
        if (this.value.length < thatValue.length) {
            return -1;
        }
        if (this.value.length > thatValue.length) {
            return 1;
        }
        return 0;
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDObjectUUIDImpl.create(this.value);
    }

    private static int getHashCode(byte[] value) {
        return Arrays.hashCode(value);
    }

    public static CDOIDObjectUUIDImpl create(byte[] value) {
        return INTERNER.intern(value);
    }

    public static CDOIDObjectUUIDImpl create(CDODataInput in) throws IOException {
        byte[] value = in.readByteArray();
        return CDOIDObjectUUIDImpl.create(value);
    }

    public static CDOIDObjectUUIDImpl create(String fragmentPart) {
        byte[] value = CDOIDUtil.decodeUUID(fragmentPart);
        return CDOIDObjectUUIDImpl.create(value);
    }

    /* synthetic */ CDOIDObjectUUIDImpl(byte[] byArray, CDOIDObjectUUIDImpl cDOIDObjectUUIDImpl) {
        this(byArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UUIDInterner
    extends Interner<CDOIDObjectUUIDImpl> {
        private UUIDInterner() {
        }

        public synchronized CDOIDObjectUUIDImpl intern(byte[] value) {
            int hashCode = CDOIDObjectUUIDImpl.getHashCode(value);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDObjectUUIDImpl id = (CDOIDObjectUUIDImpl)entry.get();
                if (id != null && Arrays.equals(id.value, value)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDObjectUUIDImpl id = new CDOIDObjectUUIDImpl(value, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDObjectUUIDImpl id) {
            return CDOIDObjectUUIDImpl.getHashCode(id.value);
        }
    }
}

