/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.protocol;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.security.CDOPermission;

public interface CDOProtocol
extends CDOProtocolConstants {
    public CDOCommonSession getSession();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CommitNotificationInfo {
        public static final byte IMPACT_NONE = 0;
        public static final byte IMPACT_PERMISSIONS = 1;
        public static final byte IMPACT_REALM = 2;
        private int senderID;
        private CDOCommonSession sender;
        private CDORevisionProvider revisionProvider;
        private CDOCommitInfo commitInfo;
        private Map<CDOID, CDOPermission> newPermissions;
        private Set<? extends Object> impactedRules;
        private byte securityImpact = 0;
        private boolean clearResourcePathCache;

        public CommitNotificationInfo() {
        }

        public CommitNotificationInfo(CDODataInput in) throws IOException {
            this.senderID = in.readInt();
            this.commitInfo = in.readCDOCommitInfo();
            this.clearResourcePathCache = in.readBoolean();
            this.securityImpact = in.readByte();
            int size = in.readInt();
            if (size != 0) {
                this.newPermissions = CDOIDUtil.createMap();
                int i = 0;
                while (i < size) {
                    CDOID id = in.readCDOID();
                    byte bits = in.readByte();
                    CDOPermission permission = CDOPermission.get(bits);
                    this.newPermissions.put(id, permission);
                    ++i;
                }
            }
        }

        public void write(CDODataOutput out) throws IOException {
            out.writeInt(this.senderID);
            out.writeCDOCommitInfo(this.commitInfo);
            out.writeBoolean(this.clearResourcePathCache);
            out.writeByte(this.securityImpact);
            if (this.newPermissions == null) {
                out.writeInt(0);
            } else {
                int size = this.newPermissions.size();
                out.writeInt(size);
                for (Map.Entry<CDOID, CDOPermission> entry : this.newPermissions.entrySet()) {
                    CDOID id = entry.getKey();
                    byte bits = entry.getValue().getBits();
                    out.writeCDOID(id);
                    out.writeByte(bits);
                }
            }
        }

        public int getSenderID() {
            return this.senderID;
        }

        public CDOCommonSession getSender() {
            return this.sender;
        }

        public void setSender(CDOCommonSession sender) {
            this.sender = sender;
            this.senderID = sender.getSessionID();
        }

        public CDORevisionProvider getRevisionProvider() {
            return this.revisionProvider;
        }

        public void setRevisionProvider(CDORevisionProvider revisionProvider) {
            this.revisionProvider = revisionProvider;
        }

        public CDOCommitInfo getCommitInfo() {
            return this.commitInfo;
        }

        public void setCommitInfo(CDOCommitInfo commitInfo) {
            this.commitInfo = commitInfo;
        }

        public Map<CDOID, CDOPermission> getNewPermissions() {
            return this.newPermissions;
        }

        public void setNewPermissions(Map<CDOID, CDOPermission> newPermissions) {
            this.newPermissions = newPermissions;
        }

        public Set<? extends Object> getImpactedRules() {
            return this.impactedRules;
        }

        public void setImpactedRules(Set<? extends Object> impactedRules) {
            this.impactedRules = impactedRules;
        }

        public byte getSecurityImpact() {
            return this.securityImpact;
        }

        public void setSecurityImpact(byte securityImpact) {
            this.securityImpact = securityImpact;
        }

        public boolean isClearResourcePathCache() {
            return this.clearResourcePathCache;
        }

        public void setClearResourcePathCache(boolean clearResourcePathCache) {
            this.clearResourcePathCache = clearResourcePathCache;
        }
    }
}

