/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.util;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;

public class FixNestedStateAndRegionOnOpening {
    public static final String COMPARTMENT_6003 = "6003";
    public static final String COMPARTMENT_6004 = "6004";

    public void fix(Diagram diagram) {
        String SEP_ID = "State_Shape";
        String REGION_ID = "Region_Shape";
        TreeIterator it = diagram.eAllContents();
        while (it.hasNext()) {
            Bounds regionBounds;
            Node regionNode;
            View parentNode;
            RecordingCommand fixCommand;
            TransactionalEditingDomain editingDomain;
            EObject current = (EObject)it.next();
            if (!(current instanceof Node)) continue;
            String currentType = ((View)current).getType();
            if ("State_Shape".equals(currentType)) {
                Shape stateShape = (Shape)current;
                BasicEList removeChilds = new BasicEList();
                for (Object child : stateShape.getChildren()) {
                    View childV = (View)child;
                    if (!childV.getType().equals(COMPARTMENT_6003) && !childV.getType().equals(COMPARTMENT_6004)) continue;
                    removeChilds.add((Object)childV);
                }
                for (View removeChild : removeChilds) {
                    editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
                    fixCommand = new RemoveChildCommand(editingDomain, stateShape, removeChild);
                    editingDomain.getCommandStack().execute((Command)fixCommand);
                }
                continue;
            }
            if (!"Region_Shape".equals(currentType) || (parentNode = ViewUtil.getViewContainer((EObject)(regionNode = (Node)current))).getChildren().size() != 1 || (regionBounds = (Bounds)regionNode.getLayoutConstraint()).getX() == 0 && regionBounds.getY() == 0) continue;
            Rectangle newBounds = new Rectangle(0, 0, regionBounds.getWidth(), regionBounds.getHeight());
            editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
            fixCommand = new FixLocationCommand(editingDomain, "Fix region position on opening", regionBounds, newBounds);
            editingDomain.getCommandStack().execute((Command)fixCommand);
        }
    }

    public class FixLocationCommand
    extends RecordingCommand {
        private Bounds iaViewBounds;
        private Rectangle iaViewNewBounds;

        public FixLocationCommand(TransactionalEditingDomain domain, String label, Bounds iaViewBounds, Rectangle iaViewNewBounds) {
            super(domain, label);
            this.iaViewBounds = iaViewBounds;
            this.iaViewNewBounds = iaViewNewBounds;
        }

        protected void doExecute() {
            this.iaViewBounds.setX(this.iaViewNewBounds.x());
            this.iaViewBounds.setY(this.iaViewNewBounds.y());
            this.iaViewBounds.setWidth(this.iaViewNewBounds.width());
            this.iaViewBounds.setHeight(this.iaViewNewBounds.height());
        }

        public boolean canUndo() {
            return false;
        }
    }

    public class RemoveChildCommand
    extends RecordingCommand {
        private Shape parent;
        private View child;

        public RemoveChildCommand(TransactionalEditingDomain domain, Shape parent, View child) {
            super(domain, "remove obsolete compartments from state");
            this.parent = parent;
            this.child = child;
        }

        protected void doExecute() {
            this.parent.removeChild(this.child);
        }

        public boolean canUndo() {
            return false;
        }
    }
}

