/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.newchild.Activator;
import org.eclipse.papyrus.infra.newchild.CreationMenuListener;
import org.eclipse.papyrus.infra.newchild.SetTargetAndRelationshipCommand;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.CreateRelationshipMenu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.CreationMenu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Folder;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Menu;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Separator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.semantic.service.SemanticService;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.ui.providers.DelegatingPapyrusContentProvider;
import org.eclipse.papyrus.infra.ui.providers.ISemanticContentProviderFactory;
import org.eclipse.papyrus.infra.widgets.editors.ITreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;

public class CreationMenuFactory {
    private TransactionalEditingDomain editingDomain;

    public CreationMenuFactory(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public boolean populateMenu(org.eclipse.swt.widgets.Menu menu, Folder folder, EObject selectedObject, int index, Map<?, ?> adviceCache) {
        if (selectedObject != null && folder != null && folder.isVisible() && this.filterMatches(folder, selectedObject)) {
            MenuItem topMenuItem = new MenuItem(menu, 64, index);
            topMenuItem.setText(folder.getLabel());
            if (folder.getIcon() != null && folder.getIcon().length() > 0) {
                URL url = null;
                try {
                    url = new URL(folder.getIcon());
                    ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
                    topMenuItem.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(imgDesc));
                }
                catch (MalformedURLException e) {
                    Activator.log.debug("Impossible to find icon with URL " + url);
                }
            }
            org.eclipse.swt.widgets.Menu topMenu = new org.eclipse.swt.widgets.Menu(menu);
            topMenuItem.setMenu(topMenu);
            boolean oneDisplayedMenu = false;
            for (Menu currentMenu : folder.getMenu()) {
                boolean result = false;
                if (currentMenu instanceof Separator) {
                    this.constructSeparator(topMenu);
                } else if (currentMenu instanceof Folder) {
                    result = this.populateMenu(topMenu, (Folder)currentMenu, selectedObject, topMenu.getItemCount(), adviceCache);
                } else if (currentMenu instanceof CreationMenu && ((CreationMenu)currentMenu).isVisible() && this.filterMatches(currentMenu, selectedObject)) {
                    CreationMenu currentCreationMenu = (CreationMenu)currentMenu;
                    EReference reference = null;
                    String role = currentCreationMenu.getRole();
                    if (role != null && !role.isEmpty()) {
                        EStructuralFeature feature = selectedObject.eClass().getEStructuralFeature(role);
                        if (feature instanceof EReference) {
                            reference = (EReference)feature;
                            result = this.constructMenu(selectedObject, topMenu, currentCreationMenu, reference, adviceCache);
                        }
                    } else {
                        result = currentCreationMenu.isDisplayAllRoles() ? this.constructMenu(selectedObject, topMenu, currentCreationMenu, adviceCache) : this.constructMenu(selectedObject, topMenu, currentCreationMenu, reference, adviceCache);
                    }
                }
                if (!result) continue;
                oneDisplayedMenu = true;
            }
            if (!oneDisplayedMenu) {
                topMenuItem.dispose();
            }
            return oneDisplayedMenu;
        }
        return false;
    }

    protected void constructSeparator(org.eclipse.swt.widgets.Menu topMenu) {
        new MenuItem(topMenu, 2);
    }

    protected boolean filterMatches(Menu menu, EObject selectedObject) {
        Filter filter = menu.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.matches((Object)selectedObject);
    }

    protected boolean constructMenu(EObject selectedObject, org.eclipse.swt.widgets.Menu menu, CreationMenu currentCreationMenu, Map<?, ?> adviceCache) {
        EObject target = ElementEditServiceUtils.getTargetFromContext((TransactionalEditingDomain)this.editingDomain, (EObject)selectedObject, (IEditCommandRequest)this.buildRequest(null, selectedObject, currentCreationMenu, adviceCache));
        if (target == null) {
            return false;
        }
        ArrayList<EStructuralFeature> possibleEFeatures = this.getEreferences(target, currentCreationMenu);
        if (possibleEFeatures.size() == 1) {
            Command cmd = this.buildCommand(null, target, currentCreationMenu, adviceCache);
            if (cmd.canExecute()) {
                MenuItem item = new MenuItem(menu, 0);
                this.fillIcon(currentCreationMenu, item);
                item.setEnabled(true);
                item.setText(currentCreationMenu.getLabel());
                item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
                return true;
            }
            return false;
        }
        if (possibleEFeatures.size() > 1) {
            MenuItem topMenuItem = new MenuItem(menu, 64);
            topMenuItem.setText(currentCreationMenu.getLabel());
            this.fillIcon(currentCreationMenu, topMenuItem);
            org.eclipse.swt.widgets.Menu topMenu = new org.eclipse.swt.widgets.Menu(menu);
            topMenuItem.setMenu(topMenu);
            for (EStructuralFeature eStructuralFeature : possibleEFeatures) {
                Command cmd = this.buildCommand((EReference)eStructuralFeature, target, currentCreationMenu, adviceCache);
                if (!cmd.canExecute()) continue;
                MenuItem item = new MenuItem(topMenu, 0);
                this.fillIcon(currentCreationMenu, item);
                item.setEnabled(true);
                item.setText("As " + eStructuralFeature.getName());
                item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
            }
            if (topMenu.getItemCount() == 0) {
                topMenu.dispose();
                return false;
            }
            return true;
        }
        return false;
    }

    protected void fillIcon(CreationMenu currentCreationMenu, MenuItem item) {
        if (currentCreationMenu.getIcon() != null && !"".equals(currentCreationMenu.getIcon())) {
            try {
                URL url = new URL(currentCreationMenu.getIcon());
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
                item.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(imgDesc));
            }
            catch (MalformedURLException e) {
                Activator.log.debug("Impossible to find icon" + e);
            }
        } else {
            this.createIconFromElementType(currentCreationMenu, item);
        }
    }

    protected ArrayList<EStructuralFeature> getEreferences(EObject selectedObject, CreationMenu currentCreationMenu) {
        ArrayList<EStructuralFeature> possibleEFeatures = new ArrayList<EStructuralFeature>();
        EList featureList = selectedObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : featureList) {
            IElementType menuType;
            EReference ref;
            if (!(eStructuralFeature instanceof EReference) || !(ref = (EReference)eStructuralFeature).isContainment() || (menuType = this.getElementType(currentCreationMenu.getElementTypeIdRef())) == null || !this.isSubClass(ref.getEType(), menuType.getEClass())) continue;
            possibleEFeatures.add(eStructuralFeature);
        }
        return possibleEFeatures;
    }

    protected boolean isSubClass(EClassifier aclass, EClass possibleSubClasse) {
        if (aclass.equals(possibleSubClasse)) {
            return true;
        }
        EList superTypeList = possibleSubClasse.getEAllSuperTypes();
        return superTypeList.contains((Object)aclass);
    }

    protected void createIconFromElementType(CreationMenu currentCreationMenu, MenuItem item) {
        URL iconURL = this.getElementType(currentCreationMenu.getElementTypeIdRef()).getIconURL();
        if (iconURL != null) {
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)iconURL);
            item.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(imgDesc));
        }
    }

    protected boolean constructMenu(EObject selectedObject, org.eclipse.swt.widgets.Menu topMenu, CreationMenu currentCreationMenu, EReference reference, Map<?, ?> adviceCache) {
        boolean oneDisplayedMenu = false;
        Command cmd = this.buildCommand(reference, selectedObject, currentCreationMenu, adviceCache);
        if (cmd.canExecute()) {
            oneDisplayedMenu = true;
            MenuItem item = new MenuItem(topMenu, 0);
            this.fillIcon(currentCreationMenu, item);
            item.setEnabled(true);
            item.setText(currentCreationMenu.getLabel());
            item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
        }
        return oneDisplayedMenu;
    }

    protected IElementType getElementType(String elementType) {
        return ElementTypeRegistry.getInstance().getType(elementType);
    }

    protected Command buildCommand(EReference reference, EObject container, CreationMenu creationMenu, Map<?, ?> adviceCache) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)container);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Object createGMFCommand = null;
        if (creationMenu instanceof CreateRelationshipMenu) {
            IElementEditService serviceProvider;
            TreeSelectorDialog dialog;
            IElementType elementType = this.getElementType(creationMenu.getElementTypeIdRef());
            if (elementType != null && (dialog = this.getTargetTreeSelectorDialog(container, serviceProvider = ElementEditServiceUtils.getCommandProvider((Object)elementType), this.editingDomain, reference, container, elementType)) != null) {
                createGMFCommand = new SetTargetAndRelationshipCommand(this.editingDomain, "Create " + elementType.getDisplayName(), serviceProvider, reference, container, elementType, (ITreeSelectorDialog)dialog);
            }
        } else {
            createGMFCommand = provider.getEditCommand((IEditCommandRequest)this.buildRequest(reference, container, creationMenu, adviceCache));
        }
        if (createGMFCommand != null) {
            Command emfCommand = GMFtoEMFCommandWrapper.wrap((ICommand)createGMFCommand);
            return emfCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected CreateElementRequest buildRequest(EReference reference, EObject container, CreationMenu creationMenu, Map<?, ?> adviceCache) {
        String elementTypeId = creationMenu.getElementTypeIdRef();
        Object request = null;
        request = reference == null ? (creationMenu instanceof CreateRelationshipMenu ? new CreateRelationshipRequest(this.editingDomain, null, container, null, this.getElementType(elementTypeId)) : new CreateElementRequest(this.editingDomain, container, this.getElementType(elementTypeId))) : (creationMenu instanceof CreateRelationshipMenu ? new CreateRelationshipRequest(this.editingDomain, null, container, null, this.getElementType(elementTypeId), reference) : new CreateElementRequest(this.editingDomain, container, this.getElementType(elementTypeId), reference));
        request.setParameter("Cache_Maps", adviceCache);
        return request;
    }

    protected CreateElementRequest buildRequest(EReference reference, EObject container, CreationMenu creationMenu) {
        String typeId = creationMenu.getElementTypeIdRef();
        if (reference == null) {
            if (creationMenu instanceof CreateRelationshipMenu) {
                CreateRelationshipRequest createRelationshipRequest = new CreateRelationshipRequest(this.editingDomain, null, container, null, this.getElementType(typeId));
                return createRelationshipRequest;
            }
            return new CreateElementRequest(this.editingDomain, container, this.getElementType(typeId));
        }
        if (creationMenu instanceof CreateRelationshipMenu) {
            CreateRelationshipRequest createRelationshipRequest = new CreateRelationshipRequest(this.editingDomain, null, container, null, this.getElementType(typeId), reference);
            return createRelationshipRequest;
        }
        return new CreateElementRequest(this.editingDomain, container, this.getElementType(typeId), reference);
    }

    protected TreeSelectorDialog getTargetTreeSelectorDialog(EObject eobject, final IElementEditService provider, final TransactionalEditingDomain ted, final EReference reference, final EObject container, final IElementType et) {
        ILabelProvider labelProvider = null;
        try {
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)eobject)).getLabelProvider();
        }
        catch (Exception ex) {
            Activator.log.error("Impossible to get a label provider from object " + eobject, (Throwable)ex);
            return null;
        }
        SemanticService semanticService = null;
        try {
            semanticService = (SemanticService)ServiceUtilsForEObject.getInstance().getService(SemanticService.class, (Object)eobject);
        }
        catch (Exception e) {
            Activator.log.error("Could not get the SemanticService for " + eobject, (Throwable)e);
            return null;
        }
        IModel[] models = semanticService.getSemanticIModels();
        Optional<ISemanticContentProviderFactory> factory = Stream.of(models).map(m -> (ISemanticContentProviderFactory)m.getAdapter(ISemanticContentProviderFactory.class)).filter(Objects::nonNull).reduce(ISemanticContentProviderFactory::compose);
        ITreeContentProvider delegate = factory.orElse(SemanticEMFContentProvider::new).createSemanticContentProvider(eobject.eResource().getResourceSet());
        DelegatingPapyrusContentProvider contentProvider = new DelegatingPapyrusContentProvider(delegate){

            public boolean isValidValue(Object element) {
                if (element == null) {
                    return false;
                }
                EObject eobject = EMFHelper.getEObject((Object)element);
                CreateRelationshipRequest buildRequest = null;
                buildRequest = reference == null ? new CreateRelationshipRequest(ted, null, container, eobject, et) : new CreateRelationshipRequest(ted, null, container, eobject, et);
                ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)buildRequest);
                if (createGMFCommand == null) {
                    return false;
                }
                boolean canExecute = createGMFCommand.canExecute();
                return canExecute;
            }
        };
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        dialog.setContentProvider((ITreeContentProvider)contentProvider);
        dialog.setLabelProvider(labelProvider);
        dialog.setMessage("Choose the target element");
        dialog.setTitle("Target Element Selection");
        dialog.setInput((Object)EcoreUtil.getRootContainer((EObject)eobject));
        return dialog;
    }
}

