/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.widgets.providers.AbstractRestrictedContentProvider;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLFeatureAxisManager;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLFeatureRestrictedContentProvider
extends AbstractRestrictedContentProvider {
    private final UMLFeatureAxisManager axisManager;

    public UMLFeatureRestrictedContentProvider(UMLFeatureAxisManager axisManager) {
        this(axisManager, false);
    }

    public UMLFeatureRestrictedContentProvider(UMLFeatureAxisManager axisManager, boolean isRestricted) {
        super(isRestricted);
        this.axisManager = axisManager;
        this.setIgnoreInheritedElements(false);
    }

    public Object[] getElements(Object inputElement) {
        boolean columnManager;
        List elements;
        if (this.isRestricted() && (elements = (columnManager = this.axisManager.isUsedAsColumnManager()) ? this.axisManager.getTableManager().getRowElementsList() : this.axisManager.getTableManager().getColumnElementsList()).isEmpty()) {
            return new Object[0];
        }
        return new Object[]{UMLPackage.eINSTANCE};
    }

    protected AbstractAxisProvider getManagedAxisProvider() {
        return this.axisManager.getRepresentedContentProvider();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<EClassifier> asList = new ArrayList<EClassifier>();
        if (parentElement instanceof EClass) {
            EClass eClass = (EClass)parentElement;
            if (this.isIgnoringInheritedElements()) {
                asList.addAll((Collection<EClassifier>)eClass.getEStructuralFeatures());
            } else {
                asList.addAll((Collection<EClassifier>)eClass.getEAllStructuralFeatures());
            }
            asList.remove(EcorePackage.eINSTANCE.getEModelElement_EAnnotations());
            return asList.toArray();
        }
        if (parentElement instanceof EPackage) {
            EPackage ePackage = (EPackage)parentElement;
            Object eClassifiers = null;
            if (this.isRestricted()) {
                boolean isColumnManager;
                eClassifiers = new HashSet();
                AbstractAxisProvider axisProvider = this.axisManager.getTableManager().getHorizontalAxisProvider();
                if (axisProvider == this.axisManager.getRepresentedContentProvider()) {
                    axisProvider = this.axisManager.getTableManager().getVerticalAxisProvider();
                }
                List elementsList = (isColumnManager = this.axisManager.isUsedAsColumnManager()) ? this.axisManager.getTableManager().getRowElementsList() : this.axisManager.getTableManager().getColumnElementsList();
                for (Object object : elementsList) {
                    Object representedElement = AxisUtils.getRepresentedElement(object);
                    if (!(representedElement instanceof Element)) continue;
                    EClass eClass = ((EObject)representedElement).eClass();
                    eClassifiers.add(eClass);
                    eClassifiers.addAll(eClass.getEAllSuperTypes());
                }
            } else {
                eClassifiers = ePackage.getEClassifiers();
            }
            eClassifiers.remove(EcorePackage.eINSTANCE.getEModelElement());
            Iterator iterator = eClassifiers.iterator();
            while (iterator.hasNext()) {
                EClassifier eClassifier = (EClassifier)iterator.next();
                if (!(eClassifier instanceof EClass) || eClassifier == EcorePackage.eINSTANCE.getEModelElement()) continue;
                asList.add(eClassifier);
            }
            return asList.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            return feature.getEContainingClass();
        }
        if (element instanceof EClass) {
            EClass eClass = (EClass)element;
            return eClass.getEPackage();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof EClass) {
            EClass eClass = (EClass)element;
            boolean hasChildren = !eClass.getEStructuralFeatures().isEmpty();
            return hasChildren;
        }
        if (element instanceof EPackage) {
            EPackage ePackage = (EPackage)element;
            EList eClassifiers = ePackage.getEClassifiers();
            for (EClassifier eClassifier : eClassifiers) {
                if (!(eClassifier instanceof EClass)) continue;
                return true;
            }
            return false;
        }
        if (element instanceof EStructuralFeature) {
            return false;
        }
        return false;
    }

    public Object[] getElements() {
        return this.getElements(null);
    }

    public boolean isValidValue(Object element) {
        return element instanceof EStructuralFeature && UMLPackage.eINSTANCE.eContents().contains((Object)((EObject)element).eContainer());
    }
}

