/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.contractEditor;

import eu.fbk.eclipse.standardtools.contractEditor.view.ContractEditorView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.diagram.composite.part.Messages;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class CustomContractEditorView
extends ContractEditorView {
    private ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private EntityUtil entityUtil = EntityUtil.getInstance();

    public String[] getContractOwnerInputPortsNames(Object contract) {
        return null;
    }

    public String[] getContractOwnerOutputPortsNames(Object contract) {
        return null;
    }

    public String[] getContractOwnerInputOutputPortsNames(Object contract) {
        return null;
    }

    public Object returnComponent(ISelection selection) {
        Object selectedUmlElement = this.selectionUtil.getUmlSelectedObject((Object)selection);
        if (selectedUmlElement instanceof Property) {
            Element classType;
            if (this.entityUtil.isComponentInstance((Element)((Property)selectedUmlElement)) && !this.contractEntityUtil.isContract(classType = this.entityUtil.getUmlType((Property)selectedUmlElement))) {
                return classType;
            }
        } else if (selectedUmlElement instanceof Class && !this.contractEntityUtil.isContract((Element)((Class)selectedUmlElement))) {
            return selectedUmlElement;
        }
        return null;
    }

    public Object returnContract(ISelection selection) {
        Object selectedUmlElement = this.selectionUtil.getUmlSelectedObject((Object)selection);
        if (selectedUmlElement instanceof Property) {
            Element classType;
            if (this.contractEntityUtil.isContractProperty((Element)((Property)selectedUmlElement))) {
                return this.entityUtil.getUmlType((Property)selectedUmlElement);
            }
            if (this.entityUtil.isComponentInstance((Element)((Property)selectedUmlElement)) && this.contractEntityUtil.isContract(classType = this.entityUtil.getUmlType((Property)selectedUmlElement))) {
                return classType;
            }
        } else if (selectedUmlElement instanceof Class && this.contractEntityUtil.isContract((Element)((Class)selectedUmlElement))) {
            return selectedUmlElement;
        }
        return null;
    }

    public String[] getContractListStr(Object component) {
        BasicEList contractNames = new BasicEList();
        for (Property prop : ((Class)component).getAttributes()) {
            if (!this.contractEntityUtil.isContractProperty((Element)prop)) continue;
            if (prop.getType() == null) {
                contractNames.add((Object)(String.valueOf(prop.getName()) + " : <TYPE NOT DEFINED>"));
                continue;
            }
            contractNames.add((Object)(String.valueOf(prop.getName()) + " : " + prop.getType().getName()));
        }
        Object[] contractNamesArr = new String[contractNames.size()];
        return (String[])contractNames.toArray(contractNamesArr);
    }

    public Object extractContractFromComponent(Object component, String contractName) {
        return this.contractEntityUtil.getUmlContract((Class)component, contractName);
    }

    public String getComponentName(Object component) {
        return ((Class)component).getQualifiedName();
    }

    public void createAssumption(final Object contract) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)contract);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                CustomContractEditorView.this.contractEntityUtil.createAssumptionToUmlContract((Class)contract);
            }
        });
    }

    public String browseAssumptionButtonPressed(final Object contract) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)contract);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                Constraint assumeConstraint = CustomContractEditorView.this.selectProperty(contract);
                if (assumeConstraint != null) {
                    CustomContractEditorView.this.contractEntityUtil.assignUmlConstraintAssumptionToUmlContract(assumeConstraint, (Class)contract);
                }
            }
        });
        return this.contractEntityUtil.getAssumeStrFromUmlContract((Class)contract);
    }

    public void createGuarantee(final Object contract) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)contract);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                CustomContractEditorView.this.contractEntityUtil.createGuaranteeToUmlContract((Class)contract);
            }
        });
    }

    public String browseGuaranteeButtonPressed(final Object contract) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)contract);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                Constraint guaranteeConstraint = CustomContractEditorView.this.selectProperty(contract);
                if (guaranteeConstraint != null) {
                    CustomContractEditorView.this.contractEntityUtil.assignUmlConstraintGuaranteeToUmlContract(guaranteeConstraint, (Class)contract);
                }
            }
        });
        return this.contractEntityUtil.getGuaranteeStrFromUmlContract((Class)contract);
    }

    public void guaranteeEditorchanged(final Object contract, final String textChanged) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)contract);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                CustomContractEditorView.this.contractEntityUtil.setTextToGuaranteeOrCreateGuarantee(textChanged, (Class)contract);
            }
        });
    }

    public void assumptionEditorchanged(final Object contract, final String textChanged) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)contract);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                CustomContractEditorView.this.contractEntityUtil.setTextToAssumeOrCreateAssume(textChanged, (Class)contract);
            }
        });
    }

    private Constraint selectProperty(Object contract) {
        Object[] result;
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        UMLContentProvider provider = new UMLContentProvider((EObject)this.entityUtil.getToPackage((Element)((Class)contract)), (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement());
        dialog.setContentProvider((ITreeContentProvider)provider);
        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
        dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof Constraint) {
            return (Constraint)result[0];
        }
        return null;
    }

    public String getContractName(Object contract) {
        if (contract != null) {
            return ((Class)contract).getQualifiedName();
        }
        return null;
    }

    public String getAssumeStrFromContract(Object contract) {
        return this.contractEntityUtil.getAssumeStrFromUmlContract((Class)contract);
    }

    public String getGuaranteeStrFromContract(Object contract) {
        return this.contractEntityUtil.getGuaranteeStrFromUmlContract((Class)contract);
    }

    public String[] getEnumValuesFromContractOwnerPorts(Object contract) {
        return null;
    }

    public EList<?> getContractOwnerPorts(Object contract) {
        return null;
    }

    public EList<?> getContractOwnerAttributes(Object contract) {
        return null;
    }

    public boolean isNumberAttribute(Object attribute) {
        return false;
    }

    public boolean isIntAttribute(Object attribute) {
        return false;
    }

    public boolean isEventAttribute(Object attribute) {
        return false;
    }

    public boolean isEnumAttribute(Object attribute) {
        return false;
    }

    public boolean isBoolAttribute(Object attribute) {
        return false;
    }

    public boolean isContinuousAttribute(Object attribute) {
        return false;
    }

    public boolean isWordAttribute(Object attribute) {
        return false;
    }

    public boolean isRealAttribute(Object attribute) {
        return false;
    }

    public boolean isInOutPort(Object port) {
        return false;
    }

    public boolean isOutputPort(Object port) {
        return false;
    }

    public boolean isInputPort(Object port) {
        return false;
    }

    public String getPortName(Object port) {
        return null;
    }

    public String[] getContractOwnerDefinesNames(Object contract) {
        return null;
    }
}

