/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.palette.DynamicConfigureRequest;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.ModelPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.SetDynamicValueCommand;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.providers.SemanticUMLContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SemanticPostAction
extends ModelPostAction {
    protected Map<String, Object> propertiesToUpdate = new HashMap<String, Object>();
    protected List<String> runtimeDefinedProperties = new ArrayList<String>();
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;
    protected TableViewer featureViewer;
    protected EClass metaclass = null;
    protected static final String ICON_CHECKED = "/icons/complete_tsk.gif";
    protected static final String ICON_UNCHECKED = "/icons/incomplete_tsk.gif";
    protected static final String SEPARATOR = ",,";

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            return;
        }
        NodeList childNodes = configurationNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node nameNode;
            Node featureNode = childNodes.item(i);
            if ("feature".equals(featureNode.getNodeName())) {
                nameNode = featureNode.getAttributes().getNamedItem("name");
                Node valueNode = featureNode.getAttributes().getNamedItem("value");
                Node separatorNode = featureNode.getAttributes().getNamedItem("separator");
                if (nameNode != null && valueNode != null && separatorNode != null) {
                    this.propertiesToUpdate.put(nameNode.getNodeValue(), this.parseValue(valueNode.getNodeValue(), separatorNode.getNodeValue()));
                } else {
                    Activator.log.error("Impossible to parse the configuration node for semantic post action", null);
                }
            } else if ("runtimeFeature".equals(featureNode.getNodeName())) {
                nameNode = featureNode.getAttributes().getNamedItem("name");
                if (nameNode != null) {
                    this.runtimeDefinedProperties.add(nameNode.getNodeValue());
                } else {
                    Activator.log.error("Impossible to parse the configuration node for semantic post action", null);
                }
            }
            ++i;
        }
    }

    protected Object parseValue(String nodeValue, String separator) {
        if (nodeValue.indexOf(separator) > 0) {
            ArrayList<Object> values = new ArrayList<Object>();
            StringTokenizer tokenizer = new StringTokenizer(nodeValue, separator);
            while (tokenizer.hasMoreElements()) {
                Object value = tokenizer.nextElement();
                values.add(value);
            }
            return values;
        }
        return nodeValue;
    }

    @Override
    public ICommand getPostCommand(final IAdaptable viewAdapter) {
        TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        return new AbstractTransactionalCommand(editingDomain, "Modify Semantic", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null) {
                    EObject objectToEdit = view.getElement();
                    for (String featureName : SemanticPostAction.this.propertiesToUpdate.keySet()) {
                        EStructuralFeature feature = objectToEdit.eClass().getEStructuralFeature(featureName);
                        if (feature == null) {
                            Activator.log.error("Impossible to find the feature " + featureName + " for element " + objectToEdit, null);
                            continue;
                        }
                        if (feature instanceof EReference) {
                            URI uri = (URI)SemanticPostAction.this.getValue(feature, SemanticPostAction.this.propertiesToUpdate.get(featureName));
                            try {
                                EObject value = objectToEdit.eResource().getResourceSet().getEObject(uri, true);
                                if (value == null) {
                                    return CommandResult.newErrorCommandResult((String)("Cannot find the object at " + uri));
                                }
                                objectToEdit.eSet(feature, (Object)value);
                                continue;
                            }
                            catch (Exception ex) {
                                Activator.log.error(String.format("Cannot set the initial value for '%s'", feature.getName()), (Throwable)ex);
                                return CommandResult.newErrorCommandResult((Throwable)ex);
                            }
                        }
                        objectToEdit.eSet(feature, SemanticPostAction.this.getValue(feature, SemanticPostAction.this.propertiesToUpdate.get(featureName)));
                    }
                    if (SemanticPostAction.this.runtimeDefinedProperties.size() > 0) {
                        DynamicConfigureRequest request = new DynamicConfigureRequest(objectToEdit, SemanticPostAction.this.runtimeDefinedProperties);
                        new SetDynamicValueCommand(request).doExecuteWithResult(null, null);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public Map<String, Object> getPropertiesToUpdate() {
        return this.propertiesToUpdate;
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        if (entryProxy.getEntry() instanceof CombinedTemplateCreationEntry) {
            this.metaclass = PaletteUtil.getToolMetaclass((ToolEntry)((CombinedTemplateCreationEntry)entryProxy.getEntry()));
        }
        Composite mainComposite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(3, false);
        mainComposite.setLayout((Layout)layout);
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText("Values to set for the semantic element");
        GridData data = new GridData(4, 0x1000000, true, false, 1, 1);
        titleLabel.setLayoutData((Object)data);
        this.featureViewer = new TableViewer(mainComposite, 67584);
        this.createColumns(this.featureViewer);
        this.featureViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.featureViewer.setLabelProvider((IBaseLabelProvider)new FeatureLabelProvider());
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        this.featureViewer.getControl().setLayoutData((Object)data);
        this.updateFeaturesViewer();
        return mainComposite;
    }

    protected void createColumns(TableViewer viewer) {
        TableViewerColumn nameColumn = new TableViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Feature Name");
        nameColumn.getColumn().setWidth(130);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setMoveable(false);
        TableViewerColumn runtimeColumn = new TableViewerColumn(viewer, 0);
        runtimeColumn.getColumn().setText("Runtime");
        runtimeColumn.getColumn().setWidth(70);
        runtimeColumn.getColumn().setResizable(true);
        runtimeColumn.getColumn().setMoveable(false);
        runtimeColumn.setEditingSupport((EditingSupport)new DynamicFeatureEditingSupport((ColumnViewer)viewer));
        TableViewerColumn valueColumn = new TableViewerColumn(viewer, 0);
        valueColumn.getColumn().setText("Values");
        valueColumn.getColumn().setWidth(300);
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setMoveable(false);
        valueColumn.setEditingSupport((EditingSupport)new FeatureEditingSupport((ColumnViewer)viewer));
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected void updateFeaturesViewer() {
        this.featureViewer.setInput((Object)this.metaclass);
    }

    @Override
    public void save(Node parentNode) {
        Element childElement;
        if (!(parentNode instanceof Element)) {
            Activator.log.error("parent node is not an Element", null);
            return;
        }
        for (String featureName : this.propertiesToUpdate.keySet()) {
            childElement = ((Element)parentNode).getOwnerDocument().createElement("feature");
            childElement.setAttribute("name", featureName);
            childElement.setAttribute("value", this.serializeValue(this.propertiesToUpdate.get(featureName), SEPARATOR));
            childElement.setAttribute("separator", SEPARATOR);
            parentNode.appendChild(childElement);
        }
        for (String featureName : this.runtimeDefinedProperties) {
            childElement = ((Element)parentNode).getOwnerDocument().createElement("runtimeFeature");
            childElement.setAttribute("name", featureName);
            parentNode.appendChild(childElement);
        }
    }

    protected String serializeValue(Object object, String separator) {
        if (object instanceof Collection) {
            return PaletteUtil.convertToFlatRepresentation((Collection)object, separator);
        }
        return object.toString();
    }

    protected boolean isRuntimeDefined(EStructuralFeature feature) {
        return this.runtimeDefinedProperties.contains(feature.getName());
    }

    protected ResourceSet getResourceSet() {
        try {
            return (ResourceSet)this.getServicesRegistry().getService(ModelSet.class);
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    protected class DynamicFeatureEditingSupport
    extends EditingSupport {
        private CellEditor editor;

        public DynamicFeatureEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor(null, 0);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            EStructuralFeature feature = (EStructuralFeature)element;
            return SemanticPostAction.this.runtimeDefinedProperties.contains(feature.getName());
        }

        protected void setValue(Object element, Object value) {
            String featureName = ((EStructuralFeature)element).getName();
            if (!SemanticPostAction.this.runtimeDefinedProperties.contains(featureName)) {
                SemanticPostAction.this.runtimeDefinedProperties.add(featureName);
            } else {
                SemanticPostAction.this.runtimeDefinedProperties.remove(featureName);
            }
            this.getViewer().update(element, null);
        }
    }

    protected class FeatureContentProvider
    implements IStructuredContentProvider {
        protected EClass currentEClass;

        protected FeatureContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EClass) {
                this.currentEClass = (EClass)inputElement;
                ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
                for (EStructuralFeature feature : this.currentEClass.getEAllStructuralFeatures()) {
                    EReference reference;
                    if (feature instanceof EReference && ((reference = (EReference)feature).isContainer() || reference.isContainment() || reference.isMany()) || feature.isDerived() || !feature.isChangeable()) continue;
                    features.add(feature);
                }
                return features.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class FeatureEditingSupport
    extends EditingSupport {
        protected final String[] booleanProposals;

        public FeatureEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.booleanProposals = new String[]{"", "true", "false"};
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            EStructuralFeature feature = (EStructuralFeature)element;
            if (feature instanceof EReference) {
                return this.createReferenceEditor((EReference)feature);
            }
            EClassifier eType = feature.getEType();
            if (eType instanceof EEnum) {
                return this.createEnumerationEditor(feature);
            }
            String instanceTypeName = eType.getInstanceClassName();
            if (instanceTypeName.equals(String.class.getCanonicalName())) {
                return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
            }
            if (instanceTypeName.equals(Integer.class.getCanonicalName())) {
                return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
            }
            if (instanceTypeName.equals("boolean")) {
                return this.createBooleanEditor(feature);
            }
            return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
        }

        protected CellEditor createBooleanEditor(EStructuralFeature feature) {
            return new ComboBoxCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), this.booleanProposals, 8);
        }

        protected CellEditor createReferenceEditor(EReference reference) {
            return new ReferenceDialogCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), reference, 0);
        }

        protected CellEditor createEnumerationEditor(EStructuralFeature feature) {
            EEnum eType = (EEnum)feature.getEType();
            EList literals = eType.getELiterals();
            String[] proposals = new String[literals.size() + 1];
            proposals[0] = "";
            int i = 0;
            while (i < literals.size()) {
                proposals[i + 1] = ((EEnumLiteral)literals.get(i)).getLiteral();
                ++i;
            }
            return new ComboBoxCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), proposals, 8);
        }

        protected Object getValue(Object element) {
            EStructuralFeature feature = (EStructuralFeature)element;
            if (feature instanceof EReference) {
                return this.getReferenceValue((EReference)feature);
            }
            EClassifier eType = feature.getEType();
            if (eType instanceof EEnum) {
                return this.getEnumerationValue(feature);
            }
            String instanceTypeName = eType.getInstanceClassName();
            if (instanceTypeName.equals("boolean")) {
                return this.getBooleanValue(feature);
            }
            return SemanticPostAction.this.propertiesToUpdate.get(feature.getName()) != null ? SemanticPostAction.this.propertiesToUpdate.get(feature.getName()) : "";
        }

        protected Object getEnumerationValue(EStructuralFeature feature) {
            EEnum eType = (EEnum)feature.getEType();
            EList literals = eType.getELiterals();
            ArrayList<String> proposals = new ArrayList<String>();
            proposals.add("");
            int i = 0;
            while (i < literals.size()) {
                proposals.add(i + 1, ((EEnumLiteral)literals.get(i)).getLiteral());
                ++i;
            }
            Object value = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
            if (value == null) {
                return 0;
            }
            return proposals.indexOf(value);
        }

        protected Object getBooleanValue(EStructuralFeature feature) {
            List<String> booleans = Arrays.asList(this.booleanProposals);
            Object value = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
            if (value == null || value.equals("")) {
                return 0;
            }
            return booleans.indexOf(value);
        }

        public Object getReferenceValue(EReference feature) {
            Object uriAsString = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
            if (uriAsString == null || "".equals(uriAsString)) {
                return null;
            }
            URI uri = URI.createURI((String)((String)uriAsString));
            return uri;
        }

        protected void setValue(Object element, Object value) {
            EStructuralFeature feature = (EStructuralFeature)element;
            String featureName = ((EStructuralFeature)element).getName();
            if (feature instanceof EReference) {
                this.setReferenceValue(element, value);
            } else {
                EClassifier eType = feature.getEType();
                if (eType instanceof EEnum) {
                    this.setEnumerationValue(element, value);
                } else {
                    String instanceTypeName = eType.getInstanceClassName();
                    if (instanceTypeName.equals("boolean")) {
                        this.setBooleanValue(element, value);
                    } else if (value == null || value.equals("")) {
                        SemanticPostAction.this.propertiesToUpdate.remove(featureName);
                    } else {
                        SemanticPostAction.this.propertiesToUpdate.put(featureName, value);
                    }
                }
            }
            this.getViewer().update(element, null);
        }

        protected void setEnumerationValue(Object element, Object value) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EEnum eType = (EEnum)feature.getEType();
            EList literals = eType.getELiterals();
            ArrayList<String> proposals = new ArrayList<String>();
            proposals.add("");
            int i = 0;
            while (i < literals.size()) {
                proposals.add(i + 1, ((EEnumLiteral)literals.get(i)).getLiteral());
                ++i;
            }
            String featureName = feature.getName();
            if (value == null || value.equals(0)) {
                SemanticPostAction.this.propertiesToUpdate.remove(featureName);
            } else {
                int index = (Integer)value;
                SemanticPostAction.this.propertiesToUpdate.put(featureName, proposals.get(index));
            }
        }

        protected void setReferenceValue(Object element, Object value) {
            EStructuralFeature feature = (EStructuralFeature)element;
            String featureName = feature.getName();
            if (value instanceof EObject) {
                SemanticPostAction.this.propertiesToUpdate.put(featureName, EcoreUtil.getURI((EObject)((EObject)value)).toString());
            } else {
                SemanticPostAction.this.propertiesToUpdate.remove(feature.getName());
            }
        }

        protected void setBooleanValue(Object element, Object value) {
            EStructuralFeature feature = (EStructuralFeature)element;
            String featureName = feature.getName();
            if (value == null || value.equals(0)) {
                SemanticPostAction.this.propertiesToUpdate.remove(featureName);
            } else if (value.equals(1)) {
                SemanticPostAction.this.propertiesToUpdate.put(featureName, this.booleanProposals[1]);
            } else if (value.equals(2)) {
                SemanticPostAction.this.propertiesToUpdate.put(featureName, this.booleanProposals[2]);
            } else {
                Activator.log.error("impossible to set boolean value " + value, null);
            }
        }
    }

    protected class FeatureLabelProvider
    implements ITableLabelProvider {
        protected FeatureLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            EStructuralFeature feature = (EStructuralFeature)element;
            if (columnIndex == 1) {
                if (SemanticPostAction.this.isRuntimeDefined(feature)) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", SemanticPostAction.ICON_CHECKED);
                }
                return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", SemanticPostAction.ICON_UNCHECKED);
            }
            if (columnIndex == 2 && feature instanceof EReference) {
                Object value = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
                if (value == null) {
                    return null;
                }
                ResourceSet resourceSet = SemanticPostAction.this.getResourceSet();
                EObject eObject = resourceSet.getEObject(URI.createURI((String)value.toString()), true);
                if (eObject.eIsProxy()) {
                    eObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet);
                }
                try {
                    return ((LabelProviderService)SemanticPostAction.this.getServicesRegistry().getService(LabelProviderService.class)).getLabelProvider().getImage((Object)eObject);
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            EStructuralFeature feature = (EStructuralFeature)element;
            switch (columnIndex) {
                case 0: {
                    text = feature.getName();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    Object value = SemanticPostAction.this.propertiesToUpdate.get(feature.getName());
                    if (feature instanceof EReference && value != null) {
                        ResourceSet resourceSet = SemanticPostAction.this.getResourceSet();
                        EObject eObject = resourceSet.getEObject(URI.createURI((String)value.toString()), false);
                        if (eObject.eIsProxy()) {
                            eObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet);
                        }
                        try {
                            text = ((LabelProviderService)SemanticPostAction.this.getServicesRegistry().getService(LabelProviderService.class)).getLabelProvider().getText((Object)eObject);
                            return text;
                        }
                        catch (Exception ex) {
                            Activator.log.error((Throwable)ex);
                            return null;
                        }
                    }
                    text = value != null ? value.toString() : "";
                }
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ReferenceDialogCellEditor
    extends DialogCellEditor {
        protected EReference reference;

        public ReferenceDialogCellEditor(Composite parent, EReference reference, int style) {
            super(parent, style);
            this.reference = reference;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            block5: {
                Object[] result;
                block6: {
                    TreeSelectorDialog dialog = new TreeSelectorDialog(cellEditorWindow.getShell());
                    ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)SemanticPostAction.this.getServicesRegistry());
                    UmlModel umlModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                    EObject root = umlModel.lookupRoot();
                    SemanticUMLContentProvider provider = new SemanticUMLContentProvider(new EObject[]{root});
                    provider.setWantedMetaclasses(Collections.singletonList(this.reference.getEType()));
                    EMFGraphicalContentProvider wrappedProvider = ProviderHelper.encapsulateProvider((ITreeContentProvider)provider, (ResourceSet)modelSet, (String)"org.eclipse.papyrus.uml.diagram.common.customization.palette");
                    dialog.setContentProvider((ITreeContentProvider)wrappedProvider);
                    dialog.setLabelProvider(((LabelProviderService)SemanticPostAction.this.getServicesRegistry().getService(LabelProviderService.class)).getLabelProvider());
                    if (dialog.open() != 0) break block5;
                    result = dialog.getResult();
                    if (result.length != 0) break block6;
                    return null;
                }
                try {
                    if (result[0] instanceof EObject) {
                        return result[0];
                    }
                }
                catch (NotFoundException ex) {
                    Activator.log.error((Throwable)ex);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
            return null;
        }
    }
}

