/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.migration;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.properties.ContainerDescription;
import org.eclipse.sirius.properties.ControlDescription;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.HyperlinkDescription;
import org.eclipse.sirius.properties.HyperlinkWidgetConditionalStyle;
import org.eclipse.sirius.properties.HyperlinkWidgetStyle;
import org.eclipse.sirius.properties.LabelDescription;
import org.eclipse.sirius.properties.LabelWidgetConditionalStyle;
import org.eclipse.sirius.properties.LabelWidgetStyle;
import org.eclipse.sirius.properties.ListDescription;
import org.eclipse.sirius.properties.ListWidgetConditionalStyle;
import org.eclipse.sirius.properties.ListWidgetStyle;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesFactory;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Extension;
import org.eclipse.sirius.viewpoint.description.Group;
import org.osgi.framework.Version;

public class ReferenceWidgetMigrationParticipant
extends AbstractVSMMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("11.0.0.201609021200");
    private static final String REFERENCE_DESCRIPTION_TYPE = "ReferenceDescription";
    private static final String REFERENCE_DESCRIPTION_MULTIPLE = "multiple";
    private final EClass placeholderReferenceDescriptionEClass;

    public ReferenceWidgetMigrationParticipant() {
        EPackage placeholderEPackage = EcoreFactory.eINSTANCE.createEPackage();
        EFactory placeholderEFactory = EcoreFactory.eINSTANCE.createEFactory();
        this.placeholderReferenceDescriptionEClass = EcoreFactory.eINSTANCE.createEClass();
        this.placeholderReferenceDescriptionEClass.setName(REFERENCE_DESCRIPTION_TYPE);
        this.placeholderReferenceDescriptionEClass.getESuperTypes().add((Object)PropertiesPackage.Literals.LIST_DESCRIPTION);
        EAttribute multipleEAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        multipleEAttribute.setName(REFERENCE_DESCRIPTION_MULTIPLE);
        multipleEAttribute.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        this.placeholderReferenceDescriptionEClass.getEStructuralFeatures().add((Object)multipleEAttribute);
        placeholderEPackage.getEClassifiers().add((Object)this.placeholderReferenceDescriptionEClass);
        placeholderEPackage.setEFactoryInstance(placeholderEFactory);
    }

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    public EClassifier getType(EPackage ePackage, String name, String loadedVersion) {
        EClass eClassifier = null;
        if (REFERENCE_DESCRIPTION_TYPE.equals(name)) {
            eClassifier = this.placeholderReferenceDescriptionEClass;
        }
        if (eClassifier == null) {
            eClassifier = super.getType(ePackage, name, loadedVersion);
        }
        return eClassifier;
    }

    protected void postLoad(Group group, Version loadedVersion) {
        super.postLoad(group, loadedVersion);
        EList extensions = group.getExtensions();
        for (Extension extension : extensions) {
            if (!(extension instanceof ViewExtensionDescription)) continue;
            ViewExtensionDescription viewExtensionDescription = (ViewExtensionDescription)extension;
            LinkedHashSet groups = new LinkedHashSet();
            for (PageDescription pageDescription : viewExtensionDescription.getPages()) {
                groups.addAll(pageDescription.getGroups());
            }
            groups.addAll(viewExtensionDescription.getGroups());
            for (GroupDescription groupDescription : groups) {
                EList controls = groupDescription.getControls();
                for (ControlDescription controlDescription : controls) {
                    this.handleControl(controlDescription);
                }
            }
        }
    }

    private void handleControl(ControlDescription controlDescription) {
        if (controlDescription instanceof ContainerDescription) {
            ContainerDescription containerDescription = (ContainerDescription)controlDescription;
            EList controls = containerDescription.getControls();
            for (ControlDescription control : controls) {
                this.handleControl(control);
            }
        } else if (controlDescription instanceof ListDescription && controlDescription.eClass().equals(this.placeholderReferenceDescriptionEClass)) {
            ListDescription listDescription = (ListDescription)controlDescription;
            ListDescription newDescription = null;
            Object object = listDescription.eGet(this.placeholderReferenceDescriptionEClass.getEStructuralFeature(REFERENCE_DESCRIPTION_MULTIPLE));
            if (Boolean.TRUE.equals(object)) {
                newDescription = this.handleList(listDescription);
            } else if (Boolean.FALSE.equals(object) && listDescription.getOnClickOperation() != null) {
                newDescription = this.handleHyperlink(listDescription);
            } else if (Boolean.FALSE.equals(object) && listDescription.getOnClickOperation() == null) {
                newDescription = this.handleLabel(listDescription);
            }
            if (newDescription != null) {
                EcoreUtil.replace((EObject)listDescription, (EObject)newDescription);
            }
        }
    }

    private ListDescription handleList(ListDescription listDescription) {
        ListDescription list = PropertiesFactory.eINSTANCE.createListDescription();
        list.setIdentifier(listDescription.getIdentifier());
        list.setHelpExpression(listDescription.getHelpExpression());
        list.setDisplayExpression(listDescription.getDisplayExpression());
        list.setIsEnabledExpression(listDescription.getIsEnabledExpression());
        list.setLabelExpression(listDescription.getLabelExpression());
        list.setValueExpression(listDescription.getValueExpression());
        list.getActions().addAll((Collection)listDescription.getActions());
        list.setOnClickOperation(listDescription.getOnClickOperation());
        list.setStyle(listDescription.getStyle());
        list.getConditionalStyles().addAll((Collection)listDescription.getConditionalStyles());
        return list;
    }

    private HyperlinkDescription handleHyperlink(ListDescription listDescription) {
        HyperlinkDescription hyperlink = PropertiesFactory.eINSTANCE.createHyperlinkDescription();
        hyperlink.setIdentifier(listDescription.getIdentifier());
        hyperlink.setHelpExpression(listDescription.getHelpExpression());
        hyperlink.setDisplayExpression(listDescription.getDisplayExpression());
        hyperlink.setIsEnabledExpression(listDescription.getIsEnabledExpression());
        hyperlink.setLabelExpression(listDescription.getLabelExpression());
        hyperlink.setValueExpression(listDescription.getValueExpression());
        hyperlink.getActions().addAll((Collection)listDescription.getActions());
        hyperlink.setInitialOperation(listDescription.getOnClickOperation());
        ListWidgetStyle listWidgetStyle = listDescription.getStyle();
        if (listWidgetStyle != null) {
            hyperlink.setStyle(this.handleHyperlinkStyle(listWidgetStyle));
        }
        EList listConditionalStyles = listDescription.getConditionalStyles();
        for (ListWidgetConditionalStyle listWidgetConditionalStyle : listConditionalStyles) {
            HyperlinkWidgetConditionalStyle hyperlinkWidgetConditionalStyle = PropertiesFactory.eINSTANCE.createHyperlinkWidgetConditionalStyle();
            hyperlinkWidgetConditionalStyle.setPreconditionExpression(listWidgetConditionalStyle.getPreconditionExpression());
            if (listWidgetConditionalStyle.getStyle() != null) {
                hyperlinkWidgetConditionalStyle.setStyle(this.handleHyperlinkStyle(listWidgetConditionalStyle.getStyle()));
            }
            hyperlink.getConditionalStyles().add((Object)hyperlinkWidgetConditionalStyle);
        }
        return hyperlink;
    }

    private HyperlinkWidgetStyle handleHyperlinkStyle(ListWidgetStyle listWidgetStyle) {
        HyperlinkWidgetStyle hyperlinkWidgetStyle = PropertiesFactory.eINSTANCE.createHyperlinkWidgetStyle();
        if (listWidgetStyle != null) {
            hyperlinkWidgetStyle.setLabelBackgroundColor(listWidgetStyle.getLabelBackgroundColor());
            hyperlinkWidgetStyle.setLabelForegroundColor(listWidgetStyle.getLabelForegroundColor());
            hyperlinkWidgetStyle.setLabelFontNameExpression(listWidgetStyle.getLabelFontNameExpression());
            hyperlinkWidgetStyle.setLabelFontSizeExpression(listWidgetStyle.getLabelFontSizeExpression());
            hyperlinkWidgetStyle.getLabelFontFormat().addAll((Collection)listWidgetStyle.getLabelFontFormat());
        }
        return hyperlinkWidgetStyle;
    }

    private LabelDescription handleLabel(ListDescription listDescription) {
        LabelDescription label = PropertiesFactory.eINSTANCE.createLabelDescription();
        label.setIdentifier(listDescription.getIdentifier());
        label.setHelpExpression(listDescription.getHelpExpression());
        label.setDisplayExpression(listDescription.getDisplayExpression());
        label.setIsEnabledExpression(listDescription.getIsEnabledExpression());
        label.setLabelExpression(listDescription.getLabelExpression());
        label.setValueExpression(listDescription.getValueExpression());
        label.getActions().addAll((Collection)listDescription.getActions());
        ListWidgetStyle listWidgetStyle = listDescription.getStyle();
        label.setStyle(this.handleLabelStyle(listWidgetStyle));
        EList listConditionalStyles = listDescription.getConditionalStyles();
        for (ListWidgetConditionalStyle listWidgetConditionalStyle : listConditionalStyles) {
            LabelWidgetConditionalStyle labelWidgetConditionalStyle = PropertiesFactory.eINSTANCE.createLabelWidgetConditionalStyle();
            labelWidgetConditionalStyle.setPreconditionExpression(listWidgetConditionalStyle.getPreconditionExpression());
            labelWidgetConditionalStyle.setStyle(this.handleLabelStyle(listWidgetConditionalStyle.getStyle()));
            label.getConditionalStyles().add((Object)labelWidgetConditionalStyle);
        }
        return label;
    }

    private LabelWidgetStyle handleLabelStyle(ListWidgetStyle listWidgetStyle) {
        LabelWidgetStyle labelWidgetStyle = PropertiesFactory.eINSTANCE.createLabelWidgetStyle();
        if (listWidgetStyle != null) {
            labelWidgetStyle.setLabelBackgroundColor(listWidgetStyle.getLabelBackgroundColor());
            labelWidgetStyle.setLabelForegroundColor(listWidgetStyle.getLabelForegroundColor());
            labelWidgetStyle.setLabelFontNameExpression(listWidgetStyle.getLabelFontNameExpression());
            labelWidgetStyle.setLabelFontSizeExpression(listWidgetStyle.getLabelFontSizeExpression());
            labelWidgetStyle.getLabelFontFormat().addAll((Collection)listWidgetStyle.getLabelFontFormat());
        }
        return labelWidgetStyle;
    }
}

