/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.paramArchConfigurator.ui.wizard;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.page.AssignValuesPage;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.page.LastPage;
import org.polarsys.chess.service.core.model.ChessSystemModel;

public class InstantiateArchWizard
extends Wizard {
    protected AssignValuesPage one;
    protected LastPage lastPage;
    private static final Logger logger = Logger.getLogger(InstantiateArchWizard.class);
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private File ossFile;
    private IProgressMonitor monitor;
    private boolean isDiscrete;
    private EObject selectedElement;
    private Package seletedPackage;
    private boolean createNestedPackage;
    private boolean importArch;
    private String nestedPackageName;
    private File finalOssFile;
    private File finalParamListFile;
    private DialogUtil dialogUtil = DialogUtil.getInstance();

    public InstantiateArchWizard(File ossFile, EObject selectedElement, boolean isDiscrete, IProgressMonitor monitor) {
        this.ossFile = ossFile;
        this.monitor = monitor;
        this.isDiscrete = isDiscrete;
        this.selectedElement = selectedElement;
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        return "Parameterized Architecture Instantiation Wizard";
    }

    public void addPages() {
        try {
            Map parametersList = this.ocraExecService.executeGetParameters(this.ossFile, this.isDiscrete, this.monitor);
            if (parametersList != null && !parametersList.isEmpty()) {
                Map<String, Map<String, String>> existingParametersLists = this.getExistingParametersLists(this.selectedElement);
                String currentDate = this.getCurrentDateAsStr();
                String prefixName = String.valueOf(FilenameUtils.removeExtension((String)this.ossFile.getName())) + "_" + currentDate;
                this.one = new AssignValuesPage(true, prefixName, this.selectedElement, this.ossFile, null, null, existingParametersLists, parametersList, (EList<EList<String>>)new BasicEList(), 1, this.isDiscrete, this.monitor, (IWizard)this);
                this.addPage((IWizardPage)this.one);
            }
            this.lastPage = new LastPage(this.selectedElement, null, (EList<EList<String>>)new BasicEList());
            this.addPage((IWizardPage)this.lastPage);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dialogUtil.showMessage_ExceptionError(e);
            this.performCancel();
        }
    }

    private Map<String, Map<String, String>> getExistingParametersLists(EObject selectedElement) {
        EList instantiatedArchitectureList = EntityUtil.getInstance().getInstantiatedArchitecureElementsAsProperties((Class)selectedElement);
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>();
        if (instantiatedArchitectureList != null && instantiatedArchitectureList.size() != 0) {
            for (Property property : instantiatedArchitectureList) {
                InstantiatedArchitectureConfiguration instantiatedArchitecture = EntityUtil.getInstance().getInstantiatedArchitectureConfiguration(property);
                HashMap<String, String> temp = new HashMap<String, String>();
                for (String param : instantiatedArchitecture.getParameterList()) {
                    logger.debug((Object)("param: " + param));
                    String[] paramTerms = param.split("=");
                    logger.debug((Object)("paramTerms[0]: " + paramTerms[0]));
                    logger.debug((Object)("paramTerms[1]: " + paramTerms[1]));
                    temp.put(paramTerms[0], paramTerms[1]);
                }
                logger.debug((Object)("dependency.getQualifiedName(): " + property.getQualifiedName()));
                res.put(property.getQualifiedName(), temp);
            }
        }
        return res;
    }

    private String getCurrentDateAsStr() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() instanceof AssignValuesPage) {
            return false;
        }
        if (this.getContainer().getCurrentPage() instanceof LastPage) {
            return this.getContainer().getCurrentPage().isPageComplete();
        }
        return false;
    }

    public Package getSelectedPackage() {
        return this.seletedPackage;
    }

    public boolean createNestedPackage() {
        return this.createNestedPackage;
    }

    public boolean importArch() {
        return this.importArch;
    }

    public String getNestedPackageName() {
        return this.nestedPackageName;
    }

    public File getOSSFile() {
        return this.finalOssFile;
    }

    public File getParamsListFile() {
        return this.finalParamListFile;
    }

    public boolean performFinish() {
        this.seletedPackage = ((LastPage)this.getContainer().getCurrentPage()).getSelectedPackage();
        this.createNestedPackage = ((LastPage)this.getContainer().getCurrentPage()).createNestedPackage();
        this.nestedPackageName = ((LastPage)this.getContainer().getCurrentPage()).getNestedPackageName();
        this.importArch = ((LastPage)this.getContainer().getCurrentPage()).importArchitecture();
        this.finalOssFile = ((LastPage)this.getContainer().getCurrentPage()).getOSSFile();
        this.finalParamListFile = ((LastPage)this.getContainer().getCurrentPage()).getParamListFile();
        return !this.importArch || this.seletedPackage != null;
    }
}

