/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.nuXmvService.ui.utils;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class NuXmvDirectoryUtil {
    private final String NUXMV_FILE_PATH = String.valueOf(File.separator) + "NuSMV3-XSAP";
    private final String NUXMV_SMV_FILE_PATH = String.valueOf(this.NUXMV_FILE_PATH) + File.separator + "Files";
    private static final Logger logger = Logger.getLogger(NuXmvDirectoryUtil.class);
    private final String NUXMV_RESULTS_FILE_PATH = String.valueOf(this.NUXMV_FILE_PATH) + File.separator + "Results";
    private static NuXmvDirectoryUtil nuXmvDirectoryUtil;
    private static DirectoryUtil directoryUtil;

    static {
        directoryUtil = DirectoryUtil.getInstance();
    }

    public static NuXmvDirectoryUtil getInstance() {
        if (nuXmvDirectoryUtil == null) {
            nuXmvDirectoryUtil = new NuXmvDirectoryUtil();
        }
        return nuXmvDirectoryUtil;
    }

    public String getSmvFileDirectory() throws Exception {
        return String.valueOf(directoryUtil.getCurrentProjectDir()) + this.NUXMV_SMV_FILE_PATH;
    }

    public String getSmvFileDirectory(String projectPath) throws Exception {
        return String.valueOf(projectPath) + this.NUXMV_SMV_FILE_PATH;
    }

    public String getModelCheckingResultPath(String selectedComponentName) throws Exception {
        return this.getNuXmvResultFilePath("output_" + selectedComponentName, directoryUtil.getCurrentProjectDir(), "modelChecking");
    }

    public String getModelCheckingResultPath(String projectPath, String selectedComponentName) throws Exception {
        return this.getNuXmvResultFilePath("output_" + selectedComponentName, projectPath, "modelChecking");
    }

    private String getNuXmvResultFilePath(String smvFileName, String baseDir, String commandType) {
        String nuXmvResultsFileDir = this.createNuXmvResultsFileDir(baseDir);
        String filePath = String.valueOf(nuXmvResultsFileDir) + File.separator + smvFileName.replace(".", "_") + "_" + commandType + "_result.xml";
        return filePath;
    }

    private String getNuXmvResultsFileDirectory(String baseDir) {
        String nuXmvResultsFilePath = String.valueOf(baseDir) + this.NUXMV_RESULTS_FILE_PATH;
        logger.debug((Object)("nuXmvResultsFilePath: " + nuXmvResultsFilePath));
        return nuXmvResultsFilePath;
    }

    private String createNuXmvResultsFileDir(String baseDir) {
        String filePath = this.getNuXmvResultsFileDirectory(baseDir);
        File theFile = new File(filePath);
        theFile.mkdirs();
        return filePath;
    }

    public String getMonolithicSMVFilePath(String componentName) throws Exception {
        return String.valueOf(this.getSmvFileDirectory()) + File.separator + componentName.replace(".", "_") + "_monolithic.smv";
    }

    public String getMonolithicSMVFilePath(String projectPath, String componentName) throws Exception {
        return String.valueOf(this.getSmvFileDirectory(projectPath)) + File.separator + componentName.replace(".", "_") + "_monolithic.smv";
    }
}

