/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.mobius.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;

public class QVTBlackBox {
    private static String ATTACKQN = "CHESS::Dependability::ThreatsPropagation::Attack";

    public static void setCeiling2(IContext context, Class self, String ceiling) {
    }

    @Operation(kind=Operation.Kind.OPERATION, contextual=true, withExecutionContext=true)
    public List<NamedElement> getOrderedAttacksAndFragments(IContext context, Interaction scenario) {
        List<DurationConstraint> durConstrList = QVTBlackBox.getDurConstrList(scenario);
        List<MessageOccurrenceSpecification> msgOccList = this.getMsgOccSpecs(scenario);
        ArrayList<GeneralOrdering> genOrderList = new ArrayList<GeneralOrdering>();
        for (MessageOccurrenceSpecification msgOcc : msgOccList) {
            for (GeneralOrdering order : msgOcc.getGeneralOrderings()) {
                genOrderList.add(order);
            }
        }
        for (GeneralOrdering order : scenario.getGeneralOrderings()) {
            genOrderList.add(order);
        }
        ArrayList<Message> orderedMsgList = new ArrayList<Message>();
        boolean start = true;
        for (GeneralOrdering order : genOrderList) {
            Message beforeMsg = ((MessageOccurrenceSpecification)order.getBefore()).getMessage();
            Message afterMsg = ((MessageOccurrenceSpecification)order.getAfter()).getMessage();
            if (start) {
                orderedMsgList.add(beforeMsg);
                if (!beforeMsg.equals(afterMsg)) {
                    orderedMsgList.add(afterMsg);
                }
                start = false;
                continue;
            }
            if (orderedMsgList.contains(beforeMsg) && !orderedMsgList.contains(afterMsg)) {
                orderedMsgList.add(afterMsg);
            }
            if (!orderedMsgList.contains(afterMsg) || orderedMsgList.contains(beforeMsg)) continue;
            orderedMsgList.add(0, beforeMsg);
        }
        if (orderedMsgList.isEmpty()) {
            orderedMsgList.addAll((Collection<Message>)scenario.getMessages());
        }
        ArrayList<NamedElement> orderedElemList = new ArrayList<NamedElement>();
        for (Message message : orderedMsgList) {
            InteractionOperand operand;
            CombinedFragment combfrag;
            if (message.getAppliedStereotype(ATTACKQN) == null || !(message.getSendEvent() instanceof MessageOccurrenceSpecification)) continue;
            MessageOccurrenceSpecification msgOcc = (MessageOccurrenceSpecification)message.getSendEvent();
            if (msgOcc.getEnclosingInteraction() != null) {
                orderedElemList.add((NamedElement)message);
                continue;
            }
            if (msgOcc.getEnclosingOperand() == null || orderedElemList.contains(combfrag = (CombinedFragment)(operand = msgOcc.getEnclosingOperand()).getOwner())) continue;
            orderedElemList.add((NamedElement)combfrag);
        }
        for (DurationConstraint durConstr : durConstrList) {
            Element constrElem;
            EList constrElems = durConstr.getConstrainedElements();
            if (constrElems.size() == 0 || !orderedElemList.contains(constrElem = (Element)constrElems.get(0))) continue;
            int index = orderedElemList.indexOf(constrElem);
            orderedElemList.add(index, (NamedElement)durConstr);
        }
        return orderedElemList;
    }

    private static List<DurationConstraint> getDurConstrList(Interaction scenario) {
        ArrayList<DurationConstraint> durConstrList = new ArrayList<DurationConstraint>();
        EList rules = scenario.getOwnedRules();
        for (Constraint constraint : rules) {
            if (!(constraint instanceof DurationConstraint)) continue;
            durConstrList.add((DurationConstraint)constraint);
        }
        return durConstrList;
    }

    private List<MessageOccurrenceSpecification> getMsgOccSpecs(Interaction scenario) {
        ArrayList<MessageOccurrenceSpecification> msgOccList = new ArrayList<MessageOccurrenceSpecification>();
        EList fragments = scenario.getFragments();
        for (InteractionFragment fragment : fragments) {
            if (fragment instanceof CombinedFragment) {
                CombinedFragment combFrag = (CombinedFragment)fragment;
                EList operands = combFrag.getOperands();
                for (InteractionOperand intOp : operands) {
                    for (InteractionFragment intOpFrag : intOp.getFragments()) {
                        if (!(intOpFrag instanceof MessageOccurrenceSpecification)) continue;
                        msgOccList.add((MessageOccurrenceSpecification)intOpFrag);
                    }
                }
            }
            if (!(fragment instanceof MessageOccurrenceSpecification)) continue;
            msgOccList.add((MessageOccurrenceSpecification)fragment);
        }
        return msgOccList;
    }
}

