/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.ManagedContainerViewProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public class PluginContainerViewProvider
extends ManagedContainerViewProvider {
    public static final CDOViewProvider INSTANCE = new PluginContainerViewProvider();
    private static final String REGEX = "cdo:.*";
    private static final int PRIORITY = 300;

    public PluginContainerViewProvider() {
        super((IManagedContainer)IPluginContainer.INSTANCE, REGEX, 300);
    }

    public CDOView getView(URI uri, ResourceSet resourceSet) {
        IManagedContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        String repoUUID = PluginContainerViewProvider.getRepositoryUUID(uri);
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.sessions");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view;
            Object element = objectArray[n2];
            CDOSession session = (CDOSession)element;
            String uuid = session.getRepositoryInfo().getUUID();
            if (repoUUID.equals(uuid) && (view = this.openView(session, resourceSet)) != null) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    public URI getResourceURI(CDOView view, String path) {
        if (StringUtil.isEmpty((String)path)) {
            path = "";
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String authority = view.getSession().getRepositoryInfo().getUUID();
        return URI.createURI((String)("cdo://" + authority + path));
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected CDOView openView(CDOSession session, ResourceSet resourceSet) {
        return session.openTransaction(resourceSet);
    }

    public static String getRepositoryUUID(URI uri) {
        try {
            if (!uri.hasAuthority()) {
                throw new InvalidURIException(uri);
            }
            return uri.authority();
        }
        catch (InvalidURIException ex) {
            return null;
        }
    }
}

