/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.TreeCollectionContentProvider;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MultipleValueEditor
extends AbstractListEditor
implements SelectionListener,
IChangeListener,
DisposeListener {
    public static final int MANY = -1;
    protected TreeViewer treeViewer;
    protected Tree tree;
    protected Composite controlsSection;
    protected Button add;
    protected Button remove;
    protected Button up;
    protected Button down;
    protected Button edit;
    protected IElementSelector selector;
    protected boolean ordered;
    protected boolean unique;
    protected ReferenceValueFactory referenceFactory;
    protected boolean readOnly;
    private boolean directCreation;
    protected int upperBound;

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector, boolean ordered, boolean unique, String label) {
        this(parent, style, selector, ordered, unique, label, -1);
    }

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector, boolean ordered, boolean unique, String label, int upperBound) {
        super(parent, label);
        Assert.isNotNull((Object)selector, (String)"The Element Selector must be specified for a MultipleValueEditor");
        this.setLayout((Layout)new GridLayout(label == null ? 1 : 2, false));
        this.controlsSection = new Composite((Composite)this, 0);
        this.controlsSection.setLayout((Layout)new FillLayout());
        this.controlsSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.tree = new Tree((Composite)this, style | 2 | 0x200 | 0x100 | 0x800 | 0x10000);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.horizontalSpan = 2;
        treeData.minimumHeight = 80;
        this.tree.setLayoutData((Object)treeData);
        this.tree.addSelectionListener((SelectionListener)this);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)TreeCollectionContentProvider.instance);
        this.createListControls();
        this.selector = selector;
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.setUpperBound(upperBound);
        this.ordered = ordered;
        this.unique = unique;
        this.updateControls();
    }

    protected MultipleValueSelectorDialog createMultipleValueSelectorDialog(Composite parent, IElementSelector selector, boolean ordered, boolean unique, String label) {
        return new MultipleValueSelectorDialog(parent.getShell(), selector, label, unique, ordered);
    }

    @Override
    protected GridData getLabelLayoutData() {
        GridData data = new GridData(4, 0x1000000, true, false);
        return data;
    }

    public void setSelector(IElementSelector selector) {
        this.selector = selector;
    }

    protected void updateControls() {
        boolean enableAddAction = true;
        if (this.directCreation && (this.referenceFactory == null || !this.referenceFactory.canCreateObject())) {
            enableAddAction = false;
        }
        this.add.setEnabled(!this.readOnly && enableAddAction);
        this.remove.setEnabled(!this.readOnly);
        this.up.setEnabled(this.ordered && !this.readOnly);
        this.down.setEnabled(this.ordered && !this.readOnly);
        if (this.edit != null) {
            this.edit.setEnabled(this.referenceFactory != null && this.referenceFactory.canEdit() && !this.readOnly);
        }
        if (this.modelProperty != null && this.upperBound != -1 && this.modelProperty.size() >= this.upperBound) {
            this.add.setEnabled(false);
        }
    }

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector, boolean ordered) {
        this(parent, style, selector, ordered, false, null);
    }

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector) {
        this(parent, style, selector, false, false, null);
    }

    public MultipleValueEditor(Composite parent, int style, IElementSelector selector, String label) {
        this(parent, style, selector, false, false, label);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.treeViewer.setLabelProvider(labelProvider);
    }

    @Override
    protected void doBinding() {
        this.treeViewer.setInput((Object)this.modelProperty);
        this.modelProperty.addChangeListener((IChangeListener)this);
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
        this.updateControls();
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
        this.updateControls();
    }

    protected void createListControls() {
        this.up = this.createButton(Activator.getDefault().getImage("/icons/Up_12x12.gif"), Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = this.createButton(Activator.getDefault().getImage("/icons/Down_12x12.gif"), Messages.MultipleValueEditor_MoveSelectedElementsDown);
        this.add = this.createButton(Activator.getDefault().getImage("/icons/Add_12x12.gif"), Messages.MultipleValueEditor_AddElements);
        this.remove = this.createButton(Activator.getDefault().getImage("/icons/Delete_12x12.gif"), Messages.MultipleValueEditor_RemoveSelectedElements);
        this.edit = this.createButton(Activator.getDefault().getImage("/icons/Edit_12x12.gif"), Messages.MultipleValueEditor_EditSelectedValue);
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.controlsSection, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        return button;
    }

    @Override
    public Object getEditableType() {
        return Collection.class;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == null) {
            return;
        }
        try {
            if (e.widget == this.add) {
                if (this.upperBound == -1 || this.modelProperty.size() < this.upperBound) {
                    this.addAction();
                }
            } else if (e.widget == this.remove) {
                this.removeAction();
            } else if (e.widget == this.up) {
                this.upAction();
            } else if (e.widget == this.down) {
                this.downAction();
            } else if (e.widget == this.edit) {
                this.editAction();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        this.updateBoutons();
    }

    protected void addAction() {
        final Object context = this.getContextElement();
        if (this.directCreation) {
            if (this.referenceFactory != null && this.referenceFactory.canCreateObject()) {
                this.getOperationExecutor(context).execute(new Runnable(){

                    @Override
                    public void run() {
                        Object newElement = MultipleValueEditor.this.referenceFactory.createObject((Control)MultipleValueEditor.this, context);
                        if (newElement != null) {
                            MultipleValueEditor.this.modelProperty.add(newElement);
                            MultipleValueEditor.this.commit();
                        }
                    }
                }, NLS.bind((String)Messages.MultipleValueEditor_addOperation, (Object)this.labelText));
            }
            return;
        }
        this.getOperationExecutor(context).execute(new Runnable(){

            @Override
            public void run() {
                String dialogLabel = MultipleValueEditor.this.label == null ? null : MultipleValueEditor.this.label.getText();
                MultipleValueSelectorDialog dialog = MultipleValueEditor.this.createMultipleValueSelectorDialog(MultipleValueEditor.this.getParent(), MultipleValueEditor.this.selector, MultipleValueEditor.this.ordered, MultipleValueEditor.this.unique, dialogLabel);
                dialog.setLabelProvider((ILabelProvider)MultipleValueEditor.this.treeViewer.getLabelProvider());
                dialog.setFactory(MultipleValueEditor.this.referenceFactory);
                dialog.setUpperBound(MultipleValueEditor.this.upperBound);
                dialog.setContextElement(context);
                if (MultipleValueEditor.this.modelProperty != null) {
                    dialog.setInitialSelections(MultipleValueEditor.this.modelProperty.toArray());
                } else {
                    dialog.setInitialSelections(new Object[0]);
                }
                int returnCode = dialog.open();
                if (returnCode == 1) {
                    MultipleValueEditor.this.selector.clearTemporaryElements();
                    throw new OperationCanceledException();
                }
                MultipleValueEditor.this.modelProperty.clear();
                Object[] result = dialog.getResult();
                if (result == null) {
                    return;
                }
                MultipleValueEditor.this.modelProperty.addAll(Arrays.asList(result));
                MultipleValueEditor.this.commit();
            }
        }, NLS.bind((String)Messages.MultipleValueEditor_addOperation, (Object)this.labelText));
    }

    @Override
    protected void commit() {
        super.commit();
        if (!this.isDisposed()) {
            this.treeViewer.refresh();
        }
    }

    protected void removeAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            this.modelProperty.remove(value);
            ++n2;
        }
        this.treeViewer.setSelection(null);
        this.commit();
    }

    protected void upAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int oldIndex = this.modelProperty.indexOf(o);
            if (oldIndex > 0) {
                this.modelProperty.move(oldIndex, oldIndex - 1);
            }
            ++n2;
        }
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.treeViewer.setSelection((ISelection)selectionCopy);
        this.commit();
    }

    protected void downAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        int maxIndex = this.modelProperty.size() - 1;
        Object[] selectionArray = selection.toArray();
        int i = selectionArray.length - 1;
        while (i >= 0) {
            Object o = selectionArray[i];
            int oldIndex = this.modelProperty.indexOf(o);
            if (oldIndex < maxIndex) {
                this.modelProperty.move(oldIndex, oldIndex + 1);
            }
            --i;
        }
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.treeViewer.setSelection((ISelection)selectionCopy);
        this.commit();
    }

    protected void editAction() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TreeItem selectedItem = this.treeViewer.getTree().getSelection()[0];
        Tree parentTree = selectedItem.getParent();
        final int index = parentTree.indexOf(selectedItem);
        final Object currentValue = selection.getFirstElement();
        this.getOperationExecutor(currentValue).execute(new Runnable(){

            @Override
            public void run() {
                Object newValue = MultipleValueEditor.this.referenceFactory.edit((Control)MultipleValueEditor.this.edit, currentValue);
                if (newValue != currentValue && newValue != null) {
                    MultipleValueEditor.this.modelProperty.remove(index);
                    MultipleValueEditor.this.modelProperty.add(index, newValue);
                }
                MultipleValueEditor.this.commit();
            }
        }, NLS.bind((String)Messages.MultipleValueEditor_editOperation, (Object)this.labelText));
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.referenceFactory = factory;
        this.updateControls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.tree && this.edit != null && this.edit.isEnabled()) {
            this.editAction();
        }
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void handleChange(ChangeEvent event) {
        if (!this.isDisposed()) {
            this.treeViewer.refresh();
        }
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateControls();
    }

    @Override
    public boolean isReadOnly() {
        return !this.tree.isEnabled();
    }

    @Override
    public void setLabel(String label) {
        if (this.label == null) {
            this.setLayout((Layout)new GridLayout(2, false));
        }
        super.setLabel(label);
    }

    public void setToolTipText(String text) {
        this.tree.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    @Override
    public void setModelObservable(IObservableList modelProperty) {
        super.setModelObservable(modelProperty);
        this.updateControls();
    }

    @Override
    public void refreshValue() {
        this.treeViewer.refresh();
    }

    public void setDirectCreation(boolean directCreation) {
        this.directCreation = directCreation;
        this.updateControls();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public void updateBoutons() {
        if (this.upperBound != -1) {
            if (this.modelProperty.size() >= this.upperBound) {
                this.add.setEnabled(false);
            } else {
                this.add.setEnabled(true);
            }
        }
    }

    @Override
    public void changeColorField() {
    }
}

