/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.ImageProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractMenuContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.LayersActivationAction;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers.LayersActivationAdapter;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.Image;

public class LayersContribution
extends AbstractMenuContributionItem {
    private static final ImageDescriptor DESC_LAYER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/layers.gif");
    private LayersActivationAdapter adapter;

    @Override
    protected Image getMenuImage() {
        EObject diagram;
        Diagram gmfDiagram = this.part.getDiagram();
        if (gmfDiagram != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram) {
            super.setDiagram((DDiagram)diagram);
            if (!this.getActivatedLayers().isEmpty()) {
                return DiagramUIPlugin.Implementation.getDecoratedCheckedImage(DESC_LAYER);
            }
        }
        return DiagramUIPlugin.getPlugin().getImage(DESC_LAYER);
    }

    @Override
    protected String getLabel() {
        return Messages.LayersContribution_label;
    }

    @Override
    protected void setDiagram(DDiagram diagram) {
        super.setDiagram(diagram);
        DDiagramEditor diagramEditor = (DDiagramEditor)this.part.getDiagramGraphicalViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        this.adapter = new LayersActivationAdapter();
        this.adapter.setPaletteManager(diagramEditor.getPaletteManager());
        if (!diagram.eAdapters().contains((Object)this.adapter)) {
            diagram.eAdapters().add((Object)this.adapter);
        }
    }

    @Override
    protected void menuShow(IMenuManager manager) {
        for (Layer layer : this.getLayers()) {
            this.addLayerMenuItem(manager, layer);
        }
    }

    private Collection<Layer> getLayers() {
        DiagramDescription diagramDesc = this.diagram.getDescription();
        ArrayList<Layer> allLayers = new ArrayList<Layer>((Collection<Layer>)new DiagramComponentizationManager().getAllLayers(this.session.getSelectedViewpoints(false), diagramDesc));
        allLayers.remove(diagramDesc.getDefaultLayer());
        Iterables.removeIf(allLayers, (Predicate)new Predicate<Layer>(){

            public boolean apply(Layer layer) {
                if (layer instanceof AdditionalLayer) {
                    return !((AdditionalLayer)layer).isOptional();
                }
                return false;
            }
        });
        return allLayers;
    }

    private Collection<Layer> getActivatedLayers() {
        DiagramDescription diagramDesc = this.diagram.getDescription();
        ArrayList<Layer> allLayers = new ArrayList<Layer>((Collection<Layer>)this.diagram.getActivatedLayers());
        allLayers.remove(diagramDesc.getDefaultLayer());
        return allLayers;
    }

    private void addLayerMenuItem(IMenuManager manager, Layer layer) {
        LayersActivationAction action = new LayersActivationAction(new IdentifiedElementQuery((IdentifiedElement)layer).getLabel(), 2, this.diagram, layer);
        if (!StringUtil.isEmpty((String)layer.getIcon())) {
            action.setImageDescriptor(ImageProvider.getImageDescriptor((String)layer.getIcon()));
        }
        manager.add((IContributionItem)new ActionContributionItem((IAction)action){

            public void dispose() {
                super.dispose();
                ((LayersActivationAction)this.getAction()).dispose();
            }
        });
        this.addTooltip(this.getTooltipText(layer));
    }

    private String getTooltipText(Layer layer) {
        String endUserDoc = layer.getEndUserDocumentation();
        if (endUserDoc != null && endUserDoc.trim().length() > 0) {
            return endUserDoc;
        }
        return new IdentifiedElementQuery((IdentifiedElement)layer).getLabel();
    }

    @Override
    public void dispose() {
        if (this.diagram != null) {
            this.diagram.eAdapters().remove((Object)this.adapter);
        }
        this.adapter = null;
        super.dispose();
    }
}

