/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;

public abstract class AbstractEvaluatorIterationManager
extends AbstractIterationManager {
    protected final @NonNull CollectionValue collectionValue;
    protected final CallExp callExp;
    protected final @NonNull OCLExpression body;
    protected final @Nullable TypedElement accumulatorVariable;
    private @Nullable Object accumulatorValue;

    @Deprecated
    protected static @NonNull ValueIterator @Nullable [] createIterators(@NonNull TypedElement @NonNull [] referredIterators, @NonNull Evaluator evaluator, @NonNull CollectionValue collectionValue) {
        return AbstractEvaluatorIterationManager.createIterators(referredIterators, ValueUtil.getExecutor(evaluator), collectionValue);
    }

    protected static @NonNull ValueIterator @Nullable [] createIterators(@NonNull TypedElement @NonNull [] referredIterators, @NonNull Executor executor, @NonNull CollectionValue collectionValue) {
        int iMax = referredIterators.length;
        @NonNull ValueIterator @Nullable [] iterators = new ValueIterator[iMax];
        int i = 0;
        while (i < iMax) {
            TypedElement referredIterator = referredIterators[i];
            ValueIterator valueIterator = new ValueIterator(executor, collectionValue, referredIterator);
            if (!valueIterator.hasCurrent()) {
                return null;
            }
            iterators[i] = valueIterator;
            ++i;
        }
        return iterators;
    }

    @Deprecated
    public AbstractEvaluatorIterationManager(@NonNull Evaluator evaluator, @NonNull OCLExpression body, @NonNull CollectionValue collectionValue, @Nullable TypedElement accumulatorVariable, @Nullable Object accumulatorValue) {
        this(ValueUtil.getExecutor(evaluator), null, body, collectionValue, accumulatorVariable, accumulatorValue);
    }

    protected AbstractEvaluatorIterationManager(@NonNull Executor executor, CallExp callExp, @NonNull OCLExpression body, @NonNull CollectionValue collectionValue, @Nullable TypedElement accumulatorVariable, @Nullable Object accumulatorValue) {
        super(executor);
        this.collectionValue = collectionValue;
        this.callExp = callExp;
        this.body = body;
        this.accumulatorVariable = accumulatorVariable;
        this.accumulatorValue = accumulatorValue;
        if (accumulatorVariable != null) {
            this.getEvaluationEnvironment().add(accumulatorVariable, accumulatorValue);
        }
        this.executor.pushEvaluationEnvironment(body, callExp);
    }

    public AbstractEvaluatorIterationManager(@NonNull AbstractEvaluatorIterationManager iterationManager, @NonNull CollectionValue collectionValue) {
        super(iterationManager.executor);
        this.callExp = iterationManager.callExp;
        this.body = iterationManager.body;
        this.collectionValue = collectionValue;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.accumulatorVariable = iterationManager.accumulatorVariable;
        this.executor.pushEvaluationEnvironment(this.body, this.callExp);
    }

    @Override
    public void dispose() {
        this.executor.popEvaluationEnvironment();
    }

    @Override
    public @Nullable Object evaluateBody() {
        return this.executor.evaluate(this.body);
    }

    @Override
    public @Nullable Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public @NonNull CollectionValue getCollectionValue() {
        return this.collectionValue;
    }

    public @NonNull EvaluationEnvironment getEvaluationEnvironment() {
        return this.executor.getEvaluationEnvironment();
    }

    @Override
    public @NonNull CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    public String toString() {
        return this.body.toString();
    }

    @Override
    public @Nullable Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        TypedElement accumulatorVariable2 = this.accumulatorVariable;
        if (accumulatorVariable2 != null) {
            this.getEvaluationEnvironment().replace(accumulatorVariable2, this.accumulatorValue);
        }
        return null;
    }

    protected static class ValueIterator {
        private final EvaluationEnvironment evaluationEnvironment;
        private final @NonNull CollectionValue collectionValue;
        private final @NonNull TypedElement variable;
        private Iterator<? extends Object> javaIter;
        private Object value;

        @Deprecated
        public ValueIterator(@NonNull Evaluator evaluator, @NonNull CollectionValue collectionValue, @NonNull TypedElement variable) {
            this(ValueUtil.getExecutor(evaluator), collectionValue, variable);
        }

        public ValueIterator(@NonNull Executor executor, @NonNull CollectionValue collectionValue, @NonNull TypedElement variable) {
            this.evaluationEnvironment = executor.getEvaluationEnvironment();
            this.collectionValue = collectionValue;
            this.variable = variable;
            this.reset();
        }

        public @Nullable Object get() {
            return this.value;
        }

        public boolean hasCurrent() {
            return this.value != this;
        }

        public @Nullable Object next() {
            if (!this.javaIter.hasNext()) {
                this.value = this;
            } else {
                this.value = this.javaIter.next();
                this.evaluationEnvironment.replace(this.variable, this.value);
            }
            return this.value;
        }

        public Object reset() {
            this.javaIter = this.collectionValue.iterator();
            return this.next();
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.variable)) + " = " + (this.value != this ? String.valueOf(this.value) : "<<END>>");
        }
    }
}

