/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.business.internal.migration.AbstractSiriusMigrationService;
import org.eclipse.sirius.business.internal.migration.AbstractVersionSAXParser;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileVersionSAXParser;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMVersionSAXParser;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.internal.preferences.SiriusDiagramInternalPreferencesKeys;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tests.support.api.DummyDialectEditorDialogFactory;
import org.eclipse.sirius.tests.support.api.EclipseTestsSupportHelper;
import org.eclipse.sirius.tests.support.api.TestCaseCleaner;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.internal.helper.CrossReferenceAdapterDetector;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditorDialogFactory;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.junit.Assert;
import org.osgi.framework.Version;

public abstract class SiriusTestCase
extends TestCase {
    public static final String INIT_ERROR_MSG = "An error occurs during tests initialization";
    protected static final String TEMPORARY_PROJECT_NAME = "DesignerTestProject";
    protected static final URI DEFAULT_MODELING_PROJECT_REPRESENTATIONS_FILE_URI = URI.createPlatformResourceURI((String)(String.valueOf(File.separator) + "DesignerTestProject" + File.separator + "representations.aird"), (boolean)true);
    private static final String DOT = ".";
    protected Session session;
    protected IInterpreter interpreter;
    protected ModelAccessor accessor;
    protected EObject semanticModel;
    protected boolean createModelingProject;
    protected final Set<Viewpoint> viewpoints = new LinkedHashSet<Viewpoint>();
    protected ViewpointSelection.Callback selectionCallback = new ViewpointSelectionCallback();
    protected final Multimap<String, IStatus> errors = LinkedHashMultimap.create();
    protected final Multimap<String, IStatus> warnings = LinkedHashMultimap.create();
    protected IProgressMonitor defaultProgress = new NullProgressMonitor();
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private ILogListener logListener;
    private boolean errorCatchActive;
    private boolean warningCatchActive;
    private final HashMap<String, Object> oldValueDiagramPreferences = new HashMap();
    private final HashMap<String, Object> oldValueDiagramUiPreferences = new HashMap();
    private final HashMap<String, Object> oldValueSiriusPreferences = new HashMap();
    private final HashMap<String, Object> oldValueSiriusUIPreferences = new HashMap();
    private final HashMap<String, Object> oldPlatformUIPreferences = new HashMap();

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("Setup of " + ((Object)((Object)this)).getClass().getName() + DOT + this.getName() + "()");
        this.setErrorCatchActive(true);
        this.setWarningCatchActive(false);
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
                preferenceStore.setValue("Global.enableAnimatedZoom", false);
                preferenceStore.setValue("Global.enableAnimatedLayout", false);
            }
        });
        if (this.createModelingProject) {
            EclipseTestsSupportHelper.INSTANCE.createModelingProject(TEMPORARY_PROJECT_NAME, false);
        } else {
            EclipseTestsSupportHelper.INSTANCE.createProject(TEMPORARY_PROJECT_NAME);
        }
    }

    protected void genericSetUp() throws Exception {
        this.genericSetUp(Collections.emptySet(), Collections.emptySet(), null);
    }

    protected void genericSetUp(String semanticModelPath, String modelerDescriptionPath) throws Exception {
        this.genericSetUp(semanticModelPath, modelerDescriptionPath, null);
    }

    protected void genericSetUp(String semanticModelPath, Collection<String> modelerDescriptionPaths) throws Exception {
        this.genericSetUp(Collections.singleton(semanticModelPath), modelerDescriptionPaths, null);
    }

    protected void genericSetUp(String semanticModelPath, String modelerDescriptionPath, String representationsModelPath) throws Exception {
        this.genericSetUp(Collections.singleton(semanticModelPath), Collections.singleton(modelerDescriptionPath), representationsModelPath);
    }

    protected void genericSetUp(Collection<String> semanticModelPaths, Collection<String> modelerDescriptionPaths, String representationsModelPath) throws Exception {
        ArrayList semanticModelUris = Lists.newArrayList();
        for (String semanticModelPath : semanticModelPaths) {
            semanticModelUris.add(this.toURI(semanticModelPath));
        }
        ArrayList modelerDescUris = Lists.newArrayList();
        for (String modelerDescriptionPath : modelerDescriptionPaths) {
            modelerDescUris.add(this.toURI(modelerDescriptionPath));
        }
        this.genericSetUp(semanticModelUris, modelerDescUris, true, this.toURI(representationsModelPath));
    }

    protected URI toURI(String path, ResourceURIType uriType) {
        URI uri = null;
        if (path != null) {
            String consistentPath = path;
            if (!path.startsWith("/")) {
                consistentPath = String.valueOf('/') + path;
            }
            if (uriType.equals((Object)ResourceURIType.RESOURCE_PLATFORM_URI)) {
                uri = URI.createPlatformResourceURI((String)consistentPath, (boolean)true);
            } else if (uriType.equals((Object)ResourceURIType.RESOURCE_PLUGIN_URI)) {
                uri = URI.createPlatformPluginURI((String)consistentPath, (boolean)true);
            }
        }
        return uri;
    }

    private URI toURI(String path) {
        if (path != null) {
            URI uri = path.startsWith(TEMPORARY_PROJECT_NAME) || path.startsWith("/DesignerTestProject") ? this.toURI(path, ResourceURIType.RESOURCE_PLATFORM_URI) : this.toURI(path, ResourceURIType.RESOURCE_PLUGIN_URI);
            return uri;
        }
        return null;
    }

    protected void genericSetUp(List<URI> semanticResourceURIs, List<URI> modelerResourceURIs, boolean createSession, URI sessionResourceURI) throws Exception {
        TestsUtil.emptyEventsFromUIThread();
        SiriusEditPlugin.getPlugin().setUiCallback((UICallBack)new NoUICallback());
        this.createOrLoadAndOpenSession(createSession, sessionResourceURI);
        if (modelerResourceURIs != null) {
            for (URI modelerResourceURI : modelerResourceURIs) {
                this.loadModeler(modelerResourceURI, (EditingDomain)this.session.getTransactionalEditingDomain());
            }
        }
        if (semanticResourceURIs != null && !semanticResourceURIs.isEmpty()) {
            Resource semanticResource;
            for (URI semanticResourceURI : semanticResourceURIs) {
                if (this.hasAlreadySemanticResourceLoaded(this.session, semanticResourceURI)) continue;
                AddSemanticResourceCommand addSemanticResourceCmd = new AddSemanticResourceCommand(this.session, semanticResourceURI, (IProgressMonitor)new NullProgressMonitor());
                this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)addSemanticResourceCmd);
            }
            Iterator resourcesIterator = this.session.getSemanticResources().iterator();
            if (resourcesIterator.hasNext() && !(semanticResource = (Resource)resourcesIterator.next()).getContents().isEmpty()) {
                this.semanticModel = (EObject)semanticResource.getContents().get(0);
            }
        }
        this.accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(this.session.getTransactionalEditingDomain().getResourceSet());
        if (this.semanticModel != null) {
            this.interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(this.semanticModel);
            InterpreterRegistry.prepareImportsFromSession((IInterpreter)this.interpreter, (Session)this.session);
        }
        DefaultScope.INSTANCE.getNode("org.eclipse.sirius").putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        InstanceScope.INSTANCE.getNode("org.eclipse.sirius").putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false);
        IDiagramCommandFactory commandFactory = DiagramCommandFactoryService.getInstance().getNewProvider().getCommandFactory(this.session.getTransactionalEditingDomain());
        commandFactory.setUserInterfaceCallBack((UICallBack)new NoUICallback());
        this.closeWelcomePage();
        TestsUtil.emptyEventsFromUIThread();
        this.initLoggers();
    }

    private void createOrLoadAndOpenSession(boolean createSession, URI sessionResourceURI) {
        if (createSession) {
            if (sessionResourceURI == null) {
                if (this.createModelingProject) {
                    this.createSession(DEFAULT_MODELING_PROJECT_REPRESENTATIONS_FILE_URI);
                } else {
                    this.createSession(this.getDefaultRepresentationsFileURI());
                }
            } else {
                this.createSession(sessionResourceURI);
            }
        } else {
            this.session = SessionManager.INSTANCE.getSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!this.session.isOpen()) {
            this.session.open((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected URI getDefaultRepresentationsFileURI() {
        return URI.createPlatformResourceURI((String)(String.valueOf(File.separator) + TEMPORARY_PROJECT_NAME + File.separator + ((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + DOT + "aird"), (boolean)true);
    }

    protected void createSession(final URI sessionResourceURI) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
                sessionCreationOperation.execute();
                SiriusTestCase.this.session = sessionCreationOperation.getCreatedSession();
                IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(SiriusTestCase.this.session);
                editingSession.open();
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Impossible to create the session.", e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Impossible to create the session.", e);
        }
    }

    protected void loadModeler(URI modelerResourceURI, EditingDomain domain) throws Exception {
        Group group = null;
        try {
            group = (Group)ModelUtils.load((URI)modelerResourceURI, (ResourceSet)domain.getResourceSet());
        }
        catch (IOException exception) {
            String uri = modelerResourceURI.toString();
            if (uri.startsWith("platform:/plugin/")) {
                URI alternativeURI = URI.createPlatformResourceURI((String)uri.substring(17), (boolean)true);
                group = (Group)ModelUtils.load((URI)alternativeURI, (ResourceSet)domain.getResourceSet());
            }
            Assert.fail((String)exception.getMessage());
        }
        if (group != null) {
            this.viewpoints.addAll((Collection<Viewpoint>)group.getOwnedViewpoints());
        }
    }

    private boolean hasAlreadySemanticResourceLoaded(Session newSession, URI semanticResourceURI) {
        for (Resource semanticResource : newSession.getSemanticResources()) {
            if (!semanticResourceURI.equals(semanticResource.getURI())) continue;
            return true;
        }
        return false;
    }

    protected abstract ICommandFactory getCommandFactory();

    protected void closeWelcomePage() {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart != null && "Welcome".equals(activePart.getTitle()) && activePart instanceof IViewPart) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)activePart);
        }
        TestsUtil.synchronizationWithUIThread();
    }

    protected void initLoggers() {
        this.logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                switch (status.getSeverity()) {
                    case 4: {
                        SiriusTestCase.this.errorOccurs(status, plugin);
                        break;
                    }
                    case 2: {
                        SiriusTestCase.this.warningOccurs(status, plugin);
                    }
                }
            }
        };
        Platform.addLogListener((ILogListener)this.logListener);
        this.exceptionHandler = new Thread.UncaughtExceptionHandler(){
            private final String sourcePlugin = "Uncaught exception";

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Status status = new Status(4, "Uncaught exception", "Uncaught exception", e);
                SiriusTestCase.this.errorOccurs((IStatus)status, "Uncaught exception");
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(this.exceptionHandler);
    }

    protected void disposeLoggers() {
        if (this.logListener != null) {
            Platform.removeLogListener((ILogListener)this.logListener);
        }
    }

    protected synchronized boolean doesAnErrorOccurs() {
        if (this.errors != null) {
            return this.errors.values().size() != 0;
        }
        return false;
    }

    protected synchronized boolean doesAWarningOccurs() {
        if (this.warnings != null) {
            return this.warnings.values().size() != 0;
        }
        return false;
    }

    protected synchronized void clearErrors() {
        this.errors.clear();
    }

    protected synchronized void clearWarnings() {
        this.warnings.clear();
    }

    private synchronized void errorOccurs(IStatus status, String sourcePlugin) {
        if (this.isErrorCatchActive()) {
            this.errors.put((Object)sourcePlugin, (Object)status);
        }
    }

    private synchronized void warningOccurs(IStatus status, String sourcePlugin) {
        if (this.isWarningCatchActive()) {
            this.warnings.put((Object)sourcePlugin, (Object)status);
        }
    }

    protected synchronized void setErrorCatchActive(boolean errorCatchActive) {
        this.errorCatchActive = errorCatchActive;
    }

    protected synchronized void setWarningCatchActive(boolean warningCatchActive) {
        this.warningCatchActive = warningCatchActive;
    }

    protected synchronized boolean isErrorCatchActive() {
        return this.errorCatchActive;
    }

    protected synchronized boolean isWarningCatchActive() {
        return this.warningCatchActive;
    }

    private void checkLogs() {
        if (!TestsUtil.shouldSkipUnreliableTests()) {
            if (this.doesAnErrorOccurs()) {
                Assert.fail((String)this.getErrorLoggersMessage());
            }
            if (this.doesAWarningOccurs()) {
                Assert.fail((String)this.getWarningLoggersMessage());
            }
        }
    }

    protected synchronized String getErrorLoggersMessage() {
        StringBuilder log1 = new StringBuilder();
        String br = "\n";
        String testName = ((Object)((Object)this)).getClass().getName();
        log1.append("Error(s) raised during test : " + testName).append(br);
        for (Map.Entry entry : this.errors.asMap().entrySet()) {
            String reporter = (String)entry.getKey();
            log1.append(". Log Plugin : " + reporter).append(br);
            for (IStatus status : (Collection)entry.getValue()) {
                log1.append("  . " + this.getSeverity(status) + " from plugin:" + status.getPlugin() + ", message: " + status.getMessage() + ", exception: " + status.getException()).append(br);
                this.appendStackTrace(log1, br, status);
            }
            log1.append(br);
        }
        return log1.toString();
    }

    protected synchronized String getWarningLoggersMessage() {
        StringBuilder log1 = new StringBuilder();
        String br = "\n";
        String testName = ((Object)((Object)this)).getClass().getName();
        log1.append("Warning(s) raised during test : " + testName).append(br);
        for (Map.Entry entry : this.warnings.asMap().entrySet()) {
            String reporter = (String)entry.getKey();
            log1.append(". Log Plugin : " + reporter).append(br);
            for (IStatus status : (Collection)entry.getValue()) {
                log1.append("  . " + this.getSeverity(status) + " from plugin:" + status.getPlugin() + ", message: " + status.getMessage() + ", exception: " + status.getException()).append(br);
                this.appendStackTrace(log1, br, status);
            }
            log1.append(br);
        }
        return log1.toString();
    }

    protected void appendStackTrace(StringBuilder stringBuilder, String endLineDelimiter, IStatus status) {
        PrintWriter pw = null;
        String stacktrace = null;
        if (status.getException() != null) {
            try {
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                status.getException().printStackTrace(pw);
                stacktrace = sw.toString();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (stacktrace == null) {
                    stacktrace = status.getException().toString();
                }
                stringBuilder.append("   . Stack trace: " + stacktrace).append(endLineDelimiter);
            }
        }
    }

    protected String getSeverity(IStatus status) {
        String severity;
        switch (status.getSeverity()) {
            case 0: {
                severity = "Ok";
                break;
            }
            case 1: {
                severity = "Info";
                break;
            }
            case 2: {
                severity = "Warning";
                break;
            }
            case 8: {
                severity = "Cancel";
                break;
            }
            case 4: {
                severity = "Error";
                break;
            }
            default: {
                severity = "Unspecified";
            }
        }
        return severity;
    }

    protected final void initViewpoints() {
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(this.session, this.selectionCallback, this.viewpoints, Collections.emptySet(), (IProgressMonitor)new NullProgressMonitor());
        domain.getCommandStack().execute((Command)command);
    }

    protected final void initViewpoint(String viewpointName) {
        this.initViewpoint(viewpointName, this.session, true);
    }

    @Deprecated
    protected final void initViewpoint(String viewpointName, Session alternateSession, EObject alternateSemanticModel) {
        this.initViewpoint(viewpointName, alternateSession, true);
    }

    protected final void initViewpoint(String viewpointName, Session alternateSession, boolean initRepresentations) {
        Viewpoint localSessionViewpoint = null;
        for (Viewpoint viewpoint : this.viewpoints) {
            if (viewpointName == null || !viewpointName.equals(viewpoint.getName())) continue;
            localSessionViewpoint = this.getViewpointFromName(viewpointName, alternateSession);
            break;
        }
        if (localSessionViewpoint != null) {
            ChangeViewpointSelectionCommand changeViewpointsSelectionCmd = new ChangeViewpointSelectionCommand(alternateSession, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), Collections.singleton(localSessionViewpoint), Collections.emptySet(), initRepresentations, (IProgressMonitor)new NullProgressMonitor());
            alternateSession.getTransactionalEditingDomain().getCommandStack().execute((Command)changeViewpointsSelectionCmd);
        }
    }

    protected final void activateViewpoint(String name) {
        ChangeViewpointSelectionCommand changeSiriussSelection;
        Viewpoint viewpointFromName;
        boolean activatedViewpoint = false;
        for (Viewpoint viewpoint : this.viewpoints) {
            if (!name.equals(viewpoint.getName())) continue;
            viewpointFromName = this.getViewpointFromName(name, this.session);
            changeSiriussSelection = new ChangeViewpointSelectionCommand(this.session, this.selectionCallback, Collections.singleton(viewpointFromName), Collections.emptySet(), (IProgressMonitor)new NullProgressMonitor());
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeSiriussSelection);
            activatedViewpoint = true;
            break;
        }
        if (!activatedViewpoint) {
            for (Viewpoint viewpoint : ViewpointRegistry.getInstance().getViewpoints()) {
                if (!name.equals(viewpoint.getName())) continue;
                viewpointFromName = this.getViewpointFromName(name, this.session);
                if (viewpointFromName == null) {
                    this.viewpoints.add(viewpoint);
                    viewpointFromName = this.getViewpointFromName(name, this.session);
                }
                changeSiriussSelection = new ChangeViewpointSelectionCommand(this.session, this.selectionCallback, Collections.singleton(viewpointFromName), Collections.emptySet(), (IProgressMonitor)new NullProgressMonitor());
                this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeSiriussSelection);
                activatedViewpoint = true;
                break;
            }
        }
    }

    protected final void deactivateViewpoint(String name) {
        ChangeViewpointSelectionCommand changeSiriussSelection;
        Viewpoint viewpointFromName;
        boolean deactivatedViewpoint = false;
        for (Viewpoint viewpoint : this.viewpoints) {
            if (!name.equals(viewpoint.getName())) continue;
            viewpointFromName = this.getViewpointFromName(name, this.session);
            changeSiriussSelection = new ChangeViewpointSelectionCommand(this.session, this.selectionCallback, Collections.emptySet(), Collections.singleton(viewpointFromName), (IProgressMonitor)new NullProgressMonitor());
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeSiriussSelection);
            deactivatedViewpoint = true;
            break;
        }
        if (!deactivatedViewpoint) {
            for (Viewpoint viewpoint : ViewpointRegistry.getInstance().getViewpoints()) {
                if (!name.equals(viewpoint.getName())) continue;
                viewpointFromName = this.getViewpointFromName(name, this.session);
                changeSiriussSelection = new ChangeViewpointSelectionCommand(this.session, this.selectionCallback, Collections.emptySet(), Collections.singleton(viewpointFromName), (IProgressMonitor)new NullProgressMonitor());
                this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeSiriussSelection);
                deactivatedViewpoint = true;
                break;
            }
        }
    }

    protected final DRepresentation createRepresentation(String representationDescriptionName) {
        return this.createRepresentation(representationDescriptionName, representationDescriptionName, this.semanticModel, this.session);
    }

    protected final DRepresentation createRepresentation(String representationDescriptionName, EObject semantic) {
        return this.createRepresentation(representationDescriptionName, representationDescriptionName, semantic, this.session);
    }

    protected final DRepresentation createRepresentation(String representationDescriptionName, EObject semantic, Session sessionToUse) {
        return this.createRepresentation(representationDescriptionName, representationDescriptionName, semantic, sessionToUse);
    }

    protected final DRepresentation createRepresentation(String representationDescriptionName, String name, EObject semantic) {
        return this.createRepresentation(representationDescriptionName, representationDescriptionName, semantic, this.session);
    }

    protected final DRepresentation createRepresentation(final String representationDescriptionName, final String name, final EObject semantic, final Session sessionToUse) {
        final ArrayList descriptions = new ArrayList();
        descriptions.addAll(DialectManager.INSTANCE.getAvailableRepresentationDescriptions(this.viewpoints, semantic));
        RecordingCommand cmd = new RecordingCommand(sessionToUse.getTransactionalEditingDomain()){
            private DRepresentation representation;

            protected void doExecute() {
                for (RepresentationDescription description : descriptions) {
                    if (!description.getName().equals(representationDescriptionName)) continue;
                    Viewpoint viewpointOfRegistry = (Viewpoint)description.eContainer();
                    Viewpoint localViewpoint = SiriusTestCase.this.getViewpointFromName(viewpointOfRegistry.getName());
                    RepresentationDescription localDescription = SiriusTestCase.this.getLocalSessionRepresentationDescription(localViewpoint, representationDescriptionName);
                    this.representation = DialectManager.INSTANCE.createRepresentation(name, semantic, localDescription, sessionToUse, (IProgressMonitor)new NullProgressMonitor());
                    return;
                }
            }

            public Collection<?> getResult() {
                return Collections.singletonList(this.representation);
            }
        };
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)semantic);
        domain.getCommandStack().execute((Command)cmd);
        return (DRepresentation)cmd.getResult().iterator().next();
    }

    private RepresentationDescription getLocalSessionRepresentationDescription(Viewpoint localViewpoint, String representationDescriptionName) {
        Iterable candidates = new ViewpointQuery(localViewpoint).getAllRepresentationDescriptions();
        RepresentationDescription result = null;
        for (RepresentationDescription localDescription : candidates) {
            if (!representationDescriptionName.equals(localDescription.getName())) continue;
            result = localDescription;
            break;
        }
        return result;
    }

    public Viewpoint getViewpointFromName(String viewpointName) {
        return this.getViewpointFromName(viewpointName, this.session);
    }

    public Viewpoint getViewpointFromName(String viewpointName, Session sessionToUse) {
        Viewpoint localViewpoint = null;
        block0: for (Viewpoint viewpoint : this.viewpoints) {
            if (viewpoint.eResource() == null || viewpoint.getName() == null || !viewpoint.getName().equals(viewpointName)) continue;
            URI viewpointResourceURI = viewpoint.eResource().getURI();
            Resource newViewpointResource = sessionToUse.getTransactionalEditingDomain().getResourceSet().getResource(viewpointResourceURI, true);
            if (newViewpointResource.getContents().isEmpty() || !(newViewpointResource.getContents().get(0) instanceof Group)) break;
            Group group = (Group)newViewpointResource.getContents().get(0);
            Iterator iter = group.getOwnedViewpoints().iterator();
            while (iter.hasNext() && localViewpoint == null) {
                Viewpoint someLocalViewpoint = (Viewpoint)iter.next();
                if (someLocalViewpoint.getName() == null || !someLocalViewpoint.getName().equals(viewpointName)) continue;
                localViewpoint = someLocalViewpoint;
                break block0;
            }
            break block0;
        }
        return localViewpoint;
    }

    public RepresentationDescription getRepresentationDescription(String representationDescriptionName, Viewpoint viewpoint) {
        RepresentationDescription result = null;
        for (RepresentationDescription ownedRepresentationDescription : viewpoint.getOwnedRepresentations()) {
            if (!representationDescriptionName.equals(ownedRepresentationDescription.getName())) continue;
            result = ownedRepresentationDescription;
            break;
        }
        return result;
    }

    protected final Collection<DRepresentation> getRepresentations(String representationDescriptionName) {
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(this.session);
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        for (DRepresentation representation : allRepresentations) {
            RepresentationDescription desc = DialectManager.INSTANCE.getDescription(representation);
            if (!representationDescriptionName.equals(desc.getName())) continue;
            representations.add(representation);
        }
        return representations;
    }

    protected final Collection<DRepresentationDescriptor> getRepresentationDescriptors(String representationDescriptionName) {
        return this.getRepresentationDescriptors(representationDescriptionName, this.session);
    }

    protected final Collection<DRepresentation> getRepresentations(String name, Session alternateSession) {
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(alternateSession);
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        for (DRepresentation representation : allRepresentations) {
            RepresentationDescription desc = DialectManager.INSTANCE.getDescription(representation);
            if (!name.equals(desc.getName())) continue;
            representations.add(representation);
        }
        return representations;
    }

    protected final Collection<DRepresentationDescriptor> getRepresentationDescriptors(String representationDescriptionName, Session alternateSession) {
        Collection allRepDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(alternateSession);
        HashSet<DRepresentationDescriptor> repDescriptors = new HashSet<DRepresentationDescriptor>();
        for (DRepresentationDescriptor repDescriptor : allRepDescriptors) {
            RepresentationDescription desc = repDescriptor.getDescription();
            if (!representationDescriptionName.equals(desc.getName())) continue;
            repDescriptors.add(repDescriptor);
        }
        return repDescriptors;
    }

    protected final Collection<DRepresentation> getRepresentations(String name, EObject semantic, Session alternateSession) {
        Collection allRepresentations = DialectManager.INSTANCE.getRepresentations(semantic, alternateSession);
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        for (DRepresentation representation : allRepresentations) {
            RepresentationDescription desc = DialectManager.INSTANCE.getDescription(representation);
            if (!name.equals(desc.getName())) continue;
            representations.add(representation);
        }
        return representations;
    }

    protected final Collection<DRepresentation> getRepresentations(String name, EObject semantic) {
        Collection allRepresentations = DialectManager.INSTANCE.getRepresentations(semantic, this.session);
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        for (DRepresentation representation : allRepresentations) {
            RepresentationDescription desc = DialectManager.INSTANCE.getDescription(representation);
            if (!name.equals(desc.getName())) continue;
            representations.add(representation);
        }
        return representations;
    }

    protected void refresh(DRepresentation representation) {
        this.refresh(representation, false);
    }

    protected void refresh(DRepresentation representation, boolean fullRefresh) {
        RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed(representation);
        TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
        RefreshRepresentationsCommand command = new RefreshRepresentationsCommand(domain, fullRefresh, (IProgressMonitor)new NullProgressMonitor(), new DRepresentation[]{representation});
        command.setLabel("refresh from testcase");
        domain.getCommandStack().execute((Command)command);
    }

    protected final DRepresentationElement getFirstRepresentationElement(DRepresentation representation, EObject semanticElement) {
        for (DRepresentationElement element : representation.getRepresentationElements()) {
            if (element.getTarget() != semanticElement) continue;
            return element;
        }
        return null;
    }

    protected final <T> T getFirstRepresentationElement(DRepresentation representation, EObject semanticElement, Class<T> clazz) {
        for (DRepresentationElement element : representation.getRepresentationElements()) {
            if (!clazz.isInstance(element) || element.getTarget() != semanticElement) continue;
            return (T)element;
        }
        return null;
    }

    protected final Collection<DRepresentationElement> getAllRepresentationElements(DRepresentation representation, EObject semanticElement) {
        HashSet<DRepresentationElement> elements = new HashSet<DRepresentationElement>();
        for (DRepresentationElement element : representation.getRepresentationElements()) {
            if (element.getTarget() != semanticElement) continue;
            elements.add(element);
        }
        return elements;
    }

    protected boolean executeCommand(Command cmd) {
        boolean result = cmd.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute(cmd);
        return result;
    }

    protected void cleanWorkspace() {
        for (IProject proj : Lists.newArrayList((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects())) {
            EclipseTestsSupportHelper.INSTANCE.deleteProject(proj.getName());
        }
    }

    protected void copyFilesToTestProject(String pluginID, String pluginCommonPath, String ... filePaths) {
        EclipseTestsSupportHelper.INSTANCE.createProject(TEMPORARY_PROJECT_NAME);
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String pluginFilePath = String.valueOf(pluginCommonPath) + path;
            String wksPath = "DesignerTestProject/" + path;
            EclipseTestsSupportHelper.INSTANCE.copyFile(pluginID, pluginFilePath, wksPath);
            ++n2;
        }
    }

    protected void copyFiles(String pluginID, String pluginCommonPath, String targetPath, String ... filePaths) {
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String pluginFilePath = String.valueOf(pluginCommonPath) + path;
            String wksPath = String.valueOf(targetPath) + File.separator + path;
            EclipseTestsSupportHelper.INSTANCE.copyFile(pluginID, pluginFilePath, wksPath);
            ++n2;
        }
    }

    protected void closeSession(Session sessionToClose) {
        if (sessionToClose != null) {
            IEditingSession sessionUI = SessionUIManager.INSTANCE.getUISession(sessionToClose);
            if (sessionUI != null) {
                SessionUIManager.INSTANCE.remove(sessionUI);
                sessionUI.close();
                TestsUtil.synchronizationWithUIThread();
            }
            sessionToClose.close((IProgressMonitor)new NullProgressMonitor());
            TestsUtil.synchronizationWithUIThread();
            for (Session s : SessionManager.INSTANCE.getSessions()) {
                Assert.assertFalse((String)"Remove failed", (boolean)s.equals(sessionToClose));
            }
            if (sessionToClose.isOpen()) {
                sessionToClose.close((IProgressMonitor)new NullProgressMonitor());
                TestsUtil.synchronizationWithUIThread();
            }
        }
    }

    protected void closeAndReloadSession() throws Exception {
        Resource resource;
        URI sessionResourceURI = this.session.getSessionResource().getURI();
        TestsUtil.synchronizationWithUIThread();
        this.closeSession(this.session);
        TestsUtil.synchronizationWithUIThread();
        this.session = SessionManager.INSTANCE.getSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        if (!this.session.isOpen()) {
            this.session.open((IProgressMonitor)new NullProgressMonitor());
        }
        SessionUIManager.INSTANCE.getOrCreateUISession(this.session).open();
        TestsUtil.synchronizationWithUIThread();
        Assert.assertNotNull((Object)this.session);
        this.interpreter = this.session.getInterpreter();
        if (!this.session.getSemanticResources().isEmpty() && (resource = (Resource)this.session.getSemanticResources().iterator().next()).getContents() != null && !resource.getContents().isEmpty()) {
            this.semanticModel = (EObject)resource.getContents().get(0);
            this.accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(this.semanticModel);
        }
    }

    protected void changeDiagramPreference(String preferenceKey, Integer newValue) {
        this.assertNoDiagramUIPreferenceChangedinDiagramCoreStore(preferenceKey);
        int oldValue = Platform.getPreferencesService().getInt("org.eclipse.sirius.diagram", preferenceKey, 0, null);
        this.oldValueDiagramPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        diagramCorePreferences.putInt(preferenceKey, newValue.intValue());
        int valueToCheck = Platform.getPreferencesService().getInt("org.eclipse.sirius.diagram", preferenceKey, 0, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius.diagram"), (int)newValue, (int)valueToCheck);
    }

    protected void changeDiagramPreference(String preferenceKey, Boolean newValue) {
        this.assertNoDiagramUIPreferenceChangedinDiagramCoreStore(preferenceKey);
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        this.oldValueDiagramPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        diagramCorePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius.diagram"), (boolean)newValue, (boolean)valueToCheck);
    }

    protected void resetDiagramPreference(String preferenceKey) {
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        this.resetDiagramPreference(preferenceKey, diagramCorePreferences);
    }

    private void resetDiagramPreference(String preferenceKey, IEclipsePreferences diagramCorePreferences) {
        Object initialValue = this.oldValueDiagramPreferences.get(preferenceKey);
        if (initialValue instanceof Boolean) {
            diagramCorePreferences.putBoolean(preferenceKey, ((Boolean)initialValue).booleanValue());
        } else if (initialValue instanceof Integer) {
            diagramCorePreferences.putInt(preferenceKey, ((Integer)initialValue).intValue());
        }
    }

    protected void changeDiagramUIPreference(String preferenceKey, Integer newValue) {
        this.assertNoDiagramCorePreferenceChangedinDiagramUIStore(preferenceKey);
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.oldValueDiagramUiPreferences.put(preferenceKey, prefs.getInt(preferenceKey));
        prefs.setValue(preferenceKey, newValue.intValue());
    }

    protected void changeDiagramUIPreference(String preferenceKey, Boolean newValue) {
        this.assertNoDiagramCorePreferenceChangedinDiagramUIStore(preferenceKey);
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.oldValueDiagramUiPreferences.put(preferenceKey, prefs.getBoolean(preferenceKey));
        prefs.setValue(preferenceKey, newValue.booleanValue());
    }

    protected void resetDiagramUiPreference(String preferenceKey) {
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.resetDiagramUiPreference(preferenceKey, prefs);
    }

    private void resetDiagramUiPreference(String preferenceKey, IPreferenceStore diagramUIPreferences) {
        Object initialValue = this.oldValueDiagramUiPreferences.get(preferenceKey);
        if (initialValue instanceof Boolean) {
            diagramUIPreferences.setValue(preferenceKey, ((Boolean)initialValue).booleanValue());
        } else if (initialValue instanceof Integer) {
            diagramUIPreferences.setValue(preferenceKey, ((Integer)initialValue).intValue());
        }
    }

    protected void changePlatformUIPreference(String preferenceKey, Boolean newValue) {
        IPreferenceStore platformUIPrefs = PlatformUI.getPreferenceStore();
        this.oldPlatformUIPreferences.put(preferenceKey, platformUIPrefs.getBoolean(preferenceKey));
        platformUIPrefs.setValue(preferenceKey, newValue.booleanValue());
    }

    protected void changeSiriusPreference(String preferenceKey, Boolean newValue) {
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", preferenceKey, false, null);
        this.oldValueSiriusPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences corePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
        corePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius"), (boolean)newValue, (boolean)valueToCheck);
    }

    protected void changeSiriusUIPreference(String preferenceKey, Boolean newValue) {
        this.assertNoSiriusCorePreferenceChangedinSiriusUIStore(preferenceKey);
        IPreferenceStore viewpointUIPrefs = SiriusEditPlugin.getPlugin().getPreferenceStore();
        this.oldValueSiriusUIPreferences.put(preferenceKey, viewpointUIPrefs.getBoolean(preferenceKey));
        viewpointUIPrefs.setValue(preferenceKey, newValue.booleanValue());
    }

    private void assertNoSiriusCorePreferenceChangedinSiriusUIStore(String preferenceKey) {
        ArrayList coreKeys = Lists.newArrayList((Object[])SiriusPreferencesKeys.values());
        Function<SiriusPreferencesKeys, String> prefToName = new Function<SiriusPreferencesKeys, String>(){

            public String apply(SiriusPreferencesKeys input) {
                return input.name();
            }
        };
        TestCase.assertFalse((String)("The DesignerPreferenceKey named " + preferenceKey + " should not be modified in the UI store."), (boolean)Lists.newArrayList((Iterable)Iterables.transform((Iterable)coreKeys, (Function)prefToName)).contains(preferenceKey));
    }

    private void assertNoDiagramCorePreferenceChangedinDiagramUIStore(String preferenceKey) {
        SiriusDiagramInternalPreferencesKeys key;
        ArrayList coreKeys = Lists.newArrayList();
        SiriusDiagramInternalPreferencesKeys[] siriusDiagramInternalPreferencesKeysArray = SiriusDiagramInternalPreferencesKeys.values();
        int n = siriusDiagramInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        siriusDiagramInternalPreferencesKeysArray = SiriusDiagramPreferencesKeys.values();
        n = siriusDiagramInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        coreKeys.add("Viewpoint.Connectors.enableOverride");
        coreKeys.add("Viewpoint.Connectors.lineStyle");
        SiriusTestCase.assertFalse((String)("The Diagram core preference named " + preferenceKey + " should not be modified in the Diagram UI store."), (boolean)coreKeys.contains(preferenceKey));
    }

    private void assertNoDiagramUIPreferenceChangedinDiagramCoreStore(String preferenceKey) {
        SiriusDiagramUiInternalPreferencesKeys key;
        ArrayList uiKeys = Lists.newArrayList();
        SiriusDiagramUiInternalPreferencesKeys[] siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiInternalPreferencesKeys.values();
        int n = siriusDiagramUiInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiPreferencesKeys.values();
        n = siriusDiagramUiInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        SiriusTestCase.assertFalse((String)("The Diagram UI preference named " + preferenceKey + " should not be modified in the Diagram core store."), (boolean)uiKeys.contains(preferenceKey));
    }

    private String getErrorMessage(String preferenceKey, String pluginId) {
        return "The " + preferenceKey + " preference value was not changed for plugin " + pluginId;
    }

    private void cleanCurrentSession() {
        if (this.session != null) {
            IEditingSession sessionUI = SessionUIManager.INSTANCE.getUISession(this.session);
            if (sessionUI != null) {
                SessionUIManager.INSTANCE.remove(sessionUI);
                sessionUI.close();
                TestsUtil.synchronizationWithUIThread();
            }
            if (this.session.isOpen()) {
                if (!TestsUtil.shouldSkipUnreliableTests()) {
                    this.session.close((IProgressMonitor)new NullProgressMonitor());
                } else {
                    try {
                        this.session.close((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
                TestsUtil.synchronizationWithUIThread();
            }
            this.session = null;
        }
    }

    private void closeAllSessions() {
        for (Session managerSession : Lists.newArrayList((Iterable)SessionManager.INSTANCE.getSessions())) {
            if (!managerSession.isOpen()) continue;
            managerSession.close((IProgressMonitor)new NullProgressMonitor());
            TestsUtil.synchronizationWithUIThread();
        }
    }

    protected boolean undo() throws Exception {
        CommandStack commandStack = this.session.getTransactionalEditingDomain().getCommandStack();
        boolean result = commandStack.canUndo();
        if (result) {
            commandStack.undo();
        }
        return result;
    }

    protected boolean redo() throws Exception {
        CommandStack commandStack = this.session.getTransactionalEditingDomain().getCommandStack();
        boolean result = commandStack.canRedo();
        if (result) {
            commandStack.redo();
        }
        return result;
    }

    protected void tearDown() throws Exception {
        CrossReferenceAdapterDetector crossRefDetector = new CrossReferenceAdapterDetector();
        this.createModelingProject = false;
        this.setErrorCatchActive(false);
        this.setWarningCatchActive(false);
        TransactionalEditingDomain domain = null;
        if (this.session != null) {
            domain = this.session.getTransactionalEditingDomain();
            this.cleanCurrentSession();
        }
        crossRefDetector.checkNoCrossReferenceAdapter();
        this.closeAllSessions();
        TestsUtil.emptyEventsFromUIThread();
        if (domain != null) {
            LinkedHashSet groups = Sets.newLinkedHashSet();
            for (Viewpoint vp : this.viewpoints) {
                if (!(vp.eContainer() instanceof Group)) continue;
                groups.add((Group)vp.eContainer());
            }
            for (Resource resource : Lists.newArrayList((Iterable)domain.getResourceSet().getResources())) {
                resource.unload();
            }
            for (Group modelerModele : groups) {
                domain.getResourceSet().getResources().remove((Object)modelerModele.eResource());
            }
            domain.getResourceSet().getResources().clear();
            if (domain.getCommandStack() != null) {
                domain.getCommandStack().flush();
            }
            try {
                domain.dispose();
            }
            catch (Exception exception) {}
        }
        TestsUtil.synchronizationWithUIThread();
        this.viewpoints.clear();
        this.cleanWorkspace();
        this.disposeLoggers();
        TestsUtil.emptyEventsFromUIThread();
        IEclipsePreferences diagamCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        for (String key : this.oldValueDiagramPreferences.keySet()) {
            this.resetDiagramPreference(key, diagamCorePreferences);
        }
        IPreferenceStore diagramUIPreferences = DiagramUIPlugin.getPlugin().getPreferenceStore();
        for (String key : this.oldValueDiagramUiPreferences.keySet()) {
            this.resetDiagramUiPreference(key, diagramUIPreferences);
        }
        IEclipsePreferences corePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
        for (Map.Entry<String, Object> pref : this.oldValueSiriusPreferences.entrySet()) {
            corePreferences.putBoolean(pref.getKey(), ((Boolean)pref.getValue()).booleanValue());
        }
        IPreferenceStore viewpointUIPrefs = SiriusEditPlugin.getPlugin().getPreferenceStore();
        for (Map.Entry<String, Object> pref : this.oldValueSiriusUIPreferences.entrySet()) {
            viewpointUIPrefs.setValue(pref.getKey(), ((Boolean)pref.getValue()).booleanValue());
        }
        IPreferenceStore platformUIPrefs = PlatformUI.getPreferenceStore();
        for (Map.Entry<String, Object> pref : this.oldPlatformUIPreferences.entrySet()) {
            platformUIPrefs.setValue(pref.getKey(), ((Boolean)pref.getValue()).booleanValue());
        }
        crossRefDetector.assertNoCrossReferenceAdapterFound();
        this.checkLogs();
        new TestCaseCleaner(this).clearAllFields();
        super.tearDown();
    }

    protected void disableUICallBackOnDialectEditor(DialectEditor editor) {
        editor.setDialogFactory((DialectEditorDialogFactory)new DummyDialectEditorDialogFactory());
    }

    protected Option<Viewpoint> findViewpoint(String name) {
        for (Viewpoint vp : ViewpointRegistry.getInstance().getViewpoints()) {
            if (!vp.getName().equals(name)) continue;
            return Options.newSome((Object)vp);
        }
        return Options.newNone();
    }

    protected List<Resource> getResourceTypeAirdOrEcore(ResourceSet rs) {
        ArrayList<Resource> resourcesAirdAndEcore = new ArrayList<Resource>();
        for (Resource resource : rs.getResources()) {
            if (resource instanceof AirdResource) {
                resourcesAirdAndEcore.add(resource);
                continue;
            }
            if (!"ecore".equals(resource.getURI().fileExtension())) continue;
            resourcesAirdAndEcore.add(resource);
        }
        return resourcesAirdAndEcore;
    }

    protected Version checkRepresentationFileMigrationStatus(URI representationFileURI, boolean needsMigration) {
        RepresentationsFileVersionSAXParser parser = new RepresentationsFileVersionSAXParser(representationFileURI);
        return this.checkMigrationStatusOnData(representationFileURI, (AbstractVersionSAXParser)parser, (AbstractSiriusMigrationService)RepresentationsFileMigrationService.getInstance(), needsMigration);
    }

    protected Version checkVsmFileMigrationStatus(URI vsmFileURI, boolean needsMigration) {
        VSMVersionSAXParser parser = new VSMVersionSAXParser(vsmFileURI);
        return this.checkMigrationStatusOnData(vsmFileURI, (AbstractVersionSAXParser)parser, (AbstractSiriusMigrationService)VSMMigrationService.getInstance(), needsMigration);
    }

    private Version checkMigrationStatusOnData(URI fileURI, AbstractVersionSAXParser versionSaxPArser, AbstractSiriusMigrationService migrationService, boolean needsMigration) {
        String sLoadedVersion = versionSaxPArser.getVersion((IProgressMonitor)new NullProgressMonitor());
        Version loadedVersion = Version.parseVersion((String)sLoadedVersion);
        TestCase.assertNotNull((String)("The parsed version is null, check the file: " + fileURI.toPlatformString(true)), (Object)loadedVersion);
        boolean migrationIsNeeded = migrationService.isMigrationNeeded(loadedVersion);
        if (needsMigration) {
            TestCase.assertTrue((String)("The current test case checks a migration behavior, please revert the manual migration on : " + fileURI.toPlatformString(true)), (boolean)migrationIsNeeded);
        } else {
            TestCase.assertFalse((String)("The current test case expect a file which does not need migration : " + fileURI.toPlatformString(true)), (boolean)migrationIsNeeded);
        }
        return loadedVersion;
    }

    public static enum ResourceURIType {
        RESOURCE_PLATFORM_URI,
        RESOURCE_PLUGIN_URI;

    }
}

