/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.faultTreeViewer.layouts;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import eu.fbk.eclipse.standardtools.faultTreeViewer.connectors.FTADiagramLayoutConnector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.elk.conn.gmf.GmfLayoutConfigurationStore;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.elk.core.service.ILayoutSetup;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.ui.IEditorPart;

public class FTALayoutSetup
implements ILayoutSetup {
    public boolean supports(Object object) {
        return this.isSiriusDiagramEditor(object);
    }

    protected boolean isSiriusDiagramEditor(Object object) {
        if (object == null) {
            return false;
        }
        IEditorPart activeEditor = (IEditorPart)Platform.getAdapterManager().getAdapter(object, IEditorPart.class);
        return activeEditor instanceof DDiagramEditor;
    }

    public Injector createInjector(Module defaultModule) {
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{defaultModule}).with(new Module[]{new FTALayoutModule()})});
    }

    public static class FTALayoutModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(IDiagramLayoutConnector.class).to(FTADiagramLayoutConnector.class);
            binder.bind(ILayoutConfigurationStore.Provider.class).to(GmfLayoutConfigurationStore.Provider.class);
        }
    }
}

