/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.faultTreeViewer.commands;

import eu.fbk.eclipse.standardtools.faultTreeViewer.utils.FaultTreeViewerUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ShowFaultTreeFromFTAResourceCommand
extends AbstractHandler {
    private DialogUtil dialogUtil = DialogUtil.getInstance();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final String ftaModelPath = event.getParameter("ftaModelPath");
        Job job = new Job("Show Diagram from .xml file"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("open FTAViewer from .xml file", 1);
                try {
                    URI ftaResourceFileURI = URI.createPlatformResourceURI((String)ftaModelPath, (boolean)true);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource ftaResource = resourceSet.getResource(ftaResourceFileURI, true);
                    FaultTreeViewerUtil.getInstance().openFTAViewerFromFTAResource(ftaResource, monitor);
                }
                catch (Exception e) {
                    ShowFaultTreeFromFTAResourceCommand.this.dialogUtil.showMessage_ExceptionError(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

