/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.ui.utils.editor.embedded;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.editor.embedded.EmbeddedEditorActions;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.embedded.OperationHistoryListener;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingHelper;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class EmbeddedEditorFactory {
    @Inject
    private Provider<Builder> builderProvider;

    public Builder newEditor(IEditedResourceProvider resourceProvider) {
        if (resourceProvider == null) {
            throw new IllegalArgumentException("resourceProvider may not be null");
        }
        Builder result = (Builder)this.getBuilderProvider().get();
        result.setResourceProvider(resourceProvider);
        return result;
    }

    protected Provider<Builder> getBuilderProvider() {
        return this.builderProvider;
    }

    public void setBuilderProvider(Provider<Builder> builderProvider) {
        this.builderProvider = builderProvider;
    }

    public static class Builder {
        protected static final int VERTICAL_RULER_WIDTH = 12;
        @Inject
        protected XtextSourceViewer.Factory sourceViewerFactory;
        @Inject
        protected Provider<XtextSourceViewerConfiguration> sourceViewerConfigurationProvider;
        @Inject
        protected Provider<XtextDocument> documentProvider;
        @Inject
        protected Provider<IDocumentPartitioner> documentPartitionerProvider;
        @Inject
        protected IResourceValidator resourceValidator;
        @Inject
        protected IPreferenceStoreAccess preferenceStoreAccess;
        @Inject
        protected IssueResolutionProvider issueResolutionProvider;
        @Inject
        protected ICharacterPairMatcher characterPairMatcher;
        @Inject
        protected EmbeddedEditorActions.Factory actionFactory;
        @Inject
        protected HighlightingHelper highlightingHelper;
        protected IEditedResourceProvider resourceProvider;
        protected String[] annotationTypes;
        protected Boolean readonly;
        protected boolean editorBuild;
        protected IValidationIssueProcessor issueProcessor;

        public Builder showErrorAndWarningAnnotations() {
            return this.showAnnotations("org.eclipse.xtext.ui.editor.error", "org.eclipse.xtext.ui.editor.warning");
        }

        public Builder showAnnotations(String ... annotationTypes) {
            if (this.annotationTypes != null) {
                throw new IllegalStateException();
            }
            if (annotationTypes == null) {
                throw new IllegalArgumentException();
            }
            this.annotationTypes = annotationTypes;
            return this;
        }

        public Builder processIssuesBy(IValidationIssueProcessor issueProcessor) {
            if (this.issueProcessor != null) {
                throw new IllegalStateException();
            }
            if (issueProcessor == null) {
                throw new IllegalArgumentException();
            }
            this.issueProcessor = issueProcessor;
            return this;
        }

        public Builder readOnly() {
            if (this.readonly != null) {
                throw new IllegalStateException();
            }
            this.readonly = true;
            return this;
        }

        public Builder withResourceValidator(IResourceValidator resourceValidator) {
            this.resourceValidator = resourceValidator;
            return this;
        }

        public EmbeddedEditor withParent(final Composite parent) {
            if (this.editorBuild) {
                throw new IllegalStateException();
            }
            this.editorBuild = true;
            final CompositeRuler annotationRuler = this.annotationTypes != null && this.annotationTypes.length != 0 ? new CompositeRuler() : null;
            final XtextSourceViewer viewer = this.sourceViewerFactory.createSourceViewer(parent, (IVerticalRuler)annotationRuler, null, false, 2560);
            final XtextSourceViewerConfiguration viewerConfiguration = (XtextSourceViewerConfiguration)this.sourceViewerConfigurationProvider.get();
            viewer.configure((SourceViewerConfiguration)viewerConfiguration);
            final SourceViewerDecorationSupport viewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(){

                public int getLayer(Annotation annotation) {
                    if (annotation.isMarkedDeleted()) {
                        return 0;
                    }
                    return super.getLayer(annotation);
                }
            }, this.getSharedColors());
            MarkerAnnotationPreferences annotationPreferences = new MarkerAnnotationPreferences();
            UnmodifiableIterator e = Iterators.filter(annotationPreferences.getAnnotationPreferences().iterator(), AnnotationPreference.class);
            while (e.hasNext()) {
                viewerDecorationSupport.setAnnotationPreference((AnnotationPreference)e.next());
            }
            if (this.characterPairMatcher != null) {
                viewerDecorationSupport.setCharacterPairMatcher(this.characterPairMatcher);
                viewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("CharacterMatching", "CharacterMatching.Color");
            }
            viewerDecorationSupport.install(this.preferenceStoreAccess.getPreferenceStore());
            final XtextDocument document = (XtextDocument)this.documentProvider.get();
            IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitionerProvider.get();
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner(partitioner);
            final EmbeddedEditorActions actions = this.initializeActions((SourceViewer)viewer);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    viewerDecorationSupport.dispose();
                    highlightingHelper.uninstall();
                }
            });
            EmbeddedEditor result = new EmbeddedEditor(document, viewer, viewerConfiguration, this.resourceProvider, new Runnable(){

                @Override
                public void run() {
                    this.afterCreatePartialEditor(viewer, document, annotationRuler, actions);
                    highlightingHelper.install(viewerConfiguration, viewer);
                }
            });
            viewer.setEditable(!Boolean.TRUE.equals(this.readonly));
            viewer.getContentAssistantFacade().addCompletionListener(new ICompletionListener(){
                private Button defaultButton;

                public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                }

                public void assistSessionStarted(ContentAssistEvent event) {
                    this.defaultButton = parent.getShell().getDefaultButton();
                    parent.getShell().setDefaultButton(null);
                }

                public void assistSessionEnded(ContentAssistEvent event) {
                    parent.getShell().setDefaultButton(this.defaultButton);
                    this.defaultButton = null;
                }
            });
            ValidationJob job = new ValidationJob(this.resourceValidator, (IReadAccess)document, new IValidationIssueProcessor(){
                private AnnotationIssueProcessor annotationIssueProcessor;

                public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
                    IAnnotationModel annotationModel;
                    IValidationIssueProcessor issueProcessor = issueProcessor;
                    if (issueProcessor != null) {
                        issueProcessor.processIssues(issues, monitor);
                    }
                    if ((annotationModel = viewer.getAnnotationModel()) != null) {
                        if (this.annotationIssueProcessor == null) {
                            this.annotationIssueProcessor = new AnnotationIssueProcessor((IXtextDocument)document, annotationModel, new IssueResolutionProvider(){

                                public boolean hasResolutionFor(String issueCode) {
                                    return issueResolutionProvider.hasResolutionFor(issueCode);
                                }

                                public List<IssueResolution> getResolutions(Issue issue) {
                                    List resolutions = issueResolutionProvider.getResolutions(issue);
                                    List result = Lists.transform((List)resolutions, (Function)new Function<IssueResolution, IssueResolution>(){

                                        public IssueResolution apply(final IssueResolution input) {
                                            IssueResolution result = new IssueResolution(input.getLabel(), input.getDescription(), input.getImage(), new IModificationContext(){

                                                public IXtextDocument getXtextDocument(URI uri) {
                                                    if (uri.trimFragment().equals(document.getResourceURI())) {
                                                        return document;
                                                    }
                                                    return input.getModificationContext().getXtextDocument(uri);
                                                }

                                                public IXtextDocument getXtextDocument() {
                                                    IModificationContext original = input.getModificationContext();
                                                    if (original instanceof IssueModificationContext) {
                                                        URI uri = ((IssueModificationContext)original).getIssue().getUriToProblem();
                                                        return this.getXtextDocument(uri);
                                                    }
                                                    return original.getXtextDocument();
                                                }
                                            }, input.getModification());
                                            return result;
                                        }
                                    });
                                    return result;
                                }
                            });
                        }
                        if (this.annotationIssueProcessor != null) {
                            this.annotationIssueProcessor.processIssues(issues, monitor);
                        }
                    }
                }
            }, CheckMode.FAST_ONLY);
            document.setValidationJob((Job)job);
            Control control = viewer.getControl();
            GridData data = new GridData(4, 4, true, true);
            control.setLayoutData((Object)data);
            return result;
        }

        protected void afterCreatePartialEditor(XtextSourceViewer viewer, XtextDocument document, CompositeRuler verticalRuler, final EmbeddedEditorActions actions) {
            if (verticalRuler != null && this.annotationTypes != null && this.annotationTypes.length > 0) {
                AnnotationRulerColumn annotationRulerColumn = new AnnotationRulerColumn(viewer.getAnnotationModel(), 12, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(){

                    public int getLayer(Annotation annotation) {
                        if (annotation.isMarkedDeleted()) {
                            return 0;
                        }
                        return super.getLayer(annotation);
                    }
                });
                String[] stringArray = this.annotationTypes;
                int n = this.annotationTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String annotationType = stringArray[n2];
                    annotationRulerColumn.addAnnotationType((Object)annotationType);
                    ++n2;
                }
                verticalRuler.addDecorator(1, (IVerticalRulerColumn)annotationRulerColumn);
            }
            final OperationHistoryListener listener = this.installUndoRedoSupport((SourceViewer)viewer, (IDocument)document, actions);
            viewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    this.uninstallUndoRedoSupport(listener);
                }
            });
            viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    if (event.getDocumentEvent() != null) {
                        actions.updateAllActions();
                    }
                }
            });
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    actions.updateSelectionDependentActions();
                }
            });
            viewer.getUndoManager().reset();
        }

        protected void updateUndoAction(EmbeddedEditorActions actions) {
            actions.updateAction(ITextEditorActionConstants.UNDO);
        }

        protected void uninstallUndoRedoSupport(OperationHistoryListener listener) {
            IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            operationHistory.removeOperationHistoryListener((IOperationHistoryListener)listener);
        }

        protected OperationHistoryListener installUndoRedoSupport(SourceViewer viewer, IDocument document, final EmbeddedEditorActions actions) {
            IDocumentUndoManager undoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
            IUndoContext context = undoManager.getUndoContext();
            IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            OperationHistoryListener operationHistoryListener = new OperationHistoryListener(context, new IUpdate(){

                public void update() {
                    actions.updateAction(ITextEditorActionConstants.REDO);
                    actions.updateAction(ITextEditorActionConstants.UNDO);
                }
            });
            operationHistory.addOperationHistoryListener((IOperationHistoryListener)operationHistoryListener);
            return operationHistoryListener;
        }

        protected void setResourceProvider(IEditedResourceProvider resourceProvider) {
            this.resourceProvider = resourceProvider;
        }

        protected ISharedTextColors getSharedColors() {
            return EditorsUI.getSharedTextColors();
        }

        protected EmbeddedEditorActions initializeActions(SourceViewer viewer) {
            return this.actionFactory.createActions((ISourceViewer)viewer);
        }
    }
}

