/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EcoreUtils;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomDurationObservationCreateCommand
extends EditElementCommand {
    public CustomDurationObservationCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        EditPart firstTarget = (EditPart)request.getParameter("FIRST_TARGET");
        EditPart secondTarget = (EditPart)request.getParameter("SECOND_TARGET");
        DurationObservation durationObservation = UMLFactory.eINSTANCE.createDurationObservation();
        NamedElement firstTargetElement = (NamedElement)((View)firstTarget.getModel()).getElement();
        NamedElement secondTargetElement = (NamedElement)((View)secondTarget.getModel()).getElement();
        Package containingPackage = EcoreUtils.getContaining(request.getContainer(), Package.class);
        if (containingPackage == null) {
            return CommandResult.newErrorCommandResult((String)"The container must be in a Package");
        }
        containingPackage.getPackagedElements().add((Object)durationObservation);
        durationObservation.getEvents().clear();
        durationObservation.getFirstEvents().clear();
        if (firstTargetElement == secondTargetElement) {
            durationObservation.getEvents().add((Object)firstTargetElement);
        } else {
            durationObservation.getEvents().add((Object)firstTargetElement);
            durationObservation.getEvents().add((Object)secondTargetElement);
            durationObservation.getFirstEvents().add((Object)Boolean.TRUE);
            durationObservation.getFirstEvents().add((Object)Boolean.FALSE);
        }
        request.setNewElement((EObject)durationObservation);
        return CommandResult.newOKCommandResult((Object)durationObservation);
    }
}

