/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.gui.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSConnectorImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSShapeImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagramImpl;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.Profile;
import org.polarsys.chess.core.natures.CHESSNature;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.internal.Activator;
import org.polarsys.chess.service.internal.service.CHESSService;
import org.polarsys.chess.service.internal.utils.CHESSInternalEditorUtils;

public class CHESSEditorUtils {
    public static PapyrusMultiDiagramEditor getCHESSEditor() {
        IEditorPart editor = CHESSInternalEditorUtils.getEditor();
        PapyrusMultiDiagramEditor r = null;
        if (editor != null && editor instanceof PapyrusMultiDiagramEditor && CHESSEditorUtils.isCHESSProject(editor)) {
            r = (PapyrusMultiDiagramEditor)editor;
        }
        return r;
    }

    public static Diagram getDiagram() {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        return (Diagram)editor.getAdapter(Diagram.class);
    }

    public static Diagram getDiagram(PapyrusMultiDiagramEditor editor) {
        EObject diagramEObj;
        Object model = editor.getISashWindowsContainer().getActiveSashWindowsPage().getRawModel();
        Diagram diagram = null;
        if (model instanceof PageRef && (diagramEObj = ((PageRef)model).getEmfPageIdentifier()) instanceof Diagram) {
            diagram = (Diagram)diagramEObj;
        }
        return diagram;
    }

    public static DiagramCommandStack getDiagramCommandStack() {
        try {
            Object stack = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getAdapter(CommandStack.class);
            return stack instanceof DiagramCommandStack ? (DiagramCommandStack)stack : null;
        }
        catch (Exception e) {
            Activator.error("Unexpected error", e);
            return null;
        }
    }

    public static DiagramEditPart getDiagramEditPart() {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        if (editor != null) {
            return (DiagramEditPart)editor.getAdapter(DiagramEditPart.class);
        }
        return null;
    }

    public static IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        DiagramEditPart diagramEP = CHESSEditorUtils.getDiagramEditPart();
        if (diagramEP != null) {
            return (IDiagramGraphicalViewer)diagramEP.getViewer();
        }
        return null;
    }

    public static DiagramStatus getDiagramStatus(PapyrusMultiDiagramEditor editor) {
        DiagramStatus ds = null;
        try {
            ServicesRegistry servicesRegistry = editor.getServicesRegistry();
            CHESSService cs = (CHESSService)servicesRegistry.getService(CHESSService.class);
            ds = cs.getDiagramStatus();
        }
        catch (ServiceException e) {
            Activator.error("CHESS service does not exist.", e);
        }
        catch (NullPointerException e) {
            Activator.error("DiagramStatus does not exist", e);
        }
        return ds;
    }

    public static DiagramStatus getDiagramStatus(ServicesRegistry registry) {
        DiagramStatus ds = null;
        try {
            CHESSService cs = (CHESSService)registry.getService(CHESSService.class);
            ds = cs.getDiagramStatus();
        }
        catch (ServiceException e) {
            Activator.error("CHESS service does not exist.", e);
        }
        catch (NullPointerException e) {
            Activator.error("DiagramStatus does not exist", e);
        }
        return ds;
    }

    public static boolean isCHESSProject(IEditorPart editor) {
        IEditorInput x = editor.getEditorInput();
        IProjectNature nature = null;
        IFile f = null;
        if (x instanceof URIEditorInput) {
            URIEditorInput input = (URIEditorInput)x;
            if (input.getURI().toPlatformString(true) == null) {
                if (CDOUtils.isCDOURI((URI)input.getURI())) {
                    CDOURIUtil.extractResourcePath((URI)input.getURI());
                    return true;
                }
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.chess.service", 2, "Unable to get platform string for resource URI, CHESSProject=false ", null));
                return false;
            }
            f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(input.getURI().toPlatformString(true)));
        } else if (x instanceof IFileEditorInput) {
            f = ((IFileEditorInput)x).getFile();
        }
        try {
            if (f != null) {
                nature = f.getProject().getNature(CHESSNature.NATURE_ID);
            }
        }
        catch (CoreException e) {
            System.err.println(e.getStackTrace());
        }
        return nature != null;
    }

    public static void reopenEditor(final IEditorPart editor, final Boolean save) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = editor.getEditorSite().getPage();
                IEditorInput input = editor.getEditorInput();
                page.closeEditor(editor, save.booleanValue());
                try {
                    page.openEditor(input, "org.eclipse.papyrus.infra.core.papyrusEditor", save.booleanValue());
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static MessageDialog showConfirmDialog(EditorPart editor, String dialogTitle, String dialogMessage) {
        MessageDialog md = new MessageDialog(editor.getSite().getShell(), dialogTitle, null, dialogMessage, 5, new String[]{"OK", "No", "Cancel"}, 0);
        md.setBlockOnOpen(true);
        return md;
    }

    public static void cleanAllDiagrams() {
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        if (editor == null) {
            return;
        }
        try {
            if (editor != null) {
                ServicesRegistry serviceRegistry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
                IPageManager pageMngr = (IPageManager)serviceRegistry.getService(IPageManager.class);
                TransactionalEditingDomain editingDom = (TransactionalEditingDomain)editor.getEditingDomain();
                ArrayList<View> viewToDelete = new ArrayList<View>();
                final HashMap<CSSDiagramImpl, ArrayList<View>> mapDiagramViews = new HashMap<CSSDiagramImpl, ArrayList<View>>();
                CSSShapeImpl shape = null;
                CSSConnectorImpl edge = null;
                for (Object page : pageMngr.allPages()) {
                    if (!(page instanceof CSSDiagramImpl)) continue;
                    CSSDiagramImpl diag = (CSSDiagramImpl)page;
                    viewToDelete = new ArrayList();
                    if (diag.getElement() != null && diag.getElement().eIsProxy() || diag.getElement() != null && diag.getElement() instanceof Profile) continue;
                    for (Object view : diag.getChildren()) {
                        if (view instanceof CSSShapeImpl && (shape = (CSSShapeImpl)view).getElement() != null && shape.getElement().eIsProxy()) {
                            viewToDelete.add((View)shape);
                        }
                        CHESSEditorUtils.checkNestedOrphanView((View)view, viewToDelete);
                    }
                    for (Object view : diag.getEdges()) {
                        if (!(view instanceof CSSConnectorImpl) || (edge = (CSSConnectorImpl)view).getElement() == null || !edge.getElement().eIsProxy()) continue;
                        viewToDelete.add((View)edge);
                    }
                    if (viewToDelete.isEmpty()) continue;
                    mapDiagramViews.put(diag, viewToDelete);
                }
                if (!mapDiagramViews.isEmpty()) {
                    editingDom.getCommandStack().execute((Command)new RecordingCommand(editingDom){

                        protected void doExecute() {
                            for (CSSDiagramImpl diag : mapDiagramViews.keySet()) {
                                for (View view : (List)mapDiagramViews.get(diag)) {
                                    if (view instanceof CSSShapeImpl) {
                                        ((View)view.eContainer()).removeChild(view);
                                    }
                                    if (!(view instanceof CSSConnectorImpl)) continue;
                                    view.setVisible(false);
                                    diag.removeEdge((Edge)((CSSConnectorImpl)view));
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            Activator.error("Exception while trying to remove orphan views", e);
        }
    }

    private static void checkNestedOrphanView(View view, List<View> viewToDelete) {
        CSSShapeImpl shape = null;
        for (Object childView : view.getChildren()) {
            if (childView instanceof CSSShapeImpl && (shape = (CSSShapeImpl)childView).getElement() != null && shape.getElement().eIsProxy()) {
                viewToDelete.add((View)shape);
            }
            CHESSEditorUtils.checkNestedOrphanView((View)childView, viewToDelete);
        }
    }
}

