/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.impl;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.chess.fla.common.TransformationException;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flamm.analysis.FlaSystem;
import org.polarsys.chess.fla.flaxml.FlaxmlPackage;
import org.polarsys.chess.fla.flaxml.util.FlaxmlResourceFactoryImpl;
import org.polarsys.chess.fla.impl.FlaAnalysisRunner;
import org.polarsys.chess.fla.transformations.QVToTransformation;

public class FlaAnalysisRunnerXml
extends FlaAnalysisRunner {
    protected IFile selectedXmlFile;

    public void setSelectedXmlFile(IFile file) {
        this.selectedXmlFile = file;
    }

    @Override
    protected void runInput2FlaTransformation(IProgressMonitor monitor) throws TransformationException {
        Resource xmlResource = this.readXml(this.iFileToUri(this.selectedXmlFile));
        URI flaMMUri = this.createFlaModelUri().appendFileExtension("flamm");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        new File(flaMMUri.path()).delete();
        this.flaResource = resourceSet.createResource(flaMMUri);
        QVToTransformation transformation = new QVToTransformation();
        transformation.performConcertoFlaXml2ConcertoFlaTransformation(xmlResource, this.flaResource, monitor);
    }

    @Override
    protected void backpropagateAnalysisResults(FlaSystem system, IProgressMonitor monitor) {
    }

    @Override
    protected String getModelName() {
        return this.selectedXmlFile.getName().substring(0, this.selectedXmlFile.getName().lastIndexOf(46));
    }

    protected Resource readXml(URI uri) {
        FlaxmlPackage.eINSTANCE.eClass();
        FlammPackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xml", new FlaxmlResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        return resource;
    }

    URI iFileToUri(IFile iFile) {
        return URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
    }
}

