/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.request;

import eu.fbk.tools.Request;
import eu.fbk.tools.RequestProvider;
import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.oslc.OslcAutomationServiceConsumer;
import eu.fbk.tools.adapter.oslc.OslcToolConsumer;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.preferences.PreferenceUtils;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.result.ResultProcessorFactory;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lyo.client.oslc.OslcClient;
import org.eclipse.lyo.oslc4j.automation.AutomationPlan;
import org.eclipse.lyo.oslc4j.automation.AutomationRequest;
import org.eclipse.lyo.oslc4j.automation.AutomationResource;
import org.eclipse.lyo.oslc4j.automation.AutomationResult;
import org.eclipse.lyo.oslc4j.automation.ParameterInstance;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class RequestView
extends ViewPart {
    public static final String ID = "eu.fbk.tools.adapter.ui.views.request.RequestView";
    private TableViewer viewer;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.createViewer(parent);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Request r1 = (Request)e1;
                Request r2 = (Request)e2;
                return -r1.getTimestamp().compareTo(r2.getTimestamp());
            }
        });
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)RequestProvider.getInstance().getRequests());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTable());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.removeAll();
                RequestView.this.fillContextMenu(mgr);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object row = selection.getFirstElement();
                if (row instanceof Request) {
                    RequestView.this.displayResult((Request)row);
                }
            }
        });
        this.viewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        ArrayList<String> titles = new ArrayList<String>(Arrays.asList("Id", "Function", "Status", "Date", "Duration (sec)", "Result", "User", "Notes"));
        ArrayList<Integer> bounds = new ArrayList<Integer>(Arrays.asList(0, 200, 80, 180, 100, 70, 100, 200));
        if (PreferenceUtils.isDevelopmentModeEnabled()) {
            titles.add("Request URI");
            titles.add("Result File");
            bounds.add(200);
            bounds.add(200);
        }
        int index = 0;
        TableViewerColumn col = this.createTableViewerColumn((String)titles.get(index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                return request.getKey();
            }
        });
        col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                return request.getFunctionName();
            }
        });
        col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                String value = request.getStatus() == null ? Request.RequestStatus.unknown.name() : request.getStatus().name().replace("_", " ");
                return value;
            }
        });
        col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                return request.getTimestamp().toString();
            }
        });
        col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                String value = request.getDuration() == null ? "" : request.getDuration().toString();
                return value;
            }
        });
        col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                String value = request.getResultStatus() == null ? Request.ResultStatus.unknown.name() : request.getResultStatus().toString();
                return value;
            }
        });
        col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                String value = request.getUser() == null ? "" : request.getUser();
                return value;
            }
        });
        col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Request request = (Request)element;
                String value = request.getNotes() == null ? "" : request.getNotes();
                return value;
            }
        });
        if (PreferenceUtils.isDevelopmentModeEnabled()) {
            col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Request request = (Request)element;
                    String value = request.getRequestUri() == null ? "" : request.getRequestUri().toString();
                    return value;
                }
            });
            col = this.createTableViewerColumn((String)titles.get(++index), (Integer)bounds.get(index), index);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Request request = (Request)element;
                    String value = request.getResultFile() == null ? "" : request.getResultFile().toString();
                    return value;
                }
            });
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setFocus() {
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        menuManager.add((IAction)new Action("Download results from provider"){

            public boolean isEnabled() {
                return PreferenceUtils.isOslcEnabled();
            }

            public void run() {
                Job job = new Job("Download results from provider"){

                    protected IStatus run(IProgressMonitor monitor) {
                        String id;
                        String url = PreferenceUtils.getOslcServiceProviderRegistryUrl();
                        OslcAutomationServiceConsumer consumer = new OslcAutomationServiceConsumer(url, id = PreferenceUtils.getOslcAutomationServiceProviderId());
                        AutomationResource[] requests = consumer.getAutomationRequests();
                        if (requests == null) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.beginTask("Executing the command ...", -1);
                        for (Request request : new ArrayList(RequestProvider.getInstance().getRequests())) {
                            if (request.getRequestUri() == null) continue;
                            RequestProvider.getInstance().removeRequest(request.getKey());
                        }
                        AutomationResource[] automationResourceArray = requests;
                        int n = requests.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block6: {
                                Request request;
                                block7: {
                                    String userName;
                                    URI firstCreator;
                                    AutomationPlan autoPlan;
                                    URI planUri;
                                    AutomationResource resource = automationResourceArray[n2];
                                    AutomationRequest autoRequest = (AutomationRequest)resource;
                                    if (autoRequest.getCreated() == null || autoRequest.getExecutesAutomationPlan() == null || (planUri = (URI)autoRequest.getExecutesAutomationPlan().getValue()) == null || (autoPlan = consumer.getAutomationPlan(planUri)) == null) break block6;
                                    String key = UUID.randomUUID().toString();
                                    request = new Request(key);
                                    request.setFunctionName(autoPlan.getTitle());
                                    request.setRequestUri(autoRequest.getAbout().toString());
                                    request.setTimestamp(autoRequest.getCreated());
                                    if (autoRequest.getCreators().length < 1 || StringUtils.isBlank((CharSequence)(firstCreator = autoRequest.getCreators()[0]).getPath())) break block7;
                                    String requestUserName = new File(firstCreator.getPath()).getName();
                                    String string = userName = StringUtils.isBlank((CharSequence)System.getProperty("user.name")) ? "unknown" : System.getProperty("user.name");
                                    if (!requestUserName.equals(userName)) break block6;
                                    request.setUser(requestUserName);
                                }
                                RequestView.this.updateRequestStatus(request);
                                RequestProvider.getInstance().addRequest(request);
                            }
                            ++n2;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RequestView.this.getViewer().refresh();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        });
        menuManager.add((IAction)new Action("Update"){

            public boolean isEnabled() {
                return RequestView.this.viewer.getTable().getSelectionCount() > 0;
            }

            public void run() {
                TableItem[] selections = RequestView.this.viewer.getTable().getSelection();
                if (selections != null && selections.length > 0) {
                    TableItem[] tableItemArray = selections;
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem selection = tableItemArray[n2];
                        String key = selection.getText(0);
                        Request request = RequestProvider.getInstance().getRequest(key);
                        if (request != null) {
                            RequestView.this.updateRequestStatus(request);
                        }
                        ++n2;
                    }
                    RequestView.this.getViewer().refresh();
                }
            }
        });
        menuManager.add((IAction)new Action("Show result"){

            public boolean isEnabled() {
                return RequestView.this.viewer.getTable().getSelectionCount() == 1;
            }

            public void run() {
                TableItem[] selections = RequestView.this.viewer.getTable().getSelection();
                if (selections != null) {
                    String key = selections[0].getText(0);
                    Request request = RequestProvider.getInstance().getRequest(key);
                    if (request != null) {
                        RequestView.this.displayResult(request);
                    }
                }
            }
        });
        menuManager.add((IAction)new Action("Delete"){

            public boolean isEnabled() {
                return RequestView.this.viewer.getTable().getSelectionCount() > 0;
            }

            public void run() {
                TableItem[] selections = RequestView.this.viewer.getTable().getSelection();
                if (selections != null && selections.length > 0) {
                    TableItem[] tableItemArray = selections;
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block9: {
                            TableItem selection = tableItemArray[n2];
                            String key = selection.getText(0);
                            Request request = RequestProvider.getInstance().getRequest(key);
                            if (request != null && request.getStatus() == Request.RequestStatus.completed) {
                                String resultFile;
                                block8: {
                                    if (!StringUtils.isBlank((CharSequence)request.getRequestUri())) {
                                        try {
                                            String userName;
                                            OslcClient client = new OslcClient();
                                            String url = PreferenceUtils.getOslcServiceProviderRegistryUrl();
                                            String id = PreferenceUtils.getOslcAutomationServiceProviderId();
                                            OslcAutomationServiceConsumer consumer = new OslcAutomationServiceConsumer(url, id);
                                            AutomationRequest autoRequest = consumer.getAutomationRequest(URI.create(request.getRequestUri()));
                                            if (autoRequest == null) break block8;
                                            if (autoRequest.getCreators().length == 0) break block9;
                                            String firstCreator = new File(autoRequest.getCreators()[0].getPath()).getName();
                                            String string = userName = StringUtils.isBlank((CharSequence)System.getProperty("user.name")) ? "unknown" : System.getProperty("user.name");
                                            if (!firstCreator.equals(userName)) break block9;
                                            AutomationResult autoResult = consumer.getAutomationResult(autoRequest);
                                            if (autoResult != null) {
                                                client.deleteResource(autoResult.getAbout().toString());
                                            }
                                            client.deleteResource(autoRequest.getAbout().toString());
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                if (!StringUtils.isBlank((CharSequence)(resultFile = request.getResultFile()))) {
                                    File file = new File(resultFile);
                                    FileUtils.deleteDirectory((File)new File(file.getParent()));
                                }
                                RequestProvider.getInstance().removeRequest(key);
                            }
                        }
                        ++n2;
                    }
                    RequestView.this.getViewer().refresh();
                }
            }
        });
        menuManager.add((IAction)new Action("Open working directory"){

            public boolean isEnabled() {
                return RequestView.this.viewer.getTable().getSelectionCount() == 1;
            }

            public void run() {
                TableItem[] selections = RequestView.this.viewer.getTable().getSelection();
                if (selections != null) {
                    String key = selections[0].getText(0);
                    Request request = RequestProvider.getInstance().getRequest(key);
                    if (request != null && !StringUtils.isBlank((CharSequence)request.getWorkingDir())) {
                        try {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            FileDialog fd = new FileDialog(shell, 4096);
                            fd.setFilterPath(request.getWorkingDir());
                            fd.setText("Request Working Directory");
                            String fileName = fd.open();
                            if (!StringUtils.isBlank((CharSequence)fileName)) {
                                IFileStore fileStore = EFS.getLocalFileSystem().getStore(new File(fileName).toURI());
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                try {
                                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                                }
                                catch (PartInitException partInitException) {}
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    protected void loadResult(Request request) {
        if (request.getResultStatus() != Request.ResultStatus.available) {
            return;
        }
        if (!StringUtils.isBlank((CharSequence)request.getResultFile()) && new File(request.getResultFile()).exists()) {
            return;
        }
        String requestUri = request.getRequestUri();
        if (requestUri != null && PreferenceUtils.isOslcEnabled()) {
            String functionName = request.getFunctionName();
            String url = PreferenceUtils.getOslcServiceProviderRegistryUrl();
            String id = PreferenceUtils.getOslcAutomationServiceProviderId();
            OslcToolConsumer consumer = new OslcToolConsumer(functionName, url, id);
            consumer.setWorkspaceDir(Activator.getDefault().getPreferenceStore().getString("tools.workspace"));
            if (!StringUtils.isBlank((CharSequence)request.getWorkingDir())) {
                consumer.setSessionWorkspaceDir(new File(request.getWorkingDir()));
            }
            consumer.setupExecutionEnvironment();
            if (consumer.loadResult(URI.create(requestUri)) && consumer.getResultFile() != null && consumer.getResultFile().exists()) {
                request.setResultFile(consumer.getResultFile().toString());
                request.setDuration(Float.valueOf((float)consumer.getExecutionDuration() / 1000.0f));
            }
        }
    }

    protected void updateRequestStatus(Request request) {
        String id;
        if (!PreferenceUtils.isOslcEnabled()) {
            return;
        }
        if (request.getStatus() == Request.RequestStatus.completed) {
            return;
        }
        String url = PreferenceUtils.getOslcServiceProviderRegistryUrl();
        OslcAutomationServiceConsumer consumer = new OslcAutomationServiceConsumer(url, id = PreferenceUtils.getOslcAutomationServiceProviderId());
        AutomationRequest autoRequest = consumer.getAutomationRequest(URI.create(request.getRequestUri()));
        if (autoRequest.getStates()[0].compareTo(URI.create("http://open-services.net/ns/auto#complete")) == 0) {
            request.setStatus(Request.RequestStatus.completed);
        } else if (autoRequest.getStates()[0].compareTo(URI.create("http://open-services.net/ns/auto#inProgress")) == 0) {
            request.setStatus(Request.RequestStatus.in_progress);
        } else {
            request.setStatus(Request.RequestStatus.unknown);
        }
        AutomationResult autoResult = consumer.getAutomationResult(autoRequest);
        if (autoResult == null) {
            request.setResultStatus(Request.ResultStatus.unknown);
            this.getViewer().refresh();
            return;
        }
        Optional<ParameterInstance> duration = Arrays.asList(autoResult.getOutputParameters()).stream().filter(instance -> instance.getName().contentEquals("executionDuration")).findFirst();
        Optional<ParameterInstance> error = Arrays.asList(autoResult.getOutputParameters()).stream().filter(instance -> instance.getName().contentEquals("standardError")).findFirst();
        if (error.isPresent()) {
            request.setNotes(error.get().getValue());
        }
        if (autoResult.getVerdicts()[0].compareTo(URI.create("http://open-services.net/ns/auto#passed")) == 0) {
            request.setResultStatus(Request.ResultStatus.available);
            if (duration.isPresent()) {
                request.setDuration(Float.valueOf(Float.valueOf(duration.get().getValue()).floatValue() / 1000.0f));
            }
        } else if (autoResult.getVerdicts()[0].compareTo(URI.create("http://open-services.net/ns/auto#error")) == 0) {
            request.setResultStatus(Request.ResultStatus.failure);
        } else if (autoResult.getVerdicts()[0].compareTo(URI.create("http://open-services.net/ns/auto#failed")) == 0) {
            request.setResultStatus(Request.ResultStatus.failure);
        } else {
            request.setResultStatus(Request.ResultStatus.unknown);
        }
    }

    private void displayResult(Request request) {
        if (request.getStatus() == Request.RequestStatus.in_progress) {
            this.updateRequestStatus(request);
            this.getViewer().refresh();
        }
        if (request.getStatus() == Request.RequestStatus.completed && request.getResultStatus() == Request.ResultStatus.available) {
            this.loadResult(request);
            String functionName = request.getFunctionName();
            ResultProcessor processor = ResultProcessorFactory.getProcessor(functionName);
            if (!StringUtils.isBlank((CharSequence)request.getResultFile())) {
                processor.setResultFile(new File(request.getResultFile()));
            }
            if (!StringUtils.isBlank((CharSequence)request.getExtResultFile())) {
                processor.setExtResultFile(new File(request.getExtResultFile()));
            }
            if (processor.processResult()) {
                processor.displayResult();
                this.getViewer().refresh();
            }
        }
    }
}

