/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result.safety;

import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.views.faulttree.FaultTreeView;
import eu.fbk.tools.adapter.xsap.ComputeFaultTreeResultBuilder;
import eu.fbk.tools.adapter.xsap.tree.FaultTree;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeFaultTreeResultProcessor
extends ResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ComputeFaultTreeResultProcessor.class);
    private FaultTree faultTree;

    public ComputeFaultTreeResultProcessor(String functionName) {
        super(functionName);
    }

    @Override
    public boolean processResult() {
        if (!this.resultFileExists()) {
            return false;
        }
        ComputeFaultTreeResultBuilder resultBuilder = new ComputeFaultTreeResultBuilder();
        this.faultTree = resultBuilder.unmarshalResult(this.resultFile);
        if (this.faultTree == null || this.faultTree.getGate() == null) {
            this.displayError(this.functionName, "Internal error while umarshalling the result. For more info see the console");
            return false;
        }
        return true;
    }

    @Override
    public void displayResult() {
        if (this.faultTree == null) {
            return;
        }
        String commandName = null;
        String parameterName = null;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor("eu.fbk.tools.adapter.ui.externViewer");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("faultTreeViewerCommand")) {
                    commandName = element.getAttribute("commandId");
                    parameterName = element.getAttribute("parameterName");
                }
                ++n2;
            }
        }
        try {
            if (!StringUtils.isBlank(commandName) && !StringUtils.isBlank(parameterName)) {
                File extResultFile = this.getExtResultFile();
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = commandService.getCommand(commandName);
                if (command != null && command.isDefined() && command.isEnabled() && extResultFile != null && extResultFile.exists()) {
                    logger.debug("Found external command for showing fault-tree");
                    IParameter modelPath = command.getParameter(parameterName);
                    if (modelPath != null) {
                        logger.debug("Fault-tree file: " + extResultFile.getAbsolutePath());
                        Parameterization parm = new Parameterization(modelPath, extResultFile.getAbsolutePath());
                        ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parm});
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        handlerService.executeCommand(parmCommand, null);
                        return;
                    }
                    this.displayError(this.functionName, "Internal error: while processing the command parameters. For more info see the console");
                    logger.error("Command parameter " + parameterName + " not found");
                } else {
                    logger.debug("Command " + commandName + " not found, cannot display fault tree on external plugin");
                }
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            try {
                FaultTreeView viewPart = (FaultTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.fbk.tools.adapter.ui.views.faulttree.FaultTreeView", null, 2);
                if (viewPart != null) {
                    TreeViewer treeViewer = viewPart.getTreeViewer();
                    IContentProvider provider = treeViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    provider.inputChanged((Viewer)treeViewer, null, (Object)this.faultTree);
                    treeViewer.refresh();
                    treeViewer.expandAll();
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)viewPart);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
    }
}

