/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result.behaviour;

import eu.fbk.tools.adapter.nusmv.CounterExample;
import eu.fbk.tools.adapter.nuxmv.CheckBehaviourResultBuilder;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.views.trace.TraceViewPart;
import eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckModelResultProcessor
extends ResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CheckModelResultProcessor.class);
    private ModelCheckResult behaviourCheckResult;

    public CheckModelResultProcessor(String functionName) {
        super(functionName);
    }

    @Override
    public boolean processResult() {
        this.behaviourCheckResult = null;
        CheckBehaviourResultBuilder resultBuilder = new CheckBehaviourResultBuilder();
        if (this.resultFileExists()) {
            CounterExample counterExample = resultBuilder.unmarshalResult(this.resultFile);
            if (counterExample == null || counterExample.getDesc() == null || counterExample.getId() == null || counterExample.getNode() == null) {
                this.displayError(this.functionName, "Internal error while processing the result. For more info see the console");
                return false;
            }
            this.behaviourCheckResult = resultBuilder.buildResult(this.functionName, "", counterExample);
        } else {
            this.behaviourCheckResult = resultBuilder.buildResult(this.functionName, "");
        }
        if (this.behaviourCheckResult == null) {
            this.displayError(this.functionName, "Internal error while processing the result. For more info see the console");
            return false;
        }
        return true;
    }

    @Override
    public void displayResult() {
        if (this.behaviourCheckResult == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            try {
                BehaviourTraceViewer traceViewPart = (BehaviourTraceViewer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceViewer", null, 2);
                if (traceViewPart != null) {
                    TreeViewer treeViewer = ((TraceViewPart)traceViewPart).getTreeViewer();
                    IContentProvider provider = treeViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)traceViewPart);
                    provider.inputChanged((Viewer)treeViewer, null, (Object)this.behaviourCheckResult);
                    ((TraceViewPart)traceViewPart).refresh();
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        });
    }
}

