/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result;

import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.result.behaviour.CheckModelResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.CheckContractResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.GetParametersFromParamArchitectureResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.InstantiateParamArchitectureResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.PrintSystemImplementationResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ComputeFaultTreeResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ComputeFmeaTableResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ExpandFeiResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ExtendModelResultProcessor;

public class ResultProcessorFactory {
    public static ResultProcessor getProcessor(String functionName) {
        switch (functionName) {
            case "ocra_check_validation_prop": 
            case "ocra_check_refinement": 
            case "ocra_check_composite_impl": 
            case "ocra_check_implementation": {
                return new CheckContractResultProcessor(functionName);
            }
            case "xsap_compute_fault_tree": 
            case "ocra_compute_fault_tree": {
                return new ComputeFaultTreeResultProcessor(functionName);
            }
            case "ocra_print_system_implementation": {
                return new PrintSystemImplementationResultProcessor(functionName);
            }
            case "nuxmv_check_model": {
                return new CheckModelResultProcessor(functionName);
            }
            case "expand_fault_extensions": {
                return new ExpandFeiResultProcessor(functionName);
            }
            case "xsap_extend_model": {
                return new ExtendModelResultProcessor(functionName);
            }
            case "xsap_compute_fmea_table": {
                return new ComputeFmeaTableResultProcessor(functionName);
            }
            case "ocra_get_required_arch_params": {
                return new GetParametersFromParamArchitectureResultProcessor(functionName);
            }
            case "ocra_instantiate_parametric_arch": {
                return new InstantiateParamArchitectureResultProcessor(functionName);
            }
        }
        return null;
    }
}

