/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.preferences.tools;

import eu.fbk.tools.adapter.ui.preferences.CommonPreferencePage;
import eu.fbk.tools.adapter.ui.preferences.tools.LocalToolPreferences;
import eu.fbk.tools.adapter.ui.preferences.tools.OslcToolPreferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ToolsPreferencePage
extends CommonPreferencePage
implements IWorkbenchPreferencePage {
    private final LocalToolPreferences localToolPreferences = new LocalToolPreferences();
    private final OslcToolPreferences oslcToolPreferences = new OslcToolPreferences(this.getPreferenceStore());
    private Composite localToolCompositeRoot;
    private Composite oslcToolCompositeRoot;
    private Color activeColor;
    private Color defaultColor;

    public void init(IWorkbench workbench) {
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        this.localToolCompositeRoot = this.localToolPreferences.create(parent);
        for (FieldEditor fieldEditor : this.localToolPreferences.getFieldEditors()) {
            this.addField(fieldEditor);
        }
        this.widgets.add(this.localToolCompositeRoot);
        this.oslcToolCompositeRoot = this.oslcToolPreferences.create(parent);
        for (FieldEditor fieldEditor : this.oslcToolPreferences.getFieldEditors()) {
            this.addField(fieldEditor);
        }
        this.widgets.add(this.oslcToolCompositeRoot);
        BooleanFieldEditor oslcEnabled = new BooleanFieldEditor("oslc.serviceprovider.enables", "OSLC Enabled", composite);
        oslcEnabled.getDescriptionControl(composite).setToolTipText("Enable oslc");
        this.addField((FieldEditor)oslcEnabled);
        Display display = Display.getCurrent();
        this.activeColor = display.getSystemColor(1);
        this.defaultColor = parent.getBackground();
        boolean oslc = this.getPreferenceStore().getBoolean("oslc.serviceprovider.enables");
        this.highlightSelection(oslc);
        this.localToolCompositeRoot.pack();
        this.oslcToolCompositeRoot.pack();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.localToolPreferences.updateAllTestButtonStatus(false);
        return control;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getNewValue() instanceof Boolean) {
            this.highlightSelection((Boolean)event.getNewValue());
        }
        this.localToolPreferences.propertyChange(event);
    }

    @Override
    protected void performApply() {
        super.performApply();
        this.localToolPreferences.performApply();
        this.oslcToolPreferences.performApply();
    }

    private void highlightSelection(boolean oslc) {
        if (oslc) {
            this.localToolCompositeRoot.setBackground(this.defaultColor);
            this.oslcToolCompositeRoot.setBackground(this.activeColor);
        } else {
            this.oslcToolCompositeRoot.setBackground(this.defaultColor);
            this.localToolCompositeRoot.setBackground(this.activeColor);
        }
    }
}

