/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.behaviour;

import eu.fbk.tools.adapter.nuxmv.CheckModel;
import eu.fbk.tools.adapter.nuxmv.NuxmvFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NuxmvParametersDialog
extends Dialog {
    private CheckModel function;
    private Combo comboCheckType;
    private Combo comboAlgorithmType;
    private Text propertyText;
    private Button asyncCheckBox;
    private Boolean asyncExecution = false;
    private String[] checkTypes = new String[]{"invar", "ltlspec", "ctlspec"};
    private String[] algorithmTypes = new String[]{"", "bmc", "ic3"};
    private boolean goAhead = false;

    public NuxmvParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public NuxmvParametersDialog(Shell parentShell, CheckModel function, Boolean asyncExecution) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("nuXmv parameters");
    }

    protected void okPressed() {
        try {
            this.function.setCheckType(NuxmvFunction.CheckType.valueOf((String)this.comboCheckType.getItems()[this.comboCheckType.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        try {
            this.function.setAlgorithmType(NuxmvFunction.AlgorithmType.valueOf((String)this.comboAlgorithmType.getItems()[this.comboAlgorithmType.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        this.function.setFormula(this.propertyText.getText());
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        Label lblCheck = new Label(container2, 0);
        lblCheck.setText("Check Type");
        this.comboCheckType = new Combo(container2, 8);
        this.comboCheckType.setLayoutData((Object)gd_combo);
        this.setComboValues(this.comboCheckType, this.checkTypes, this.function.getCheckType() == null ? "" : this.function.getCheckType().name());
        Label lblAlgorithm = new Label(container2, 0);
        lblAlgorithm.setText("Algorithm Type");
        this.comboAlgorithmType = new Combo(container2, 8);
        this.comboAlgorithmType.setLayoutData((Object)gd_combo);
        this.setComboValues(this.comboAlgorithmType, this.algorithmTypes, this.function.getAlgorithmType() == null ? "" : this.function.getAlgorithmType().name());
        Label lblProperty = new Label(container2, 0);
        lblProperty.setText("Property");
        this.propertyText = new Text(container2, 2626);
        this.propertyText.setLayoutData((Object)new GridData(1808));
        if (!StringUtils.isBlank((CharSequence)this.function.getFormula())) {
            this.propertyText.setText(this.function.getFormula());
        }
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(360, 260);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

